<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;
/**
 * Investments Controller
 *
 * @property \App\Model\Table\InvestmentsTable $Investments
 */
class InvestmentsController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Customers','Mutualfunds', 'Products', 'Mffunds', 'Banks', 'Bankbranches']
        ];
        $investments = $this->paginate($this->Investments);

        $this->set(compact('investments'));
        $this->set('_serialize', ['investments']);
    }

    /**
     * View method
     *
     * @param string|null $id Investment id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $investment = $this->Investments->get($id, [
            'contain' => ['Customers','Mutualfunds', 'Products', 'Mffunds','Banks', 'Bankbranches']
        ]);

        $this->set('investment', $investment);
        $this->set('_serialize', ['investment']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $investment = $this->Investments->newEntity();
        if ($this->request->is('post')) {
            $investment = $this->Investments->patchEntity($investment, $this->request->data);
 
            if ($this->Investments->save($investment)) {
                $this->Flash->success(__('The investment has been saved.'));
            
                return $this->redirect(['controller' => 'Mutualfunds','action' => 'edit',$investment->mutualfund_id]);
                //return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The investment could not be saved. Please, try again.'));
            }
        }
        $customers = $this->Investments->Customers->find('list', ['limit' => 200]);
        $products = $this->Investments->Products->find('list', ['limit' => 200]);
        $mffunds = $this->Investments->Mffunds->find('list', ['limit' => 200]);
        $mutualfunds = $this->Investments->Mutualfunds->find('list', ['limit' => 200]);
       
        $banks = $this->Investments->Banks->find('list', ['limit' => 200]);
        $bankbranches = $this->Investments->Bankbranches->find('list', ['limit' => 200]);
        $this->set(compact('investment','mutualfunds' ,'customers', 'products', 'mffunds', 'banks', 'bankbranches'));
        $this->set('_serialize', ['investment']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Investment id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $investment = $this->Investments->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $investment = $this->Investments->patchEntity($investment, $this->request->data);
            if ($this->Investments->save($investment)) {
                $this->Flash->success(__('The investment has been saved.'));

                return $this->redirect(['controller' => 'Mutualfunds','action' => 'edit',$investment->mutualfund_id]);
            } else {
                $this->Flash->error(__('The investment could not be saved. Please, try again.'));
            }
        }
        $customers = $this->Investments->Customers->find('list', ['limit' => 200]);
        $products = $this->Investments->Products->find('list', ['limit' => 200]);
        $mffunds = $this->Investments->Mffunds->find('list', ['limit' => 200]);
        $mutualfunds = $this->Investments->Mutualfunds->find('list', ['limit' => 200]);
        
        $banks = $this->Investments->Banks->find('list', ['limit' => 200]);
        $bankbranches = $this->Investments->Bankbranches->find('list', ['limit' => 200]);
        $this->set(compact('investment','mutualfunds' , 'customers', 'products', 'mffunds', 'banks', 'bankbranches'));
        $this->set('_serialize', ['investment']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Investment id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
       // $this->request->allowMethod(['post', 'delete']);
        $investment = $this->Investments->get($id);
       
        if ($this->Investments->delete($investment)) {
            $this->Flash->success(__('The investment has been deleted.'));
        } else {
            $this->Flash->error(__('The investment could not be deleted. Please, try again.'));
        }
        
         
       return $this->redirect(['controller' => 'Mutualfunds','action' => 'edit',$investment->mutualfund_id]);
        //return $this->redirect(['action' => 'index']);
    }
}
