<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * Eunis Controller
 *
 * @property \App\Model\Table\EunisTable $Eunis
 */
class EunisController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Companies']
        ];
        $eunis = $this->paginate($this->Eunis);

        $this->set(compact('eunis'));
        $this->set('_serialize', ['eunis']);
    }

    /**
     * View method
     *
     * @param string|null $id Euni id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $euni = $this->Eunis->get($id, [
            'contain' => ['Companies']
        ]);

        $this->set('euni', $euni);
        $this->set('_serialize', ['euni']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $euni = $this->Eunis->newEntity();
        if ($this->request->is('post')) {
            $euni = $this->Eunis->patchEntity($euni, $this->request->data);
            if ($this->Eunis->save($euni)) {
                $this->Flash->success(__('The euni has been saved.'));

                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The euni could not be saved. Please, try again.'));
            }
        }
        $companies = $this->Eunis->Companies->find('list')-> where(['associatewith' => 'user'])->order(['company' => 'ASC']);
        $this->set(compact('euni', 'companies'));
        $this->set('_serialize', ['euni']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Euni id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $euni = $this->Eunis->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $euni = $this->Eunis->patchEntity($euni, $this->request->data);
            if ($this->Eunis->save($euni)) {
                $this->Flash->success(__('The euni has been saved.'));

                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The euni could not be saved. Please, try again.'));
            }
        }
        $companies = $this->Eunis->Companies->find('list')-> where(['associatewith' => 'user'])->order(['company' => 'ASC']);
        $this->set(compact('euni', 'companies'));
        $this->set('_serialize', ['euni']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Euni id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $euni = $this->Eunis->get($id);
        if ($this->Eunis->delete($euni)) {
            $this->Flash->success(__('The euni has been deleted.'));
        } else {
            $this->Flash->error(__('The euni could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
