
<style>
    .scrollabletable{
         max-height: 300px;
        overflow-y: auto;
        border: 1px solid #ccc;
        }
</style>
<?php //pr($fds); die();
 ?>
<?php
use Cake\Routing\Router;
use Cake\View\Helper\UrlHelper;
?>
<?php  use Cake\ORM\TableRegistry;
    $companies = TableRegistry::get('Companies');
    $branches = TableRegistry::get('Branches');
    $brokers = TableRegistry::get('Brokers');
    $users = TableRegistry::get('Users');
?>
<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <?= $this->element('admin_sidebar') ?>
</nav>
<div class="fds index large-9 medium-8 columns content">
    <div class="col-md-3">
        <h3><?= __('Sub-Brokrage Payments Report') ?></h3>
    </div>

    <div>
        <?php
        $export = array_merge($this->request->query,array('export' => 'xls'));
        $exportpdf = array_merge($this->request->query,array('export' => 'pdf'));
        ?>
        <div class="btn-link">
            <?= $this->Html->link(__('Excel Export'),['controller' => 'Reports', 'action' => 'subbrokerage','?'=>$export],['class'=>'green-btn']); ?>
            <?= $this->Html->link(__('Pdf Export'),['controller' => 'Reports', 'action' => 'subbrokerage','?'=>$exportpdf],['class'=>'green-btn']); ?>
        </div> 
    </div>

    <div class="search-wrapper">
        <div class="col-md-12">
            <div class="search-filter">
                <div class=""><?= $this->Search->filterForm($searchFilters) ?></div>
            </div>
        </div>
    </div>

     <table class="tbl-wrapper" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th rowspan="3"><input type="checkbox" value="1" name="checkall" /> </th>
                <th style="width:40px;" rowspan="3"><?= $this->Paginator->sort('Sr No') ?></th>
                <th rowspan="3"><?= $this->Paginator->sort('Applicant Name') ?></th>
                <th colspan="1" rowspan="1"><?= $this->Paginator->sort('Referred By') ?></th>
                <!-- <th rowspan="3"><?= $this->Paginator->sort('Branch') ?></th> -->
                <th olspan="1" rowspan="1"><?= $this->Paginator->sort('Deposit type') ?></th>
                <!-- <th rowspan="3"><?= $this->Paginator->sort('period (months)') ?></th> -->
                <th rowspan="3"><?= $this->Paginator->sort('company') ?></th>
                <th rowspan="3"><?= $this->Paginator->sort('Investment Amount') ?></th>
                <th rowspan="3"><?= $this->Paginator->sort('created') ?></th>
                <th rowspan="3"><?= $this->Paginator->sort('Sub-Brokrage Paid') ?></th>
                <th colspan="8" class="text-center">Sub-brokerage Paid Details</th>
            </tr>
            <tr>
                <th rowspan="2">Branch</th>
                <th rowspan="2">Period</th>
            </tr>
            <tr>
                <th>Sub-Broker</th><th>Percent</th><th>Sub-Broker Amount</th><th>TDS Percent</th><th>Net Amount</th><th>Bank Name</th><th>Cheque No</th><th>Paid Date</th>
            </tr>
        </thead>
         <tbody>
            <?php 
                $srlno = ($this->request->params['paging']['Fds']['page']-1) * $this->request->params['paging']['Fds']['perPage'];
                $i=1;$total='';
                foreach ($fds as $fd): $srlno++;
            ?>
            <tr>
                <td><input type="checkbox" value="<?php echo h($fd->id) ?>" name="listitems" <?= ($fd->sub_brokerage_paid == 1) ? 'disabled' : '' ?> /> </td>
                <td><?= $srlno ?></td>
                <td><?php 
                        if($fd->minor == 1) {
                             echo  $fd->minorname.'&nbsp;&nbsp;U/G&nbsp;&nbsp;'.$fd->fapplicantname;
                          }else{
                              echo  $fd->fapplicantname;
                    } ?>
                </td>
                
                <td>
                    <?php echo isset($subbrokers[$fd->subbroker_id]) ? $subbrokers[$fd->subbroker_id] : ''; ?> 
                    <hr style="margin: 0.5rem 0 0.5rem;">
                    <?php if($fd->branch_id){
                        $branch = $branches->find()->where(['id' => $fd->branch_id]);
                        $branchdata = $branch->toArray();
                        $branchname = $branchdata[0]->branchname;
                    }else{
                        $branchname = '';
                    } ?>
                    <?= $branchname ?>
                </td>

                <td><?php 
                    if($fd->typeofdeposit == 'onlinerenewal'){
                        echo 'online renewal';
                    }else if($fd->typeofdeposit == 'onlinefresh'){
                        echo 'online fresh';
                    }else{
                        echo $fd->typeofdeposit ;
                    } ?> <hr style="margin: 0.5rem 0 0.5rem;">
                    <?php if($fd->tenure == 0){echo '';} else{echo $fd->tenure;} ?>
                </td>

                
                <td><?php if($fd->productcompanyid > 0) {
                        $productcompanyid = $companies->find()->where(['id' => $fd->productcompanyid]);
                        $data1 = $productcompanyid->toArray();
                        $productcompanyName = $data1[0]->company;
                    }else{
                        $productcompanyName = '';
                    }?>
                    <?=$productcompanyName?>
                </td>
                <td><?php 
                    $amt=h($fd->amount);
                    $fdramt=h($fd->fdramount);
                    $totalamt=$amt+$fdramt;
                    echo $totalamt; ?>
                </td>
                
                
                <td><?php $created = explode(" ", $fd->created);
                        echo $created[0];
                    ?>
                </td>
                <td>
                    <?php
                        if($fd->sub_brokerage_paid == 1){
                            $subbrokragestatus = 'Yes';
                            $statusClass = 'text-success';
                            $payment = $fd->fd_sub_brokerage_payments[0]; 
                            $paymentId = $payment->sub_brokerage_payment->id;

                        }else{
                            $subbrokragestatus = 'No';
                            $statusClass = 'text-danger';
                        }
                    ?>
                    <span class="<?= h($statusClass) ?>"><?= h($subbrokragestatus) ?></span>

                    <?php if ($fd->sub_brokerage_paid == 1): ?>
                        <a class="edit editbutton" data-id="<?= h($paymentId) ?>" title="Edit"></a>
                        <a class="green-btn submitedittextfieldbutton" id="subedit-<?= h($paymentId) ?>" href="javascript:void(0)" style="display:none;">Update</a>
                    <?php endif; ?>
                </td>

                <?php if (!empty($fd->fd_sub_brokerage_payments[0])) {
                       foreach ($fd->fd_sub_brokerage_payments as $fsp): ?>
                   <td><?= $subbrokers[$fsp->sub_brokerage_payment->subbroker_id] ? $subbrokers[$fsp->sub_brokerage_payment->subbroker_id] : 0 ?></td>
                   <td><?= number_format($fsp->percentage,2) ?>%</td>
                   <td><?= number_format($fsp->sub_brokerage_amount,2) ?></td>
                   <td><?= number_format($fsp->tds_amount,2) ?></td>
                   <td><?= number_format($fsp->net_amount,2) ?></td>
                   <td><?= $banks[$fsp->sub_brokerage_payment->bank_id] ? $banks[$fsp->sub_brokerage_payment->bank_id] : '' ?></td>
                   <td><?= $fsp->sub_brokerage_payment->chequeno ?></td>
                   <td><?php $paiddate = explode(" ", $fsp->sub_brokerage_payment->paid_date);
                        echo $paiddate[0];
                    ?>
                    </td>
                <?php   endforeach;  }else { ?>
                    <td colspan="8" class="text-center">No Data</td>
                <?php } ?>
            </tr>
            <?php endforeach;?>
            
            <tr class="total">
                <td colspan="6" style="text-align:right"><b>Overall Grand Total</b></td>
                <td><b><?= number_format($grandTotals['fd_amount']); ?></b></td> 
                <td colspan="4"></td>
                <td><b><?= number_format($grandTotals['sub_brokerage_amount']); ?></b></td>
                <td><b><?= number_format($grandTotals['tds_amount']); ?></b></td>
                <td><b><?= number_format($grandTotals['net_amount']); ?></b></td>
                <td colspan="3"></td>
            </tr>
            
         </tbody>
    </table>

    <div class="col-md-3">
        <?= $this->Form->button(__('Pay Sub-Brokerage Amount'),['id' => __('addSubBrokerage'),'class' => ['pull-left'],'data-toggle'=>'myModalSubbroker']) ?>
    </div>
    <?php if(!empty($querystring['subbroker']) && $querystring['subbroker'] != 'all') {?>
        <div class="col-md-3">
            <?= $this->Form->button(__('PDF Letter & Details'),['class' => ['pull-left','btn-letter-export'],'data-subbrokerid' => h($querystring['subbroker']),'data-toggle'=>'myModalPdfLetter', 'data-type' => 'pdf']) ?>
        </div>
        <div class="col-md-3">
            <?php //echo $this->Form->button(__('Excel Letter & Details'),['class' => ['pull-left','btn-letter-export'],'data-subbrokerid' => h($querystring['subbroker']), 'data-type' => 'xls']) ?>
            
            <a href="<?= $this->Url->build(['controller' => 'Reports','action' => 'getsubbrokerpdfdata','?' => ['id' => $querystring['subbroker'], 'type' => 'xls']]) ?>" class="button" style="line-height: normal;">Excel Letter & Details</a>
        </div>

        


    <?php } ?>

    <div class="btn-link"><input type="button" value="Back" onclick="window.history.back()" class="green-btn" /> </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
        </ul>
        <p><?= $this->Paginator->counter() ?></p>
    </div>
</div>
   
</div>

<script>
$('#minorname').select2();
 var allFDs = <?= json_encode($fds); ?>;
 var subbrokersObj = <?= json_encode($subbrokers); ?>;
 var companiesObj = <?= json_encode($productcompanies); ?>;
 //console.log(allFDs);
$(document).ready(function() { 
    var availableTags = <?=json_encode($custname)?>;
    //console.log(availableTags);
    $( "#autocomplete1" ).autocomplete({
      //source: availableTags,
      source: function(request, response) {
        var results = $.ui.autocomplete.filter(availableTags, request.term);
        response(results.slice(0, 10));
        }
    });

    $('input[name="checkall"]').click(function(){ 
        var isChecked = this.checked;       
        $('input[name="listitems"]').each(function(){
            if (!$(this).is(':disabled')) {
                this.checked = isChecked;
            }
        });
    });
    //on click of edit
    $('.editbutton').click(function() {
        var paymentId = $(this).data('id');
        var siteUrl = '<?php echo $this->Url->build("/", true); ?>';
        var targeturl = siteUrl + 'reports/getsubbrokeragepaymentdata';

        $.ajax({
            url: targeturl,
            method: 'GET',
            data: { id: paymentId },
             dataType: 'json',
            success: function (response) {
                console.log(response);
                
                $('#subbrokerid').val(response.subbroker_id);
                $('#bankid').val(response.bank_id);
                $('#chequeno').val(response.chequeno);
                $('input[name="sub_brokerage_payment_id"]').val(response.id);
                
                if (response.paid_date) {
                    const isoDate = response.paid_date.split('T')[0]; // "2025-06-11"
                    const [year, month, day] = isoDate.split('-');
                    const formattedDate = `${day}/${month}/${year}`;
                    $('#paid-date').val(formattedDate);
                }

                let srNo = 1;
                const fdPayments = response.fd_sub_brokerage_payments;

                $('#selected-fds-table tbody').empty();

                $('#totalSubBrokerageAmount').text(response.total_sub_brokerage_amount);
                $('#totaltdsAmount').text(response.total_tds_amount);
                $('#totalnetAmount').text(response.total_net_amount);

                $('input[name="total_sub_brokerage_amount"]').val(response.total_sub_brokerage_amount);
                $('input[name="total_tds_amount"]').val(response.total_tds_amount);
                $('input[name="total_net_amount"]').val(response.total_net_amount);
                

                fdPayments.forEach(function (fd) {
                    let fdId = fd.fd_id;
                    let percentage = fd.percentage || 0;
                    let sub_brokerage_amount = fd.sub_brokerage_amount || 0;
                    let tds_amount = fd.tds_amount || 0;
                    let net_amount = fd.net_amount || 0;

                    
                     let fdDetails = allFDs.find(item => item.id == fdId);
                     let name = '';
                     let referredby = '';
                     let company = '';
                     let amount = 0;
                     let showDelete = fdPayments.length > 1 ? `<a href="#" class="remove-fd-row" title="Remove"><i class="fas fa-minus text-danger"></i></a>` : '';

                    if (fdDetails) {
                        name = (fdDetails.minor == 1) ? `${fdDetails.minorname} U/G ${fdDetails.fapplicantname}` : fdDetails.fapplicantname;
                        referredby = subbrokersObj[fdDetails.subbroker_id] || '';
                        company = companiesObj[fdDetails.productcompanyid] || '';
                        amount = (parseFloat(fdDetails.amount) || 0) + (parseFloat(fdDetails.fdramount) || 0);
                    }

                    let rowHtml = `
                        <tr data-fdid="${fdId}">
                            <td>
                                <span>${srNo++}</span>
                                ${showDelete}
                            </td>
                            <td>${name}</td>
                            <td>${referredby}</td>
                            <td>${company}</td>
                            <td>${amount}
                                <input type="hidden" name="amount[]" class="amount" value="${amount}">
                                <input type="hidden" name="fd_id[]" value="${fdId}">
                            </td>
                            <td><input type="text" name="percentage[]" class="add-column percentage" value="${percentage}" required></td>
                            <td><input type="text" name="sub_brokerage_amount[]" class="add-column subbrokerageamount" value="${sub_brokerage_amount}" readonly></td>
                            <td><input type="text" name="tds_amount[]" class="add-column tds" value="${tds_amount}" required></td>
                            <td><input type="text" name="net_amount[]" class="add-column netamount" value="${net_amount}" readonly></td>
                        </tr>
                    `;
                    $('#selected-fds-table tbody').append(rowHtml);
                });

                $('#myModalSubbroker').modal('show');
                
                if ($('#sub_brokerage_payment_id').val()) {
                    $('#deletesubbrokerage').show();
                } else {
                    $('#deletesubbrokerage').hide();
                }
            }
        });

    });
    //on click of proceed to pay subbrokrage
    $('#addSubBrokerage').click(function(){
          
        var checkedItems = $('input[name="listitems"]:checked').length; 
        if(checkedItems == 0){
            alert('Please select atleast one record');
            return false;
        }else{

            let selectedIds = [];
            $('input[name="listitems"]:checked').each(function () {
                selectedIds.push($(this).val());
            });
            //alert(selectedIds);
            $('#selected-fds-table tbody').empty();
            $('#addsubbrokerage')[0].reset();
            $('#totalSubBrokerageAmount').text('0.00');
            $('#totaltdsAmount').text('0.00');
            $('#totalnetAmount').text('0.00');

            $('input[name="total_sub_brokerage_amount"]').val('0');
            $('input[name="sub_brokerage_payment_id"]').val('');
            
            let srNo = 1;
            selectedIds.forEach(function (id) {
                 const fd = allFDs.find(item => item.id == id);
                 if(fd){
                     let fdIds = fd.id;
                     let name = (fd.minor == 1) ? `${fd.minorname} U/G ${fd.fapplicantname}` : fd.fapplicantname;
                     let referredby = subbrokersObj[fd.subbroker_id] || '';
                     let company = companiesObj[fd.productcompanyid] || '';
                     let amount = (parseFloat(fd.amount) || 0) + (parseFloat(fd.fdramount) || 0);

                     let rowHtml = `
                    <tr>
                        <td>${srNo++}</td>
                        <td>${name}</td>
                        <td>${referredby}</td>
                        <td>${company}</td>
                        <td>${amount} 
                        <input type="hidden" name ="amount[]" class="amount" value="${amount}">
                        <input type="hidden" name="fd_id[]" value="${fdIds}">
                        </td>
                        <td><input type="text" name="percentage[]" class="add-column percentage" "id"="percentage" value="0" required></td>
                        <td><input type="text" name="sub_brokerage_amount[]" class="add-column subbrokerageamount" value="0" readonly></td>
                        <td><input type="text" name="tds_amount[]" class="add-column tds" value="0" required></td>
                        <td><input type="text" name="net_amount[]" class="add-column netamount" value="0" readonly></td>
                    </tr>
                    `;
                    $('#selected-fds-table tbody').append(rowHtml);
                }
            });
           $('#myModalSubbroker').modal('show');
            if ($('#sub_brokerage_payment_id').val()) {
                $('#deletesubbrokerage').show();
            } else {
                $('#deletesubbrokerage').hide();
            }

        }
    });

    //on click of PDF Letter & Details & excel letter details
    $('.btn-letter-export').click(function(){
        
        var subbrokerId = $(this).data('subbrokerid');
        var type = $(this).data('type');
        
        console.log("Subbrokerid:", subbrokerId);
        if (subbrokerId) {
            var siteUrl = '<?php echo $this->Url->build("/", true); ?>';
            
            var targeturl = siteUrl + 'reports/getsubbrokerletterdata';
            
            if (type === 'pdf') {
                $('#myModalPdfLetter').modal('show');
            }
             
            
            $.ajax({
                url: targeturl,
                method: 'POST',
                data: { id: subbrokerId,type: type  },
                dataType: 'html',
                success: function (response) {
                    //console.log(response);
                    $('#myModalPdfLetter .modal-body').html(response);
                },
                error: function () {
                    $('#myModalPdfLetter .modal-body').html('<p class="text-danger">Failed to load data.</p>');
                }
            });
        }
    });

    $(document).on('keyup input', '.percentage', function() {
        let row = this.closest('tr');
        calculateSubBrokerageAmount(row);
    });
    $(document).on('keyup input', '.tds', function () {
        let row = this.closest('tr');
        calculateNetAmount(row); 
        calculateTotalTdsAmount(row);
    });
    function calculateSubBrokerageAmount(row) {
        let percentageInput = row.querySelector('.percentage');
        let amountInput = row.querySelector('.amount');
        let subbrokerageamount = row.querySelector('.subbrokerageamount');

        let percentage = parseFloat(percentageInput.value) || 0;
        let amount = parseFloat(amountInput.value) || 0;

        let subBrokerage = (amount * percentage) / 100;
        subbrokerageamount.value = subBrokerage.toFixed(2);

        calculateNetAmount(row);
        calculateTotalSubBrokerage();
    }

    function calculateNetAmount(row) {
        let subBrokerageInput = row.querySelector('.subbrokerageamount');
        let tdsInput = row.querySelector('.tds');
        let netAmountInput = row.querySelector('.netamount');

        let subBrokerage = parseFloat(subBrokerageInput.value) || 0;
        let tdsPercentage  = parseFloat(tdsInput.value) || 0;
        
        let tdsAmount = (subBrokerage * tdsPercentage) / 100;
        let netAmount = subBrokerage - tdsAmount;

        if (subBrokerage === 0) {
            netAmountInput.value = '0.00';
             tdsInput.value = 0;
        } else {
            netAmountInput.value = netAmount.toFixed(2);
        }

        calculateTotalNetAmount();
        calculateTotalTdsAmount(); 
    }

    function calculateTotalSubBrokerage() {
        let total = 0;
        document.querySelectorAll('.subbrokerageamount').forEach(function(input) {
            total += parseFloat(input.value) || 0;
        });
        const fixedTotal = total.toFixed(2).toString().replace(',', '.');
        document.getElementById('totalSubBrokerageAmount').textContent = fixedTotal;
        document.querySelector('input[name="total_sub_brokerage_amount"]').value = fixedTotal;
    }
    function calculateTotalNetAmount() {
        let total = 0;
        document.querySelectorAll('.netamount').forEach(function (input) {
            let val = parseFloat(input.value) || 0;
            total += val;
        });
        document.getElementById('totalnetAmount').textContent = total.toFixed(2); 
        document.querySelector('input[name="total_net_amount"]').value = total.toFixed(2);

    }
    function calculateTotalTdsAmount() {
        let total = 0;
        document.querySelectorAll('.tds').forEach(function (input) {
            let val = parseFloat(input.value) || 0;
            total += val;
        });
        document.getElementById('totaltdsAmount').textContent = total.toFixed(2); 
        document.querySelector('input[name="total_tds_amount"]').value = total.toFixed(2);
    }

    
    function checkValidation(){
        if($('#subbrokerid').val() == ''){
            $('#subbrokerid').css('border', '1px solid #ff0000');  
            return false;
        }else{
            $('#subbrokerid').css('border', '1px solid #999');   
        }
        if($('#bankid').val() == ''){
            $('#bankid').css('border', '1px solid #ff0000');  
            return false;
        }else{
            $('#bankid').css('border', '1px solid #999');   
        }
        if($('#chequeno').val() == ''){
            $('#chequeno').css('border', '1px solid #ff0000');  
            return false;
        }else{
            $('#chequeno').css('border', '1px solid #999');   
        }
        
        return true;
    }
    
    $('#cancelsubbrokerage').on('click', function() {
        $('#myModalSubbroker').modal('hide');
    });

    $('#deletesubbrokerage').on('click', function() {
        if (confirm('Are you sure you want to delete this sub-brokerage payment?')) {
        var siteUrl = '<?php echo $this->Url->build("/", true); ?>';
        var targetUrl = siteUrl + 'reports/deletesubbrokerage';

        var paymentId = $('#sub_brokerage_payment_id').val();

        $.ajax({
            type: 'POST',
            url: targetUrl,
            data: { sub_brokerage_payment_id: paymentId },
            success: function (response) {
                alert(response);
                if (response.trim() === 'Subbrokerage payment deleted.') {
                    $('#myModalSubbroker').modal('hide');
                    window.location.reload();
                }
            },
            error: function (xhr) {
                alert('Error: ' + xhr.responseText);
            }
        });
        }
    });
    $('#savesubbrokerage').on('click', function() {
        var id = $('#sub_brokerage_payment_id').val();
        if (id) {
            var siteUrl = '<?php echo $this->Url->build("/", true); ?>';
            var targeturl = siteUrl + 'reports/editsubbrokerage';
        } else {
            var siteUrl = '<?php echo $this->Url->build("/", true); ?>';
            var targeturl = siteUrl + 'reports/savesubbrokerage';
        }

        checkValidation();
        
        var form = $('#addsubbrokerage')[0];
        var formData = new FormData(form); 

        $.ajax({
            type: 'POST',
            url: targeturl,
            data: formData,
            contentType: false,
            processData: false, 
            
            success: function(response) {  

                if(response.trim() === 'Subbrokerage amount has been saved.'){
                    alert(response);
                    $('#myModalSubbroker').modal('hide');
                    window.location.reload();
                }else{
                    alert(response);
                }
            },
            error: function(e) {
                    // alert("An error occurred: " + e.responseText.message);
                    // console.log(e);
            }
        });
    });
    let removedFdIds = [];
    $(document).on('click', '.remove-fd-row', function(e) {
        e.preventDefault(); 
         let row = $(this).closest('tr');
         var totalRows = $('#selected-fds-table tbody tr').length;
        if (totalRows <= 1) {
            alert('At least one Sub-brokrage payment must be present.');
            return;
        }
        
        var fdId = row.data('fdid');  // used for updated paid status to NO
        if (fdId) {
            removedFdIds.push(fdId); 
            $('#removed_fd_ids').val(removedFdIds.join(','));
        }
        row.remove();
        
        $('#selected-fds-table tbody tr').each(function(index) {
            let deleteIcon = $(this).find('.remove-fd-row').prop('outerHTML') || '';
            $(this).find('td:first').html((index + 1) + ' ' + deleteIcon);
        });

        calculateTotalSubBrokerage();
        calculateTotalNetAmount();
        calculateTotalTdsAmount();

    });

    

    
});


function printPdfModalContent() {
        var printContents = document.getElementById('printArea').innerHTML;
        var originalContents = document.body.innerHTML;

        document.body.innerHTML = printContents;
        window.print();
        document.body.innerHTML = originalContents;

        // Optional: reload page after print (to restore JS/CSS state)
        location.reload();
    }

</script>

<!-- Modal Add Sub-Brokrage -->
<div class="modal fade" id="myModalSubbroker" tabindex="-1" role="dialog" aria-labelledby="myModalSubbrokerLabel">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">  
        
      <div class="modal-body">
            <?php echo $this->Form->create(null, ['id' => 'addsubbrokerage','name' => 'addsubbrokerage' ]);
                echo $this->Form->input('sub_brokerage_payment_id', array('type'=>'hidden', 'id'=>'sub_brokerage_payment_id', 'value'=>''));
                echo $this->Form->input('removed_fd_ids', array('type'=>'hidden', 'id'=>'removed_fd_ids'));
            ?>
            <fieldset class="fieldset2">
             <div class="addmenu-col">
                <div class="column-box">
                    <?= $this->Form->input('subbroker_id', [
                        'class' => __('add-column'),
                        'label' => 'Sub-Broker:',
                        'empty' => 'Select Sub-Broker',
                        'required' => true,
                        'id' => 'subbrokerid',
                        'options' => $subbrokers
                    ]); ?>
                    <?= $this->Form->input('bank_id', [
                        'class' => __('add-column'),
                        'label' => 'Bank Name:',
                        'empty' => 'Choose Bank Name',
                        'required' => true,
                        'id' => 'bankid',
                        'options' => $banks
                    ]); ?>
                    <?= $this->Form->input('chequeno', ['class' => __('add-column'),'required' => true,'id'=>'chequeno','label' =>'Cheque:']); ?>
                    <?php echo  $this->Form->input('paid_date', [                       
                           'class'=>'datepicker add-column',
                           'id'=>'paid-date',
                           'type'=>'text','placeholder'=>'dd/mm/yyyy',
                           'label' =>'Paid Date: ','required' => true]); ?>
                </div>
              </div>
             </fieldset>
             <div class="scrollabletable">
            <table class="" cellpadding="0" cellspacing="0" id="selected-fds-table">
             <thead>
                <tr>
                    <th style="width:40px;" scope="col"><?= $this->Paginator->sort('Sr No') ?></th>
                    <th scope="col"><?= $this->Paginator->sort('Applicant Name') ?></th>
                    <th scope="col"><?= $this->Paginator->sort('Sub Broker Name') ?></th>
                    <th scope="col"><?= $this->Paginator->sort('company') ?></th>
                    <th scope="col"><?= $this->Paginator->sort('Investment Amount') ?></th>
                    <th>Percentage (%)</th>
                    <th>Sub-Brokerage Amount</th>
                    <th>TDS Percentage (%)</th>
                    <th>Net Amount</th>
                </tr>
             </thead>
             <tbody>
             </tbody>
             <tfoot>
                <tr>
                    <td colspan="6" style="text-align: right;"><b>Total:</b></td>
                    <td><b id="totalSubBrokerageAmount">0.00</b>
                        <input type="hidden" name="total_sub_brokerage_amount"  value="0">
                    </td>
                    <td><b id="totaltdsAmount">0.00</b>
                        <input type="hidden" name="total_tds_amount"  value="0">
                    </td>
                    <td><b id="totalnetAmount">0.00</b>
                        <input type="hidden" name="total_net_amount"  value="0">
                    </td>
                </tr>
             </tfoot>

            </table>
            </div>
             <input type="button" value="Cancel" id="cancelsubbrokerage" class="btn btn-primary">
             <input type="button" value="Delete" id="deletesubbrokerage" class="btn btn-primary" style="display:none;">
             <input type="button" value="Save" id="savesubbrokerage" class="btn btn-primary">
            <?= $this->Form->end() ?>
      </div>
      <div class="modal-footer">
     </div>
    </div>
  </div>
</div>

<!-- Modal PDF Letter & Details -->
<div class="modal fade" id="myModalPdfLetter" tabindex="-1" role="dialog" aria-labelledby="myModalPdfLetterLabel">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">  
       <div class="modal-header">
        <h4 class="modal-title" id="pdfModalLabel">PDF Letter & Details</h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>

      <div class="modal-body">

      </div>
      <div class="modal-footer text-center" style="width: 100%;">
        <button type="button" class="btn btn-primary" onclick="printPdfModalContent()">Print</button>
     </div>
    </div>
  </div>
</div>