<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * SubBrokeragePayments Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Subbrokers
 * @property \Cake\ORM\Association\BelongsTo $Banks
 * @property \Cake\ORM\Association\HasMany $FdSubBrokeragePayments
 *
 * @method \App\Model\Entity\SubBrokeragePayment get($primaryKey, $options = [])
 * @method \App\Model\Entity\SubBrokeragePayment newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\SubBrokeragePayment[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\SubBrokeragePayment|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\SubBrokeragePayment patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\SubBrokeragePayment[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\SubBrokeragePayment findOrCreate($search, callable $callback = null)
 */
class SubBrokeragePaymentsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('sub_brokerage_payments');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsTo('Brokers', [
            'foreignKey' => 'broker_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('Banks', [
            'foreignKey' => 'bank_id'
        ]);
        $this->hasMany('FdSubBrokeragePayments', [
            'foreignKey' => 'sub_brokerage_payment_id'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('chequeno');

        $validator
            //->date('paid_date')
            ->allowEmpty('paid_date');

        $validator
            ->decimal('total_sub_brokerage_amount')
            ->allowEmpty('total_sub_brokerage_amount');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        //$rules->add($rules->existsIn(['subbroker_id'], 'Subbrokers'));
        $rules->add($rules->existsIn(['broker_id'], 'Brokers'));
        $rules->add($rules->existsIn(['bank_id'], 'Banks'));

        return $rules;
    }
}
