<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Regionalmanagers Model
 *
 * @method \App\Model\Entity\Regionalmanager get($primaryKey, $options = [])
 * @method \App\Model\Entity\Regionalmanager newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Regionalmanager[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Regionalmanager|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Regionalmanager patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Regionalmanager[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Regionalmanager findOrCreate($search, callable $callback = null)
 */
class RegionalmanagersTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('regionalmanagers');
        $this->displayField('id');
        $this->primaryKey('id');
		
		$this->belongsTo('Branches', [
            'foreignKey' => 'branch_id',
            'joinType' => 'LEFT'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('manager');

        return $validator;
    }
}
