<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * Subbrokers Controller
 *
 * @property \App\Model\Table\SubbrokersTable $Subbrokers
 */
class SubbrokersController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $subbrokers = $this->paginate($this->Subbrokers);

        $this->set(compact('subbrokers'));
        $this->set('_serialize', ['subbrokers']);
    }

    /**
     * View method
     *
     * @param string|null $id Subbroker id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $subbroker = $this->Subbrokers->get($id, [
            'contain' => ['Fds', 'Investments']
        ]);

        $this->set('subbroker', $subbroker);
        $this->set('_serialize', ['subbroker']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $subbroker = $this->Subbrokers->newEntity();
        if ($this->request->is('post')) {
            $subbroker = $this->Subbrokers->patchEntity($subbroker, $this->request->data);
            if ($this->Subbrokers->save($subbroker)) {
                $this->Flash->success(__('The subbroker has been saved.'));

                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The subbroker could not be saved. Please, try again.'));
            }
        }
        $this->set(compact('subbroker'));
        $this->set('_serialize', ['subbroker']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Subbroker id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $subbroker = $this->Subbrokers->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $subbroker = $this->Subbrokers->patchEntity($subbroker, $this->request->data);
            if ($this->Subbrokers->save($subbroker)) {
                $this->Flash->success(__('The subbroker has been saved.'));

                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The subbroker could not be saved. Please, try again.'));
            }
        }
        $this->set(compact('subbroker'));
        $this->set('_serialize', ['subbroker']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Subbroker id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $subbroker = $this->Subbrokers->get($id);
        if ($this->Subbrokers->delete($subbroker)) {
            $this->Flash->success(__('The subbroker has been deleted.'));
        } else {
            $this->Flash->error(__('The subbroker could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
