<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;
/**
 * Ipos Controller
 *
 * @property \App\Model\Table\IposTable $Ipos
 */
class IposController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index(){   
        $conditions = '';  
        if($this->Auth->user('group_id')=='3'){        
            $branch_id = $this->Auth->user('branch_id');     
            $conditions['conditions']['and']['Ipos.posteduserbranchid'] = "$branch_id";
        }elseif($this->Auth->user('group_id')=='4' || $this->Auth->user('group_id')=='5' || $this->Auth->user('group_id')=='6' || $this->Auth->user('group_id')=='7'){ 
            $branch_id = $this->Auth->user('branch_id');    
            $userid = $this->Auth->user('id'); 
            $conditions['conditions']['and']['Ipos.posteduserbranchid'] = "$branch_id";
            $conditions['conditions']['and']['Ipos.postedby'] = "$userid";
        }
        $this->paginate = [
            'contain' => ['Companies']
        ];
        
        $conditions['conditions']['or']['DATE(Ipos.created) = '] = date('Y-m-d');
        $ipos = $this->Ipos->find('all', $conditions);
        $ipos = $this->paginate($ipos,['order' => ['Ipos.id' => 'DESC']]);
        $this->set(compact('ipos'));
        $this->set('_serialize', ['ipos']);
    }

    /**
     * View method
     *
     * @param string|null $id Ipo id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $ipo = $this->Ipos->get($id, [
            'contain' => ['Companies', 'Branches', 'Banks','Brokers']
        ]);

       	$companies = TableRegistry::get('Companies');
		$branches = TableRegistry::get('Branches');
		$plans = TableRegistry::get('Plans');
		$banks = TableRegistry::get('Banks');
		$users = TableRegistry::get('Users');
		$brokers = TableRegistry::get('Brokers');
		 if($ipo->productcompanyid > 0) {
			$productcompanyid = $companies->find()->where(['id' => $ipo->productcompanyid]);
			$data1 = $productcompanyid->toArray();
			$productcompanyName = $data1[0]->company;
			}
			else{
			$productcompanyName = '';
			}
			$this->set('productcompanyName',$productcompanyName);
			
		if($ipo->mainbrokerid > 0) {
			$mainbrokerid = $brokers->find()->where(['id' => $ipo->mainbrokerid]);
			$data1 = $mainbrokerid->toArray();
			$mainbrokerName = $data1[0]->name;
			//pr()
			}
			else{
			$mainbrokerName = '';
			}
			$this->set('mainbrokerName',$mainbrokerName);	
		if($ipo->plan_id > 0) 
		{
			$planid = $plans->find()->where(['id' => $ipo->plan_id]);
			$data2 = $planid->toArray();
			$planname = $data2[0]->Planname;
		}
		else{
		$planname = '';
		}
		$this->set('planname',$planname);
		
		//die();
		if($ipo->bank_id > 0)
		{
			$bank_id = $banks->find()->where(['id' => $ipo->bank_id]);
			$data3 = $bank_id->toArray();
			$bankname = $data3[0]->banks;
		}
		else{
		$bankname = '';
		}
		$this->set('bankname',$bankname);
		//pr($fd->posteduserbranchid);
		//die();
		if($ipo->posteduserbranchid > 0) {
			$posteduserbranchid = $branches->find()->where(['id' => $ipo->posteduserbranchid]);
			$data4 = $posteduserbranchid->toArray();
			$branchname = $data4[0]->branchname;
		}
		else
		{
			$branchname = '';
		}
		$this->set('branchname', $branchname);
		 if($ipo->postedby > 0){
            $postedby = $users->find()->where(['id' => $ipo->postedby]);
            $data11 = $postedby->toArray();
            $userName = $data11[0]->username;
       }else{
           $userName = '';
       }    
            $this->set('userName', $userName);
       
        //$fd = $this->Fds->get($id);
        $this->set('ipo', $ipo);
        $this->set('_serialize', ['ipo']);

    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        
        if ($this->request->is('ajax','get')) {         
            $terms = $this->Ipos->Customers->find('all', [
                'conditions' => array('Customers.firstname LIKE ' => '%' . $this->request->query["term"] . '%'),
                'limit' => 10
            ]);
          
            $data = array();$data1 = array();
            foreach($terms as $term) {
                $row = $term->firstname;
                array_push($data, $row);
            }
            $this->autoRender = false;      
            // $this->layout = 'ajax';
            $this->set('terms', $terms);
            echo json_encode($data);
            exit;
            //return json_encode($data);
         }else {
            //echo json_encode('Nothings found');
         }
         
        $ipo = $this->Ipos->newEntity();
        if ($this->request->is('post')) {
            $ipo = $this->Ipos->patchEntity($ipo, $this->request->data);
            $ipo->postedby = $this->Auth->user('id');
            $ipo->posteduserbranchid = $this->Auth->user('branch_id');
           // $ipo->branch_id = $this->Auth->user('branch_id');
            if($ipo->subbroker_id != ''){
                $ipo->broker_id = $ipo->subbroker_id;
            }else{
                $ipo->broker_id = 1;
            }
             $custmoerId = $this->getCustomerId($ipo->panno);
           if($custmoerId != ''){
                $ipo->customer_id = $custmoerId;
            }
            if ($this->Ipos->save($ipo)) {
                $this->Flash->success(__('The ipo has been saved.'));

                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The ipo could not be saved. Please, try again.'));
            }
        }
             
        $usercompanies = $this->Ipos->Companies->find('list')-> where(['associatewith' => 'user'])->order(['company' => 'ASC']);
	$userbranches = $this->Ipos->Branches->find('list', ['limit' => 200])->order(['branchname' => 'ASC']);
        //$productcompanies = $this->Ipos->Companies->find('list')-> where(['associatewith' => 'product'])->order(['company' => 'ASC']);
        $productcompanies = $this->Ipos->Companies->find('list')-> where(['associatewith' => 'product'])->where(['productid LIKE' => '%4%'])->order(['company' => 'ASC']);
        $typeofdeposit = array('fresh'=>'Fresh','renewal'=>'Renewal','both'=>'Both');
        $tenure = array('12'=>'12 Month','24'=>'24 Month','36'=>'36 Month','48'=>'48 Month','60'=>'60 Month','72'=>'72 Month');
        $subbrokers = $this->Ipos->Brokers->find('list', [
            'keyField' => 'id',
            'valueField' => 'name'
        ])-> where(['role' => 'Subbroker']);
        $mainbrokers = $this->Ipos->Brokers->find('list', [
            'keyField' => 'id',
            'valueField' => 'name'
        ])-> where(['role' => 'Mainbroker']);
        
        $users = $this->Ipos->Customers->find('list', ['limit' => 200])->order(['firstname' => 'ASC']);
        $banks = $this->Ipos->Banks->find('list', ['limit' => 200])->order(['banks' => 'ASC']);
        $plans = $this->Ipos->Plans->find('list')-> where(['product_id' => 4])->order(['planname' => 'ASC']);
        
        $this->set(compact('ipo','plans', 'usercompanies','mainbrokers', 'subbrokers', 'userbranches','typeofdeposit','tenure', 'productcompanies', 'users', 'banks', 'bankdetails'));
        $this->set('_serialize', ['ipo']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Ipo id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {   
        if ($this->request->is('ajax','get')) {         
            $terms = $this->Ipos->Customers->find('all', [
                'conditions' => array('Customers.firstname LIKE ' => '%' . $this->request->query["term"] . '%'),
                'limit' => 10
            ]);
          
            $data = array();$data1 = array();
            foreach($terms as $term) {
                $row = $term->firstname;
                array_push($data, $row);
            }
            $this->autoRender = false;      
            // $this->layout = 'ajax';
            $this->set('terms', $terms);
            echo json_encode($data);
            exit;
            //return json_encode($data);
         }else {
            //echo json_encode('Nothings found');
         }
         
        $ipo = $this->Ipos->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $ipo = $this->Ipos->patchEntity($ipo, $this->request->data);
            $ipo->postedby = $this->Auth->user('id');
            $ipo->posteduserbranchid = $this->Auth->user('branch_id');
          //  $ipo->branch_id = $this->Auth->user('branch_id');
            if($ipo->subbroker_id != ''){
                $ipo->broker_id = $ipo->subbroker_id;
            }else{
                $ipo->broker_id = 1;
            }
             $custmoerId = $this->getCustomerId($ipo->panno);
           if($custmoerId != ''){
                $ipo->customer_id = $custmoerId;
            }
            if ($this->Ipos->save($ipo)) {
                $this->Flash->success(__('The ipo has been saved.'));

                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The ipo could not be saved. Please, try again.'));
            }
        }
     
        $usercompanies = $this->Ipos->Companies->find('list')-> where(['associatewith' => 'user'])->order(['company' => 'ASC']);
	$userbranches = $this->Ipos->Branches->find('list', ['limit' => 200])->order(['branchname' => 'ASC']);
        //$productcompanies = $this->Ipos->Companies->find('list')-> where(['associatewith' => 'product'])->order(['company' => 'ASC']);
        $productcompanies = $this->Ipos->Companies->find('list')-> where(['associatewith' => 'product'])->where(['productid LIKE' => '%4%'])->order(['company' => 'ASC']);
        $typeofdeposit = array('fresh'=>'Fresh','renewal'=>'Renewal','both'=>'Both');
        $tenure = array('12'=>'12 Month','24'=>'24 Month','36'=>'36 Month','48'=>'48 Month','60'=>'60 Month','72'=>'72 Month');
        $subbrokers = $this->Ipos->Brokers->find('list', [
            'keyField' => 'id',
            'valueField' => 'name'
        ])-> where(['role' => 'Subbroker']);
        $mainbrokers = $this->Ipos->Brokers->find('list', [
            'keyField' => 'id',
            'valueField' => 'name'
        ])-> where(['role' => 'Mainbroker']);
        $users = $this->Ipos->Customers->find('list', ['limit' => 200])->order(['firstname' => 'ASC']);
        $banks = $this->Ipos->Banks->find('list', ['limit' => 200])->order(['banks' => 'ASC']);
        $plans = $this->Ipos->Plans->find('list')-> where(['product_id' => 4])->order(['planname' => 'ASC']);
        
        $this->set(compact('ipo','plans', 'usercompanies','mainbrokers', 'subbrokers', 'userbranches','typeofdeposit','tenure', 'productcompanies', 'users', 'banks'));
        $this->set('_serialize', ['ipo']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Ipo id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $ipo = $this->Ipos->get($id);
        if ($this->Ipos->delete($ipo)) {
            $this->Flash->success(__('The ipo has been deleted.'));
        } else {
            $this->Flash->error(__('The ipo could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
    
    public function iposupdate()
    {   
         $this->Search->addFilter('firstname', [
          'attributes'=>['placeholder'=>'Applicant Name','label'=>'Applicant Name :','class'=>'searchfrm','value' => isset($this->request->query['firstname'])?$this->request->query['firstname']:''], 'options' => $this->Ipos->Customers->find('list',['keyField' => 'firstname','valueField' => 'firstname'])->order(['Customers.firstname'=>'ASC'])->group(['Customers.firstname'])->toArray(),
       ]);
		$this->Search->addFilter('datedform', [
         'attributes'=>['placeholder'=>'Start Date','label'=>'Start Date :','class'=>'searchfrm','value' => isset($this->request->query['datedform'])?$this->request->query['datedform']:''],
        ]);
        $this->Search->addFilter('datedto', [
           'attributes'=>['placeholder'=>'End Date','label'=>'End Date :','class'=>'searchfrm','value' => isset($this->request->query['datedto'])?$this->request->query['datedto']:''],
        ]);
        $conditions = '';  
        
	//	if (!empty($this->request->query)) 
	 if((!empty($this->request->query['firstname']))||(!empty($this->request->query['datedform'])) ||(!empty($this->request->query['datedto'])) ){ 
        
         $fapplicantname = $this->request->query['firstname'];    
        $dated2 =  (($this->request->query['datedform'] != '')? $this->request->query['datedform'] : '');
		 $date_from = explode('/',$dated2);
         $datedform  = implode('-', array_reverse($date_from));
         
	   $dated1= (($this->request->query['datedto']!='')? $this->request->query['datedto']:'');
	   $date_to = explode('/',$dated1);
        $datedto  = implode('-', array_reverse($date_to));
	
		
if ($datedform && $datedto){
    if($datedform == $datedto){
                $adt = new \DateTime($datedto);
                $adt->modify('+1 day');
                $datedto = $adt->format('Y-m-d');        
            }
                 $conditions = array(
        'conditions' => array(
        'and' => array(
                        array('Ipos.created >= ' => $datedform,
                              'Ipos.created <= ' => $datedto
                             ))));
            } 
            if ($fapplicantname){ $conditions['conditions']['or']['Ipos.biddername'] = "$fapplicantname"; }
            if($this->Auth->user('group_id')=='3'){        
            $branch_id = $this->Auth->user('branch_id');     
            $conditions['conditions']['and']['Ipos.posteduserbranchid'] = "$branch_id";
            }elseif($this->Auth->user('group_id')=='4' || $this->Auth->user('group_id')=='5' || $this->Auth->user('group_id')=='6' || $this->Auth->user('group_id')=='7'){ 
                $branch_id = $this->Auth->user('branch_id');    
                $userid = $this->Auth->user('id'); 
                $conditions['conditions']['and']['Ipos.posteduserbranchid'] = "$branch_id";
                $conditions['conditions']['and']['Ipos.postedby'] = "$userid";
            }
            if (( $fapplicantname != '')  || ($datedform && $datedto)){ 
			        $ipos = $this->Ipos->find('all', $conditions);
            }else{
			
		
                $ipos = $this->Ipos;
            }    
            $this->paginate = [
               'contain' => ['Companies']
            ]; 
			
			       $ipos = $this->paginate($ipos ,['order' => ['Ipos.id' => 'ASC']]);
            $this->set(compact('ipos'));
            $this->set('_serialize', ['ipos']);
       
      }
	  else
	  {
	 
        $this->paginate = [
            'contain' => ['Companies']
        ];
        
      
         $conditions['conditions']['or']['DATE(Ipos.created) > '] = date('Y-m-d');
        $ipos = $this->Ipos->find('all', $conditions);
        $ipos = $this->paginate($ipos,['order' => ['Ipos.id' => 'DESC']]);

        $this->set(compact('ipos'));
        $this->set('_serialize', ['ipos']);
		}
    }

    public function getuserinfo(){
       $id = $this->request->query('id');
        if (!$id) {
                throw new NotFoundException();
        }
        $query = $this->Ipos->Customers->find('all',['conditions' => array('Customers.firstname LIKE ' => '%' . $id . '%')]);                
        $data = $query->toArray();       
        $this->set(compact('data')); 
                
    }

    public function getbankinfo(){
        $id = $this->request->query('id');
        if (!$id) {
            throw new NotFoundException();
        }   
        $databank = $this->Ipos->Bankbranches->find('all',['conditions' => ['id' => $id]]); 
        $this->set(compact('databank')); 
    }
    public function getbankbranchinfo(){
        $id = $this->request->query('id');
        if (!$id) {
            throw new NotFoundException();
        }   
        $query = $this->Ipos->Bankbranches->find('all',['conditions' => ['id' => $id]]); 
        $databranch = $query->toArray();       
        $this->set(compact('databranch')); 
    }
     public function getplan(){
        $id = $this->request->query('id');
        if (!$id) {
            throw new NotFoundException();
        }   
        $dataplan = $this->Ipos->Plans->find('all',['conditions' => ['company_id' => $id, 'product_id' => '4']]); 
        $this->set(compact('dataplan')); 
    }
}
