<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * Bankdetails Controller
 *
 * @property \App\Model\Table\BankdetailsTable $Bankdetails
 */
class BankdetailsController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Banks']
        ];
        $bankdetails = $this->paginate($this->Bankdetails);

        $this->set(compact('bankdetails'));
        $this->set('_serialize', ['bankdetails']);
    }

    /**
     * View method
     *
     * @param string|null $id Bankdetail id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $bankdetail = $this->Bankdetails->get($id, [
            'contain' => ['Banks']
        ]);

        $this->set('bankdetail', $bankdetail);
        $this->set('_serialize', ['bankdetail']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $bankdetail = $this->Bankdetails->newEntity();
        if ($this->request->is('post')) {
            $bankdetail = $this->Bankdetails->patchEntity($bankdetail, $this->request->data);
            if ($this->Bankdetails->save($bankdetail)) {
                $this->Flash->success(__('The bankdetail has been saved.'));

                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The bankdetail could not be saved. Please, try again.'));
            }
        }
        $banks = $this->Bankdetails->Banks->find('list', ['limit' => 200]);
        $this->set(compact('bankdetail', 'banks'));
        $this->set('_serialize', ['bankdetail']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Bankdetail id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $bankdetail = $this->Bankdetails->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $bankdetail = $this->Bankdetails->patchEntity($bankdetail, $this->request->data);
            if ($this->Bankdetails->save($bankdetail)) {
                $this->Flash->success(__('The bankdetail has been saved.'));

                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The bankdetail could not be saved. Please, try again.'));
            }
        }
        $banks = $this->Bankdetails->Banks->find('list', ['limit' => 200]);
        $this->set(compact('bankdetail', 'banks'));
        $this->set('_serialize', ['bankdetail']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Bankdetail id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $bankdetail = $this->Bankdetails->get($id);
        if ($this->Bankdetails->delete($bankdetail)) {
            $this->Flash->success(__('The bankdetail has been deleted.'));
        } else {
            $this->Flash->error(__('The bankdetail could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
