<?php
namespace App\Model\Table;

use Cake\ORM\TableRegistry;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use Cake\Datasource\ConnectionManager;

/**
 * Fds Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Companies
 * @property \Cake\ORM\Association\BelongsTo $Branches
 * @property \Cake\ORM\Association\BelongsTo $Users
 * @property \Cake\ORM\Association\BelongsTo $Plans
 * @property \Cake\ORM\Association\BelongsTo $Subbrokers
 * @property \Cake\ORM\Association\BelongsTo $Banks
 * @property \Cake\ORM\Association\BelongsTo $Bankdetails
 *
 * @method \App\Model\Entity\Fd get($primaryKey, $options = [])
 * @method \App\Model\Entity\Fd newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Fd[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Fd|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Fd patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Fd[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Fd findOrCreate($search, callable $callback = null)
 */
class FdsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('fds');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsTo('Companies', [
            'foreignKey' => 'company_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('Branches', [
            'foreignKey' => 'branch_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('Brokers', [
            'foreignKey' => 'broker_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('Plans', [
            'foreignKey' => 'plan_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('Customers', [
            'foreignKey' => 'customer_id',
            'joinType' => 'INNER'
        ]); 
        $this->belongsTo('Banks', [
            'foreignKey' => 'bank_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create'); 
         $validator
            ->integer('productcompanyid')
            ->requirePresence('productcompanyid', 'create')
            ->notEmpty('productcompanyid');
        $validator
            ->requirePresence('typeofdeposit', 'create')
            ->notEmpty('typeofdeposit');        
      
        $validator
            ->requirePresence('tenure', 'create')
            ->notEmpty('tenure');
        
         /*$validator
            ->requirePresence('chequeno', 'create')
            ->notEmpty('chequeno');  */

        $validator
            ->requirePresence('amount', 'create')
            ->notEmpty('amount');
        
        $validator
            ->requirePresence('fapplicantname', 'create')
            ->notEmpty('fapplicantname');

        $validator
            ->requirePresence('despatchdate', 'create')
            ->notEmpty('despatchdate');
        $validator
            ->requirePresence('panno', 'create')
            ->notEmpty('panno');

      /*  $validator
            ->requirePresence('branch_id', 'create')
            ->notEmpty('branch_id');
       * 
       */
        $validator
            ->requirePresence('company_id', 'create')
            ->notEmpty('company_id');
        /* $validator
            ->requirePresence('bank_id', 'create')
            ->notEmpty('bank_id');*/
        $validator
            ->requirePresence('plan_id', 'create')
            ->notEmpty('plan_id');
        return $validator;
    }
    
    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
       // $rules->add($rules->isUnique(['email']));
        $rules->add($rules->existsIn(['company_id'], 'Companies'));
        $rules->add($rules->existsIn(['branch_id'], 'Branches'));
        $rules->add($rules->existsIn(['plan_id'], 'Plans'));
        $rules->add($rules->existsIn(['broker_id'], 'Brokers'));
        //$rules->add($rules->existsIn(['bank_id'], 'Banks'));

        return $rules;
    }
    
    
    function listdata($fid)
	{
		$conn = ConnectionManager::get('default');
		$firstName = $conn->execute("SELECT  mheaders.mname,mheaders.id  FROM  mheaders WHERE id NOT IN (SELECT mapid FROM cheaders where fid = $fid && mapid IS NOT NULL)")->fetchAll('assoc');
		
	
		foreach($firstName as $datas)
		{
			
			$key[] = $datas['id'];
			$value[] = $datas['mname'];
	        $title = array_combine($key, $value);
			
			
		}
		
		return  $title;
	}
    
    
    function importcsvdata($model ,$filename,$uId,$fid) {
	
	    $conditions = array();
        $filename = FILECSV.DS.$filename;
        $handle = fopen($filename, "r");
		
	    $head = fgetcsv($handle); 
	  
		$conn = ConnectionManager::get('default');
		$customers = $conn->execute("select cname from cheaders where fid = $fid")->fetchAll('assoc');
		
		
		foreach($customers as $customer)
		{
			$headersdatas[] = $customer['cname'];
		}
		
		
		foreach($headersdatas as $headersdata)
		{
		
		$headerssql[] = $conn->execute("SELECT mname from mheaders where id IN (SELECT mapid from cheaders where cname = '$headersdata' AND fid = '$fid')")->fetchAll('assoc');
		
	    }
			
        		
		foreach($headerssql as $heads)
		{
		if(isset($heads[0]['mname'])){
		$headers[] = $heads[0]['mname'];
		}
		}
		
        while (($row = fgetcsv($handle))!==false) { 
            
        $data = array();
         // for each header field
        foreach ($headers as $k=>$header) {
				
	    if(isset($row[$k])){
        $row[$k] = preg_replace('/[\x00-\x1F\x80-\xFF]/', '', $row[$k]);
        }
				
        // get the data field from Model.field
        if (strpos($header,'.')!==false) { 
        $h = explode('.',$header); 
         
        $data[$h[0]][$h[1]]=(isset($row[$k])) ? $row[$k] : '';
		//taking clientphno
              }
			 
                // get the data field from field
                else {
                    $data[$header]=(isset($row[$k])) ? trim($row[$k]) : '';	
                }
            }
            $this->Mtables = TableRegistry::get('Mtables');
			$this->Customers = TableRegistry::get('Customers');
		   
			$data['csvid'] = $fid;
			$filename= $this->Mtables->newEntity();
			
			if(isset($data['deposit_author_date']) && $data['deposit_author_date'] != NULL)
			{
			    $data['deposit_author_date'] = str_replace('/', '-', $data['deposit_author_date']);
				$data['deposit_author_date'] = date("d/m/Y", strtotime($data['deposit_author_date']));
			}
			if(isset($data['maturity_date']) && $data['maturity_date'] != NULL)
			{
			    $data['maturity_date'] = str_replace('/', '-', $data['maturity_date']);
				$data['maturity_date'] = date("d/m/Y", strtotime($data['maturity_date']));
			}else{
			    if(isset($data['application_date']) && $data['application_date'] != NULL && isset($data['period']) && $data['period'] != NULL){
			    $date = str_replace('/', '-', $data['application_date']);
                $maturityDate = date('Y-m-d', strtotime($date));
			    $data['maturity_date'] = date('d/m/Y', strtotime('+'.$data['period'].'months', strtotime($maturityDate)));
			}}
		
			if(isset($data['interest_start_date']) && $data['interest_start_date'] != NULL)
			{
			     $data['interest_start_date'] = str_replace('/', '-', $data['interest_start_date']);
				$data['interest_start_date'] = date("d/m/Y", strtotime($data['interest_start_date']));
			}
			if(isset($data['deposit_date']) && $data['deposit_date'] != NULL)
			{
			    $data['deposit_date'] = str_replace('/', '-', $data['deposit_date']);
				$data['deposit_date'] = date("d/m/Y", strtotime($data['deposit_date']));
			}
			if(isset($data['rec_date']) && $data['rec_date'] != NULL)
			{
			    $data['rec_date'] = str_replace('/', '-', $data['rec_date']);
				$data['rec_date'] = date("d/m/Y", strtotime($data['rec_date']));
			}
			if(isset($data['renewal_date']) && $data['renewal_date'] != NULL)
			{
			    $data['renewal_date'] = str_replace('/', '-', $data['renewal_date']);
				$data['renewal_date'] = date("d/m/Y", strtotime($data['renewal_date']));
			}
			if(isset($data['entry_date']) && $data['entry_date'] != NULL)
			{
			    $data['entry_date'] = str_replace('/', '-', $data['entry_date']);
				$data['entry_date'] = date("d/m/Y", strtotime($data['entry_date']));
			}
			if(isset($data['deposit_effective_date']) && $data['deposit_effective_date'] != NULL)
			{
			    $data['deposit_effective_date'] = str_replace('/', '-', $data['deposit_effective_date']);
				$data['deposit_effective_date'] = date("d/m/Y", strtotime($data['deposit_effective_date']));
			}
			if(isset($data['pay_date']) && $data['pay_date'] != NULL)
			{
			    $data['pay_date'] = str_replace('/', '-', $data['pay_date']);
				$data['pay_date'] = date("d/m/Y", strtotime($data['pay_date']));
			}
			if(isset($data['date_of_birth']) && $data['date_of_birth'] != NULL)
			{
			    if(empty(strtotime($data['date_of_birth']))){
                    $arr = explode("-",$data['date_of_birth']);
                    $result = $arr[2];$year = '20'.$result;
                    if($year > date('Y')) {$year = $year - 100;}
                     $data['date_of_birth'] =  $arr[0].'-'.$arr[1].'-'.$year;}
			    $data['date_of_birth'] = str_replace('/', '-', $data['date_of_birth']);
				$data['date_of_birth'] = date("d/m/Y", strtotime($data['date_of_birth']));
			}
			if(isset($data['application_date']) && $data['application_date'] != NULL)
			{
			    $data['application_date'] = str_replace('/', '-', $data['application_date']);
				$data['application_date'] = date("d/m/Y", strtotime($data['application_date']));
			}
			if(isset($data['transaction_upload_date']) && $data['transaction_upload_date'] != NULL)
			{
			    $data['transaction_upload_date'] = str_replace('/', '-', $data['transaction_upload_date']);
				$data['transaction_upload_date'] = date("d/m/Y", strtotime($data['transaction_upload_date']));
			}
			if(isset($data['txn_date']) && $data['txn_date'] != NULL)
			{
			    $data['txn_date'] = str_replace('/', '-', $data['txn_date']);
				$data['txn_date'] = date("d/m/Y", strtotime($data['txn_date']));
			}
			if(isset($data['nav_date']) && $data['nav_date'] != NULL)
			{
			    $data['nav_date'] = str_replace('/', '-', $data['nav_date']);
				$data['nav_date'] = date("d/m/Y", strtotime($data['nav_date']));
			}
			if(isset($data['tran_date']) && $data['tran_date'] != NULL)
			{
			    $data['tran_date'] = str_replace('/', '-', $data['tran_date']);
				$data['tran_date'] = date("d/m/Y", strtotime($data['tran_date']));
			}
			if(isset($data['cheque_date']) && $data['cheque_date'] != NULL)
			{
			    $data['cheque_date'] = str_replace('/', '-', $data['cheque_date']);
				$data['cheque_date'] = date("d/m/Y", strtotime($data['cheque_date']));
			}
			
			if(isset($data['comm_pay_date']) && $data['comm_pay_date'] != NULL)
            {
                $data['comm_pay_date'] = str_replace('/', '-', $data['comm_pay_date']);
                $data['comm_pay_date'] = date("d/m/Y", strtotime($data['comm_pay_date']));
            }
            
            if(empty($data['institution_name']))
            {
                if(isset($fid) && $fid != NULL){
                    $defaultInstitutionCompany = array(3,17,19);
                    if(in_array($fid,$defaultInstitutionCompany)){
                        $data['institution_name'] = getFormatCompanyName($fid);
                    }
                }
            }
			
		    $data['uploadedby'] = $uId;
		    
		    if(!empty($data['customer_name']) && !empty($data['pan_no'])){
	$customerdata['firstname'] = preg_replace("/[^A-Za-z0-9 ]/",'',$data['customer_name']);
	$customerdata['panno'] = preg_replace("/[^A-Za-z0-9]/",'',$data['pan_no']);
	
	
	//$ISEXISTCUSTOMER = $conn->execute("select * from customers where firstname = '".mysqli_real_escape_string($customerdata['firstname'])."' AND panno = '".mysqli_real_escape_string($customerdata['panno'])."' ")->fetchAll('assoc');
	
	$ISEXISTCUSTOMER = $conn->execute("select * from customers where firstname = '".$customerdata['firstname']."' AND panno = '".$customerdata['panno']."' ")->fetchAll('assoc');
	
	if(count($ISEXISTCUSTOMER) == 0){
		
		$query = $this->Customers->find('all', [
		'order' => ['Customers.created' => 'DESC']
		]);
		$lastuid = $query->first()->id;
		$accountNo = (1000 + ($lastuid + 1));
		$customerdata['accountno'] = $accountNo;
		
		$customer= $this->Customers->newEntity();
		$custinfodata = $this->Customers->patchEntity($customer, $customerdata);
		$customerdetails =  $this->Customers->save($custinfodata);
		$customersavedid =  $customerdetails->id;
		$data['customer_id'] = $customersavedid;
		}else{
		$data['customer_id'] = $ISEXISTCUSTOMER[0]['id'];
	}
}
		//	 $data['customer_name'] = mysqli_real_escape_string($this->Mtables,$data['customer_name']);
		     $data['customer_name'] = preg_replace("/[^A-Za-z0-9 ]/",'',$data['customer_name']);
			
			//pr($data);
		    $duplicateRecordCond = array();
            foreach ($headers as $k=>$header) {

                #check excel field data is a date or not
                $arrCheckDate = explode("/",$data[$header]);
                $isdataDate = false;
                if(count($arrCheckDate)==3){
                    $monthVal = $arrCheckDate[1];
                    $dayVal = $arrCheckDate[0];
                    $yearVal = $arrCheckDate[2];
                    $isdataDate = checkdate($monthVal ,$dayVal,$yearVal);
                    if($isdataDate){
                        $isdataDate = true;
                    }
                }
                if($isdataDate){
                    $dateFieldDataDup =  str_replace('/', '-', $data[$header]);
                    $dateFieldDataDup =  date("Y-m-d", strtotime($dateFieldDataDup));
                    $duplicateRecordCond[$header] = $dateFieldDataDup;
                }else{
                    $duplicateRecordCond[$header] = $data[$header];
                }
            }
            //pr($duplicateRecordCond);
            #Check record is already exist on mtables
            $ISEXIST_MRECORD = $this->Mtables->find()->where($duplicateRecordCond)->first();

            if(!empty($ISEXIST_MRECORD) && count($ISEXIST_MRECORD) > 0){
                $duplicatenotimport_counts = $ISEXIST_MRECORD->duplicatenotimport_counts + 1;
                $conn->execute("UPDATE mtables SET duplicatenotimport_counts = $duplicatenotimport_counts  where id = $ISEXIST_MRECORD->id ");

            }else{
                #check and Update customer_name of old same customer records as per the latest one based on pan_no
                if(!empty($data['pan_no']) && !empty($data['customer_name'])){
                    $ISPANCUSTOMER_MRECORD = $this->Mtables->find()->where(['pan_no'=>$data['pan_no']])->first();
                    if(!empty($ISPANCUSTOMER_MRECORD) && count($ISPANCUSTOMER_MRECORD) > 0){
                        $conn->execute("UPDATE mtables SET customer_name = '".$data['customer_name']."'  where pan_no = '".$data['pan_no']."'");
                    }
                }

                $filename = $this->Mtables->patchEntity($filename, $data);
                $this->Mtables->save($filename);
            }
        }
        
		$impoexcel = 1;
        return $impoexcel;
		fclose($handle);
    }
    
    
    
    
    
}
