<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Bankdetails Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Banks
 *
 * @method \App\Model\Entity\Bankdetail get($primaryKey, $options = [])
 * @method \App\Model\Entity\Bankdetail newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Bankdetail[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Bankdetail|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Bankdetail patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Bankdetail[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Bankdetail findOrCreate($search, callable $callback = null)
 */
class BankdetailsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('bankdetails');
        $this->displayField('branchaddress');
        $this->primaryKey('id');

        $this->belongsTo('Banks', [
            'foreignKey' => 'bank_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->requirePresence('accountno', 'create')
            ->notEmpty('accountno');

        $validator
            ->requirePresence('branchaddress', 'create')
            ->notEmpty('branchaddress');

        $validator
            ->requirePresence('accounttype', 'create')
            ->notEmpty('accounttype');

        $validator
            ->requirePresence('micrcode', 'create')
            ->notEmpty('micrcode');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['bank_id'], 'Banks'));

        return $rules;
    }
}
