<?php
namespace App\Controller;

use App\Controller\AppController;

  
class ReportsController extends AppController
{
    public $components = array('ExportXls');
 
    public function fds()
    {
      $this->loadModel('Fds'); 
      $this->loadModel('Customers'); 
      $this->loadModel('Banks'); 
      $this->Search->addFilter('applicationno', [
          'attributes' => ['placeholder'=>'Appliation Number','label'=>'Appliation Number :','class'=>'searchfrm',],
       ]);
      $this->Search->addFilter('fapplicantname', [
          'attributes'=>['placeholder'=>'Applicant Name','label'=>'Applicant Name :','class'=>'searchfrm',],
       ]);
      $this->Search->addFilter('panno', [
          'attributes'=>['placeholder'=>'Pan No','label'=>'Pan Number :','class'=>'searchfrm',],
       ]);
      $this->Search->addFilter('datedform', [
         'attributes'=>['placeholder'=>'Date From','label'=>'Date From :','class'=>'searchfrm',],
      ]);
      $this->Search->addFilter('datedto', [
         'attributes'=>['placeholder'=>'Date to','label'=>'Date to :','class'=>'searchfrm',],
      ]); 
      $this->Search->addFilter('banks', [
        'attributes'=>['placeholder'=>'Bank Name','label'=>'Bank Name :','class'=>'searchfrm',],  
        'options' => $this->Fds->Banks->find('list')->toArray(),
      ]);
      $this->Search->addFilter('customerid', [
        'attributes'=>['placeholder'=>'Customer Account','label'=>'Customer Account :','class'=>'searchfrm',],  
        'options' => $this->Fds->Customers->find('list')->toArray(),
      ]);
     
      if (!empty($this->request->query)) { 
         $applicationno = $this->request->query['applicationno'];
         $fapplicantname = $this->request->query['fapplicantname']; 
         $panno = $this->request->query['panno'];
         $banks = $this->request->query['banks'];
         $customerid = $this->request->query['customerid']; 
         
         $datedform = $this->request->query['datedform'];
         $datedto = $this->request->query['datedto']; 
          
         
         if ($applicationno){ $conditions['conditions']['or']['Fds.applicationno LIKE'] = "%$applicationno%"; }
         if ($fapplicantname){ $conditions['conditions']['or']['Fds.fapplicantname LIKE'] = "%$fapplicantname%"; }
         if ($panno){ $conditions['conditions']['or']['Fds.panno'] = "$panno"; }
         if ($banks){ $conditions['conditions']['or']['Fds.bank_id'] = "$banks"; }
         if ($customerid){ $conditions['conditions']['or']['Fds.customer_id'] = "$customerid"; }   
          if ($datedform && $datedto){
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                     array('Fds.created >= ' => $datedform,
                                           'Fds.created <= ' => $datedto
                                          )
                         )));
            }

            if ($applicationno !='' || $fapplicantname != '' || $panno != '' || $banks !='' || $customerid != '' || ($datedform && $datedto)){ 
                $fds = $this->Fds->find('all', $conditions);
            }else{
               $fds = $this->Fds;
            }    
            $this->paginate = [
               'contain' => []
            ]; 
            $fds = $this->paginate($fds ,['order' => ['Fds.id' => 'DESC']]);
            $this->set(compact('fds','applicationno','fapplicantname','banks','customerid','datedform','datedto','panno'));
            $this->set('_serialize', ['fds']);
       
      }else{ 
         $applicationno = '';
         $fapplicantname = '';          
         $banks = '';
         $customerid = '';          
         $datedform = '';
         $datedto = ''; 
         $panno = '';
            $this->paginate = [
                'contain' => []
            ];
            $fds = $this->paginate($this->Fds,['order' => ['Fds.id' => 'DESC']]);
            $this->set(compact('fds','panno','applicationno','fapplicantname','banks','customerid','datedform','datedto'));
            $this->set('_serialize', ['fds']);
      } 
    }
        
    function fdreports() {
   
         $this->autoRender = false;
         // $this->layout = false;        
         $fileName = "fdreports_".date("d-m-y:h:s").".xls";        
         $this->loadModel('Fds'); 
         $this->loadModel('Customers'); 
         $this->loadModel('Banks'); 
         
        $applicationno = $this->request->query['applicationno'];
        $fapplicantname = $this->request->query['fapplicantname'];
        $panno = $this->request->query['panno'];
        $banks = $this->request->query['banks'];
        $customerid = $this->request->query['customerid']; 
        $datedform = $this->request->query['datedform'];
        $datedto = $this->request->query['datedto']; 
       if ($applicationno){ $conditions['conditions']['or']['Fds.applicationno LIKE'] = "%$applicationno%"; }
       if ($fapplicantname){ $conditions['conditions']['or']['Fds.fapplicantname LIKE'] = "%$fapplicantname%"; }
       if ($panno){ $conditions['conditions']['or']['Fds.panno'] = "$panno"; }
       if ($banks){ $conditions['conditions']['or']['Fds.bank_id'] = "$banks"; }
       if ($customerid){ $conditions['conditions']['or']['Fds.customer_id'] = "$customerid"; }   
       if ($datedform && $datedto){
             $conditions = array(
                 'conditions' => array(
                 'and' => array(
                                 array('Fds.created >= ' => $datedform,
                                       'Fds.created <= ' => $datedto
                                      )
                     )));
        }

           if ($applicationno !='' || $fapplicantname != '' || $panno != '' || $banks !='' || $customerid != '' || ($datedform && $datedto)){ 
              $fds = $this->Fds->find('all', $conditions);
           }else{
              $fds = $this->Fds;
           }    

           $this->paginate = [
              'contain' => []
           ]; 
        $fds = $this->paginate($fds ,['order' => ['Fds.id' => 'DESC']]);
        $datafds = $fds->toArray(); 
            
         $headerRow = array("id", "Application No.", "paymentoption","Cheque No");
        
         for($i=0; $i< count($datafds); $i++){
            $data[] = [$datafds[$i]->id,$datafds[$i]->applicationno,$datafds[$i]->paymentoption,$datafds[$i]->chequeno];
          }          
          $this->ExportXls->export($fileName, $headerRow, $data);
    }
    
    public function mf()
    {
      $this->loadModel('Mutualfunds'); 
      $this->loadModel('Customers'); 
      $this->loadModel('Banks'); 
      $this->Search->addFilter('applicationno', [
          'attributes' => ['placeholder'=>'Appliation Number','label'=>'Appliation Number :','class'=>'searchfrm',],
       ]);
      $this->Search->addFilter('fapplicantname', [
          'attributes'=>['placeholder'=>'Applicant Name','label'=>'Applicant Name :','class'=>'searchfrm',],
       ]);
       $this->Search->addFilter('panno', [
          'attributes'=>['placeholder'=>'Pan No','label'=>'Pan Number :','class'=>'searchfrm',],
       ]);
      $this->Search->addFilter('datedform', [
         'attributes'=>['placeholder'=>'Date From','label'=>'Date From :','class'=>'searchfrm',],
      ]);
      $this->Search->addFilter('datedto', [
         'attributes'=>['placeholder'=>'Date to','label'=>'Date to :','class'=>'searchfrm',],
      ]); 
      $this->Search->addFilter('banks', [
        'attributes'=>['placeholder'=>'Bank Name','label'=>'Bank Name :','class'=>'searchfrm',],  
        'options' => $this->Mutualfunds->Banks->find('list')->toArray(),
      ]);
      $this->Search->addFilter('customerid', [
        'attributes'=>['placeholder'=>'Customer Account','label'=>'Customer Account :','class'=>'searchfrm',],  
        'options' => $this->Mutualfunds->Customers->find('list')->toArray(),
      ]);
     
      if (!empty($this->request->query)) { 
         $applicationno = $this->request->query['applicationno'];
         $fapplicantname = $this->request->query['fapplicantname']; 
         $panno = $this->request->query['panno'];
         $banks = $this->request->query['banks'];
         $customerid = $this->request->query['customerid']; 
         
         $datedform = $this->request->query['datedform'];
         $datedto = $this->request->query['datedto']; 
          
         
         if ($applicationno){ $conditions['conditions']['or']['Mutualfunds.applicationno LIKE'] = "%$applicationno%"; }
         if ($fapplicantname){ $conditions['conditions']['or']['Mutualfunds.firstapplicantname LIKE'] = "%$fapplicantname%"; }
         if ($panno){ $conditions['conditions']['or']['Mutualfunds.panno'] = "$panno"; }
         if ($banks){ $conditions['conditions']['or']['Mutualfunds.bank_id'] = "$banks"; }
         if ($customerid){ $conditions['conditions']['or']['Mutualfunds.customer_id'] = "$customerid"; }   
          if ($datedform && $datedto){
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                     array('Mutualfunds.created >= ' => $datedform,
                                           'Mutualfunds.created <= ' => $datedto
                                          )
                         )));
            }

            if ($applicationno !='' || $fapplicantname != '' || $panno != '' || $banks !='' || $customerid != '' || ($datedform && $datedto)){ 
                  $mf = $this->Mutualfunds->find('all', $conditions);
            }else{
               $mf = $this->Mutualfunds;
            }    
            $this->paginate = [
               'contain' => []
            ]; 
            $mf = $this->paginate($mf ,['order' => ['Fds.id' => 'DESC']]);
            $this->set(compact('mf','panno','applicationno','fapplicantname','banks','customerid','datedform','datedto'));
            $this->set('_serialize', ['mf']);
       
      }else{ 
         $applicationno = '';
         $fapplicantname = '';          
         $banks = '';
         $customerid = '';          
         $datedform = '';
         $datedto = ''; 
         $panno = '';
            $this->paginate = [
                'contain' => []
            ];
            $mf = $this->paginate($this->Mutualfunds,['order' => ['Mutualfunds.id' => 'DESC']]);
            $this->set(compact('mf','panno','applicationno','fapplicantname','banks','customerid','datedform','datedto'));
            $this->set('_serialize', ['mf']);
      } 
    }
        
    function mfreports() {
   
         $this->autoRender = false;
         // $this->layout = false;        
         $fileName = "mfreports_".date("d-m-y:h:s").".xls";        
         $this->loadModel('Mutualfunds'); 
         $this->loadModel('Customers'); 
         $this->loadModel('Banks'); 
         
        $applicationno = $this->request->query['applicationno'];
        $fapplicantname = $this->request->query['fapplicantname'];
        $panno = $this->request->query['panno'];
        $banks = $this->request->query['banks'];
        $customerid = $this->request->query['customerid']; 
        $datedform = $this->request->query['datedform'];
        $datedto = $this->request->query['datedto']; 
       if ($applicationno){ $conditions['conditions']['or']['Mutualfunds.applicationno LIKE'] = "%$applicationno%"; }
       if ($fapplicantname){ $conditions['conditions']['or']['Mutualfunds.firstapplicantname LIKE'] = "%$fapplicantname%"; }
       if ($panno){ $conditions['conditions']['or']['Mutualfunds.panno'] = "$panno"; }
       if ($banks){ $conditions['conditions']['or']['Mutualfunds.bank_id'] = "$banks"; }
       if ($customerid){ $conditions['conditions']['or']['Mutualfunds.customer_id'] = "$customerid"; }   
       if ($datedform && $datedto){
             $conditions = array(
                 'conditions' => array(
                 'and' => array(
                                 array('Mutualfunds.created >= ' => $datedform,
                                       'Mutualfunds.created <= ' => $datedto
                                      )
                     )));
        }

           if ($applicationno !='' || $fapplicantname != '' || $panno != '' || $banks !='' || $customerid != '' || ($datedform && $datedto)){ 
              $mf = $this->Mutualfunds->find('all', $conditions);
           }else{
              $mf = $this->Mutualfunds;
           }    

           $this->paginate = [
              'contain' => []
           ]; 
        $mf = $this->paginate($mf ,['order' => ['Mutualfunds.id' => 'DESC']]);
        $datafds = $mf->toArray(); 
            
         $headerRow = array("id", "Application No.", "paymentoption","Cheque No");
        
         for($i=0; $i< count($datafds); $i++){
            $data[] = [$datafds[$i]->id,$datafds[$i]->applicationno,$datafds[$i]->paymentoption,$datafds[$i]->chequeno];
          }          
          $this->ExportXls->export($fileName, $headerRow, $data);
        }
        
   public function ncd()
    {
      $this->loadModel('Ncds'); 
      $this->loadModel('Customers'); 
      $this->loadModel('Banks'); 
      $this->Search->addFilter('applicationno', [
          'attributes' => ['placeholder'=>'Appliation Number','label'=>'Appliation Number :','class'=>'searchfrm',],
       ]);
      $this->Search->addFilter('fapplicantname', [
          'attributes'=>['placeholder'=>'Applicant Name','label'=>'Applicant Name :','class'=>'searchfrm',],
       ]);
       $this->Search->addFilter('panno', [
          'attributes'=>['placeholder'=>'Pan No','label'=>'Pan Number :','class'=>'searchfrm',],
       ]);
      $this->Search->addFilter('datedform', [
         'attributes'=>['placeholder'=>'Date From','label'=>'Date From :','class'=>'searchfrm',],
      ]);
      $this->Search->addFilter('datedto', [
         'attributes'=>['placeholder'=>'Date to','label'=>'Date to :','class'=>'searchfrm',],
      ]); 
      $this->Search->addFilter('banks', [
        'attributes'=>['placeholder'=>'Bank Name','label'=>'Bank Name :','class'=>'searchfrm',],  
        'options' => $this->Ncds->Banks->find('list')->toArray(),
      ]);
      $this->Search->addFilter('customerid', [
        'attributes'=>['placeholder'=>'Customer Account','label'=>'Customer Account :','class'=>'searchfrm',],  
        'options' => $this->Ncds->Customers->find('list')->toArray(),
      ]);
     
      if (!empty($this->request->query)) { 
         $applicationno = $this->request->query['applicationno'];
         $fapplicantname = $this->request->query['fapplicantname']; 
         $panno = $this->request->query['panno'];
         $banks = $this->request->query['banks'];
         $customerid = $this->request->query['customerid'];          
         $datedform = $this->request->query['datedform'];
         $datedto = $this->request->query['datedto'];           
         
         if ($applicationno){ $conditions['conditions']['or']['Ncds.applicationno LIKE'] = "%$applicationno%"; }
         if ($fapplicantname){ $conditions['conditions']['or']['Ncds.fapplicantname LIKE'] = "%$fapplicantname%"; }
         if ($panno){ $conditions['conditions']['or']['Ncds.firstapplicantpan'] = "$panno"; }
         if ($banks){ $conditions['conditions']['or']['Ncds.bank_id'] = "$banks"; }
         if ($customerid){ $conditions['conditions']['or']['Ncds.customer_id'] = "$customerid"; }   
          if ($datedform && $datedto){
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                     array('Ncds.created >= ' => $datedform,
                                           'Ncds.created <= ' => $datedto
                                          )
                         )));
            }

            if ($applicationno !='' || $fapplicantname != '' || $panno != '' || $banks !='' || $customerid != '' || ($datedform && $datedto)){ 
                  $ncds = $this->Ncds->find('all', $conditions);
            }else{
                  $ncds = $this->Ncds;
            }    
            $this->paginate = [
               'contain' => []
            ]; 
            $ncds = $this->paginate($ncds ,['order' => ['Ncds.id' => 'DESC']]);
            $this->set(compact('ncds','panno','applicationno','fapplicantname','banks','customerid','datedform','datedto'));
            $this->set('_serialize', ['ncds']);
       
      }else{ 
         $applicationno = '';
         $fapplicantname = '';          
         $banks = '';
         $customerid = '';          
         $datedform = '';
         $datedto = ''; 
         $panno = '';
         
            $this->paginate = [
                'contain' => []
            ];
            $ncds = $this->paginate($this->Ncds,['order' => ['Ncds.id' => 'DESC']]);
            $this->set(compact('ncds','panno','applicationno','fapplicantname','banks','customerid','datedform','datedto'));
            $this->set('_serialize', ['ncds']);
      } 
    }
        
    function ncdreports() {
   
         $this->autoRender = false;
         // $this->layout = false;        
         $fileName = "ncdreports_".date("d-m-y:h:s").".xls";        
         $this->loadModel('Ncds'); 
         $this->loadModel('Customers'); 
         $this->loadModel('Banks'); 
         
        $applicationno = $this->request->query['applicationno'];
        $fapplicantname = $this->request->query['fapplicantname'];
        $panno = $this->request->query['panno'];
        $banks = $this->request->query['banks'];
        $customerid = $this->request->query['customerid']; 
        $datedform = $this->request->query['datedform'];
        $datedto = $this->request->query['datedto']; 
       if ($applicationno){ $conditions['conditions']['or']['Ncds.applicationno LIKE'] = "%$applicationno%"; }
       if ($fapplicantname){ $conditions['conditions']['or']['Ncds.fapplicantname LIKE'] = "%$fapplicantname%"; }
       if ($panno){ $conditions['conditions']['or']['Ncds.firstapplicantpan'] = "$panno"; }
       if ($banks){ $conditions['conditions']['or']['Ncds.bank_id'] = "$banks"; }
       if ($customerid){ $conditions['conditions']['or']['Ncds.customer_id'] = "$customerid"; }   
       if ($datedform && $datedto){
             $conditions = array(
                 'conditions' => array(
                 'and' => array(
                                 array('Ncds.created >= ' => $datedform,
                                       'Ncds.created <= ' => $datedto
                                      )
                     )));
        }

           if ($applicationno !='' || $fapplicantname != '' || $panno != '' || $banks !='' || $customerid != '' || ($datedform && $datedto)){ 
              $ncds = $this->Ncds->find('all', $conditions);
           }else{
              $ncds = $this->Ncds;
           }    

           $this->paginate = [
              'contain' => []
           ]; 
        $ncds = $this->paginate($ncds ,['order' => ['Ncds.id' => 'DESC']]);
        $datafds = $ncds->toArray(); 
            
         $headerRow = array("id", "Application No.", "paymentoption","Cheque No");
        
         for($i=0; $i< count($datafds); $i++){
            $data[] = [$datafds[$i]->id,$datafds[$i]->applicationno,$datafds[$i]->paymentoption,$datafds[$i]->chequeno];
          }          
          $this->ExportXls->export($fileName, $headerRow, $data);
        }
        
        
    public function ipo()
    {
      $this->loadModel('Ipos'); 
      $this->loadModel('Customers'); 
      $this->loadModel('Banks'); 
      $this->Search->addFilter('applicationno', [
          'attributes' => ['placeholder'=>'Appliation Number','label'=>'Appliation Number :','class'=>'searchfrm',],
       ]);
      $this->Search->addFilter('fapplicantname', [
          'attributes'=>['placeholder'=>'Applicant Name','label'=>'Applicant Name :','class'=>'searchfrm',],
       ]);
       $this->Search->addFilter('panno', [
          'attributes'=>['placeholder'=>'Pan No','label'=>'Pan Number :','class'=>'searchfrm',],
       ]);
      $this->Search->addFilter('datedform', [
         'attributes'=>['placeholder'=>'Date From','label'=>'Date From :','class'=>'searchfrm',],
      ]);
      $this->Search->addFilter('datedto', [
         'attributes'=>['placeholder'=>'Date to','label'=>'Date to :','class'=>'searchfrm',],
      ]); 
      $this->Search->addFilter('banks', [
        'attributes'=>['placeholder'=>'Bank Name','label'=>'Bank Name :','class'=>'searchfrm',],  
        'options' => $this->Ipos->Banks->find('list')->toArray(),
      ]);
      $this->Search->addFilter('customerid', [
        'attributes'=>['placeholder'=>'Customer Account','label'=>'Customer Account :','class'=>'searchfrm',],  
        'options' => $this->Ipos->Customers->find('list')->toArray(),
      ]);
     
      if (!empty($this->request->query)) { 
         $applicationno = $this->request->query['applicationno'];
         $fapplicantname = $this->request->query['fapplicantname']; 
         $panno = $this->request->query['panno'];
         $banks = $this->request->query['banks'];
         $customerid = $this->request->query['customerid'];          
         $datedform = $this->request->query['datedform'];
         $datedto = $this->request->query['datedto'];           
         
         if ($applicationno){ $conditions['conditions']['or']['Ipos.applicationno LIKE'] = "%$applicationno%"; }
         if ($fapplicantname){ $conditions['conditions']['or']['Ipos.fapplicantname LIKE'] = "%$fapplicantname%"; }
         if ($panno){ $conditions['conditions']['or']['Ipos.bidderpanno'] = "$panno"; }
         if ($banks){ $conditions['conditions']['or']['Ipos.bank_id'] = "$banks"; }
         if ($customerid){ $conditions['conditions']['or']['Ipos.customer_id'] = "$customerid"; }   
          if ($datedform && $datedto){
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                     array('Ipos.created >= ' => $datedform,
                                           'Ipos.created <= ' => $datedto
                                          )
                         )));
            }

            if ($applicationno !='' || $fapplicantname != '' || $panno != '' || $banks !='' || $customerid != '' || ($datedform && $datedto)){ 
               $ipos = $this->Ipos->find('all', $conditions);
            }else{
               $ipos = $this->Ipos;
            }    
            $this->paginate = [
               'contain' => []
            ]; 
            $ipos = $this->paginate($ipos ,['order' => ['Ipos.id' => 'DESC']]);
            $this->set(compact('ipos','panno','applicationno','fapplicantname','banks','customerid','datedform','datedto'));
            $this->set('_serialize', ['ipos']);
       
      }else{ 
         $applicationno = '';
         $fapplicantname = '';          
         $banks = '';
         $customerid = '';          
         $datedform = '';
         $datedto = ''; 
         $panno = '';
            $this->paginate = [
                'contain' => []
            ];
            $ipos = $this->paginate($this->Ipos,['order' => ['Ipos.id' => 'DESC']]);
            $this->set(compact('ipos','panno','applicationno','fapplicantname','banks','customerid','datedform','datedto'));
            $this->set('_serialize', ['ipos']);
      } 
    }
        
    function iporeports() {
   
         $this->autoRender = false;
         // $this->layout = false;        
         $fileName = "iporeports_".date("d-m-y:h:s").".xls";        
         $this->loadModel('Ipos'); 
         $this->loadModel('Customers'); 
         $this->loadModel('Banks'); 
         
        $applicationno = $this->request->query['applicationno'];
        $fapplicantname = $this->request->query['fapplicantname'];
        $panno = $this->request->query['panno'];
        $banks = $this->request->query['banks'];
        $customerid = $this->request->query['customerid']; 
        $datedform = $this->request->query['datedform'];
        $datedto = $this->request->query['datedto']; 
       if ($applicationno){ $conditions['conditions']['or']['Ipos.applicationno LIKE'] = "%$applicationno%"; }
       if ($fapplicantname){ $conditions['conditions']['or']['Ipos.fapplicantname LIKE'] = "%$fapplicantname%"; }
       if ($panno){ $conditions['conditions']['or']['Ipos.bidderpanno'] = "$panno"; }
       if ($banks){ $conditions['conditions']['or']['Ipos.bank_id'] = "$banks"; }
       if ($customerid){ $conditions['conditions']['or']['Ipos.customer_id'] = "$customerid"; }   
       if ($datedform && $datedto){
             $conditions = array(
                 'conditions' => array(
                 'and' => array(
                                 array('Ipos.created >= ' => $datedform,
                                       'Ipos.created <= ' => $datedto
                                      )
                     )));
        }

           if ($applicationno !='' || $fapplicantname != '' || $panno != '' || $banks !='' || $customerid != '' || ($datedform && $datedto)){ 
              $ipos = $this->Ipos->find('all', $conditions);
           }else{
              $ipos = $this->Ipos;
           }    

           $this->paginate = [
              'contain' => []
           ]; 
        $ipos = $this->paginate($ipos ,['order' => ['Ipos.id' => 'DESC']]);
        $datafds = $ipos->toArray(); 
            
        $headerRow = array("id", "Application No.", "paymentoption","Cheque No");
        
         for($i=0; $i< count($datafds); $i++){
            $data[] = [$datafds[$i]->id,$datafds[$i]->applicationno,$datafds[$i]->paymentoption,$datafds[$i]->chequeno];
          }          
          $this->ExportXls->export($fileName, $headerRow, $data);
        }    
}
