<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Searies Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Ncds
 *
 * @method \App\Model\Entity\Seary get($primaryKey, $options = [])
 * @method \App\Model\Entity\Seary newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Seary[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Seary|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Seary patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Seary[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Seary findOrCreate($search, callable $callback = null)
 */
class SeariesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('searies');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsTo('Ncds', [
            'foreignKey' => 'ncd_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->requirePresence('freofinterestpayment', 'create')
            ->notEmpty('freofinterestpayment');

        $validator
            ->requirePresence('minimumapplication', 'create')
            ->notEmpty('minimumapplication');

        $validator
            ->integer('facevalueofncd')
            ->requirePresence('facevalueofncd', 'create')
            ->notEmpty('facevalueofncd');

        $validator
            ->integer('inmultipalofrs')
            ->requirePresence('inmultipalofrs', 'create')
            ->notEmpty('inmultipalofrs');

        $validator
            ->requirePresence('tenor', 'create')
            ->notEmpty('tenor');

        $validator
            ->requirePresence('couponofcategory', 'create')
            ->notEmpty('couponofcategory');

        $validator
            ->requirePresence('effectiveyieldforcategory', 'create')
            ->notEmpty('effectiveyieldforcategory');

        $validator
            ->requirePresence('amountonmaturityforcategory', 'create')
            ->notEmpty('amountonmaturityforcategory');

        $validator
            ->requirePresence('maturitydate', 'create')
            ->notEmpty('maturitydate');

        $validator
            ->integer('noofncdsapply')
            ->requirePresence('noofncdsapply', 'create')
            ->notEmpty('noofncdsapply');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['ncd_id'], 'Ncds'));

        return $rules;
    }
}
