<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Fds Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Companies
 * @property \Cake\ORM\Association\BelongsTo $Branches
 * @property \Cake\ORM\Association\BelongsTo $Users
 * @property \Cake\ORM\Association\BelongsTo $Plans
 * @property \Cake\ORM\Association\BelongsTo $Subbrokers
 * @property \Cake\ORM\Association\BelongsTo $Banks
 * @property \Cake\ORM\Association\BelongsTo $Bankdetails
 *
 * @method \App\Model\Entity\Fd get($primaryKey, $options = [])
 * @method \App\Model\Entity\Fd newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Fd[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Fd|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Fd patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Fd[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Fd findOrCreate($search, callable $callback = null)
 */
class FdsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('fds');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsTo('Companies', [
            'foreignKey' => 'company_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('Branches', [
            'foreignKey' => 'branch_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('Brokers', [
            'foreignKey' => 'broker_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('Plans', [
            'foreignKey' => 'plan_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('Customers', [
            'foreignKey' => 'customer_id',
            'joinType' => 'INNER'
        ]); 
        $this->belongsTo('Banks', [
            'foreignKey' => 'bank_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create'); 
         $validator
            ->integer('productcompanyid')
            ->requirePresence('productcompanyid', 'create')
            ->notEmpty('productcompanyid');
        $validator
            ->requirePresence('typeofdeposit', 'create')
            ->notEmpty('typeofdeposit');        
      
        $validator
            ->requirePresence('tenure', 'create')
            ->notEmpty('tenure');
        
         /*$validator
            ->requirePresence('chequeno', 'create')
            ->notEmpty('chequeno');  */

        $validator
            ->requirePresence('amount', 'create')
            ->notEmpty('amount');
        
        $validator
            ->requirePresence('fapplicantname', 'create')
            ->notEmpty('fapplicantname');

        $validator
            ->requirePresence('despatchdate', 'create')
            ->notEmpty('despatchdate');
        $validator
            ->requirePresence('panno', 'create')
            ->notEmpty('panno');

      /*  $validator
            ->requirePresence('branch_id', 'create')
            ->notEmpty('branch_id');
       * 
       */
        $validator
            ->requirePresence('company_id', 'create')
            ->notEmpty('company_id');
        /* $validator
            ->requirePresence('bank_id', 'create')
            ->notEmpty('bank_id');*/
        $validator
            ->requirePresence('plan_id', 'create')
            ->notEmpty('plan_id');
        return $validator;
    }
    
    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
       // $rules->add($rules->isUnique(['email']));
        $rules->add($rules->existsIn(['company_id'], 'Companies'));
        $rules->add($rules->existsIn(['branch_id'], 'Branches'));
        $rules->add($rules->existsIn(['plan_id'], 'Plans'));
        $rules->add($rules->existsIn(['broker_id'], 'Brokers'));
        //$rules->add($rules->existsIn(['bank_id'], 'Banks'));

        return $rules;
    }
}
