<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\Event\Event;
/**
 * Users Controller
 *
 * @property \App\Model\Table\UsersTable $Users
 */
class UsersController extends AppController
{
    public function initialize()
    {
        parent::initialize();
       // $this->Auth->allow();
      
    }
    public function beforeFilter(Event $event){
       $this->Auth->allow(['register']);
    } 
   
    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
      $this->Search->addFilter('username',[
          'attributes'=>['placeholder'=>'username','label'=>'Username :','class'=>'searchfrm',],
       ]);
      $this->Search->addFilter('lastname',[
          'attributes'=>['placeholder'=>'last Name','label'=>'last Name :','class'=>'searchfrm',],
       ]);
      /* $this->Search->addFilter('id', [
            'options' => $this->Groups->name->find('list')->toArray(),
       ]); */
      
      //$this->Search->addFilter('Groups');
      if (!empty($this->request->query)) { 
         $query = $this->request->query['username'];
         $lastname = $this->request->query['lastname'];       
          
         // $conditions['conditions']['and']['Users.username LIKE'] = "%$query%";
         if ($query){ $conditions['conditions']['or']['Users.username LIKE'] = "%$query%"; }
         if ($lastname){ $conditions['conditions']['or']['Users.lastname LIKE'] = "%$lastname%"; }
            if ($query !='' || $lastname != ''){ 
               $users = $this->Users->find('all', $conditions);
            }else{
               $users = $this->Users;
            }    
            $this->paginate = [
               'contain' => ['Groups']
            ]; 
            $users = $this->paginate($users ,['order' => ['Users.username' => 'ASC']]);
            $this->set(compact('users'));
            $this->set('_serialize', ['users']);
       
      }else{ 
        $this->paginate = [
            'contain' => ['Groups']
        ];
        $users = $this->paginate($this->Users,['order' => ['Users.username' => 'Asc']]);
        //$users = array();
        $this->set(compact('users'));
        $this->set('_serialize', ['users']);
      }      
    }

 
    /**
     * View method
     *
     * @param string|null $id User id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $user = $this->Users->get($id, [
            'contain' => ['Groups', 'Posts']
        ]);

        $this->set('user', $user);
        $this->set('_serialize', ['user']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $user = $this->Users->newEntity();
        
        if ($this->request->is('post')) {
            $user = $this->Users->patchEntity($user, $this->request->data);
            
            /* insert account no */
            $query = $this->Users->find('all', [
                'order' => ['Users.created' => 'DESC']
            ]);
            $lastuid = $query->first()->id;         
            $accountNo = (1000 + ($lastuid + 1));
            $user->accountno = $accountNo;
           
            
            if ($this->Users->save($user)) {
                $this->Flash->success(__('The user has been saved.'));

                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The user could not be saved. Please, try again.'));
            }
        }
       //$groups = $this->Users->Groups->find('list', ['limit' => 200]);
       $parameters = array();
       
       if($this->Auth->user('group_id')=='3'){
        $parameters = array(
		'conditions' => array(
			'id NOT IN' => array(2,3)),
		);
	}
		 
        $groups = $this->Users->Groups->find('list',$parameters);      
        $usercompanies = $this->Users->Companies->find('list')-> where(['associatewith' => 'user'])->order(['company' => 'DESC']);
	$userbranches = $this->Users->Branches->find('list', ['limit' => 200]);
	//pr($userbranches->toArray());
        $gender  = array('male'=>'Male','female'=>'Female');
        $this->set(compact('user', 'groups', 'usercompanies', 'userbranches','gender'));
        $this->set('_serialize', ['user']);
    }

    /**
     * Edit method
     *
     * @param string|null $id User id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $user = $this->Users->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $user = $this->Users->patchEntity($user, $this->request->data);
            if ($this->Users->save($user)) {
                $this->Flash->success(__('The user has been saved.'));

                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The user could not be saved. Please, try again.'));
            }
        }
        //$groups = $this->Users->Groups->find('list', ['limit' => 200]);
        $parameters = array();
       
       if($this->Auth->user('group_id')=='3'){
        $parameters = array(
		'conditions' => array(
			'id NOT IN' => array(2,3)),
		);
	}
		 
        $groups = $this->Users->Groups->find('list',$parameters); 
        $usercompanies = $this->Users->Companies->find('list')-> where(['associatewith' => 'user'])->order(['company' => 'DESC']);
	$userbranches = $this->Users->Branches->find('list', ['limit' => 200]);
        $gender  = array('male'=>'Male','female'=>'Female');
        $this->set(compact('user', 'groups', 'usercompanies', 'userbranches','gender'));
        $this->set('_serialize', ['user']);
     }

    /**
     * Delete method
     *
     * @param string|null $id User id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $user = $this->Users->get($id);
        if ($this->Users->delete($user)) {
            $this->Flash->success(__('The user has been deleted.'));
        } else {
            $this->Flash->error(__('The user could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
    
    public function login() {
        if ($this->request->is('post')) {
            $user = $this->Auth->identify();
            if ($user) {
                $this->Auth->setUser($user);
                return $this->redirect($this->Auth->redirectUrl());
            }
            $this->Flash->error(__('Your username or password was incorrect.'));
        }
    }
    public function logout() {
        $this->Flash->success(__('Good-Bye'));
        $this->redirect($this->Auth->logout());
    }

     // Register    
    public function register(){
        $user = $this->Users->newEntity();
        if($this->request->is('post')){
            $user = $this->Users->patchEntity($user,$this->request->data);
            if($this->Users->save($user)){
                $this->Flash->success('You are register and can login');
                $this->redirect(['action'=>'login']);                
            }else{
                $this->Flash->error('You are not registered');
            }
        }
        $this->set(compact('user'));
        $this->set('_serialzie',['user']);
    }
    
    //Dashboard
    public function dashboard(){

    }
    
    
    
}
