<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Bankbranches Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Banks
 *
 * @method \App\Model\Entity\Bankbranch get($primaryKey, $options = [])
 * @method \App\Model\Entity\Bankbranch newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Bankbranch[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Bankbranch|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Bankbranch patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Bankbranch[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Bankbranch findOrCreate($search, callable $callback = null)
 */
class BankbranchesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('bankbranches');
        $this->displayField('branchaddress');
        $this->primaryKey('id');

        $this->belongsTo('Banks', [
            'foreignKey' => 'bank_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->requirePresence('branchaddress', 'create')
            ->notEmpty('branchaddress');

      /*  $validator
            ->requirePresence('micrcode', 'create')
            ->notEmpty('micrcode');
   */
        $validator
            ->requirePresence('neftcode', 'create')
            ->notEmpty('neftcode');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['bank_id'], 'Banks'));

        return $rules;
    }
}
