<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * Searies Controller
 *
 * @property \App\Model\Table\SeariesTable $Searies
 */
class SeariesController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Ncds']
        ];
        $searies = $this->paginate($this->Searies);

        $this->set(compact('searies'));
        $this->set('_serialize', ['searies']);
    }

    /**
     * View method
     *
     * @param string|null $id Seary id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $seary = $this->Searies->get($id, [
            'contain' => ['Ncds']
        ]);

        $this->set('seary', $seary);
        $this->set('_serialize', ['seary']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $seary = $this->Searies->newEntity();
        if ($this->request->is('post')) {
            $seary = $this->Searies->patchEntity($seary, $this->request->data);
            if ($this->Searies->save($seary)) {
                $this->Flash->success(__('The seary has been saved.'));
                
                 return $this->redirect(['controller' => 'Ncds','action' => 'edit',$seary->ncd_id]);
                //return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The seary could not be saved. Please, try again.'));
            }
        }
        $ncds = $this->Searies->Ncds->find('list', ['limit' => 200]);
        $this->set(compact('seary', 'ncds'));
        $this->set('_serialize', ['seary']);
    }

     /**
     * Add ajax method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function addajax()
    {
        $seary = $this->Searies->newEntity();
        if ($this->request->is('post')) {
            $seary = $this->Searies->patchEntity($seary, $this->request->data);
            if ($this->Searies->save($seary)) {
                $this->Flash->success(__('The seary has been saved.'));                
                 return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The seary could not be saved. Please, try again.'));
            }
        }
        $ncds = $this->Searies->Ncds->find('list', ['limit' => 200]);
        $this->set(compact('seary', 'ncds'));
        $this->set('_serialize', ['seary']);
    }

    
    /**
     * Edit method
     *
     * @param string|null $id Seary id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $seary = $this->Searies->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $seary = $this->Searies->patchEntity($seary, $this->request->data);
            if ($this->Searies->save($seary)) {
                $this->Flash->success(__('The seary has been saved.'));
               
                return $this->redirect(['controller' => 'Ncds','action' => 'edit',$seary->ncd_id]);
                //return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The seary could not be saved. Please, try again.'));
            }
        }
        $ncds = $this->Searies->Ncds->find('list', ['limit' => 200]);
        $this->set(compact('seary', 'ncds'));
        $this->set('_serialize', ['seary']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Seary id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
      //  $this->request->allowMethod(['post', 'delete']);
        $seary = $this->Searies->get($id);
        if ($this->Searies->delete($seary)) {
            $this->Flash->success(__('The seary has been deleted.'));
        } else {
            $this->Flash->error(__('The seary could not be deleted. Please, try again.'));
        }
        
       return $this->redirect(['controller' => 'Ncds','action' => 'edit',$seary->ncd_id]);
       // return $this->redirect(['action' => 'index']);
    }
}
