<?php
namespace App\Controller;
use App\Controller\AppController;
use Cake\ORM\TableRegistry;
use Cake\Datasource\ConnectionManager;
class ReportsController extends AppController
{
    public $components = array('ExportXls');
   
    public function fds()
    {
      $this->loadModel('Fds'); 
      $this->loadModel('Customers'); 
      $this->loadModel('Banks'); 
     
       $all = array('all'=>'All');
       if($this->Auth->user('group_id')=='2'){ 
            $branch = $this->Fds->Branches->find('list')->toArray();
			$this->Search->addFilter('branch', [
				'attributes'=>['placeholder'=>'Branch Name','label'=>'Branch Name :','class'=>'searchfrm','value' => isset($this->request->query['branch'])?$this->request->query['branch']:''],  
				'options' => $all+$this->Fds->Branches->find('list')->toArray(),
			]);
        }
	    $this->Search->addFilter('company', [
           'attributes'=>['placeholder'=>'Company Name','label'=>'Company Name :','class'=>'searchfrm','value' => isset($this->request->query['company'])?$this->request->query['company']:''],  
            'options' => $all+$this->Fds->Companies->find('list')-> where(['associatewith' => 'product'])->andWhere(['Companies.productid ='=>'2'] )->order(['company' => 'ASC'])->toArray(),
        ]);
        $mainbrokers = $this->Fds->Brokers->find('list', [
            'keyField' => 'id',
            'valueField' => 'name'
        ])-> where(['role' => 'Mainbroker'])->toArray();
	  
	    $this->Search->addFilter('mainbrokerid', [
           'attributes'=>['placeholder'=>'Main Broker','label'=>'Main Broker :','class'=>'searchfrm','value' => isset($this->request->query['mainbrokerid'])?$this->request->query['mainbrokerid']:''],  
            'options' => $all+$mainbrokers,
        ]);
	    $typeofdeposit = array('fresh'=>'Fresh','renewal'=>'Renewal','both'=>'Both');
        $this->Search->addFilter('typeofdeposit', [
         'attributes'=>['placeholder'=>'Type of Deposit','label'=>'Type of Deposit :','class'=>'searchfrm','value' => isset($this->request->query['typeofdeposit'])?$this->request->query['typeofdeposit']:'',],  
         'options' => $all+$typeofdeposit,
        ]); 
        $this->Search->addFilter('datedform', [
         'attributes'=>['placeholder'=>'Maturity From Date','label'=>'Maturity From Date :','class'=>'searchfrm','value' => isset($this->request->query['datedform'])?$this->request->query['datedform']:''],
        ]);
        $this->Search->addFilter('datedto', [
         'attributes'=>['placeholder'=>'Maturity To Date','label'=>'Maturity To Date :','class'=>'searchfrm','value' => isset($this->request->query['datedto'])?$this->request->query['datedto']:''],
        ]); 

        $conditions = ''; 
        if($this->Auth->user('group_id')=='3'){             
            $branch_id = $this->Auth->user('branch_id');     
            $conditions['conditions']['and']['Fds.posteduserbranchid'] = "$branch_id";
        }elseif($this->Auth->user('group_id')=='4' || $this->Auth->user('group_id')=='5' || $this->Auth->user('group_id')=='6' || $this->Auth->user('group_id')=='7'){ 
            $branch_id = $this->Auth->user('branch_id');    
            $userid = $this->Auth->user('id'); 
            $conditions['conditions']['and']['Fds.posteduserbranchid'] = "$branch_id";
            $conditions['conditions']['and']['Fds.postedby'] = "$userid";
        }  
        if (!empty($this->request->query) && count($this->request->query) > 1) { 
           if($this->Auth->user('group_id')=='2'){
    		    if(!empty($this->request->query['branch'])){
    		        $branch = (($this->request->query['branch'] != '')? $this->request->query['branch'] : '');
    		    }else{
    		    	$branch = '';   
    		   }			  
		   } 
		   $mainbrokerid = $this->request->query['mainbrokerid'];
	       $company = $this->request->query['company'];
           $typeofdeposit = $this->request->query['typeofdeposit']; 
            
           $dated2 =  (($this->request->query['datedform'] != '')? $this->request->query['datedform'] : '');
		   $date_from = explode('/',$dated2);
           $datedform  = implode('-', array_reverse($date_from));
         
	       $dated1= (($this->request->query['datedto']!='')? $this->request->query['datedto']:'');
	       $date_to = explode('/',$dated1);
           $datedto  = implode('-', array_reverse($date_to));
         
        
         /* if ($datedform && $datedto){
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                    array('trim(Fds.maturitydate) >= ' => $datedform,
                                       'trim(Fds.maturitydate) <= ' => $datedto
                                      )
                         )));
            }*/
            if ($datedform && $datedto){             
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                     array('Fds.maturitydate >= ' => $datedform,
                                       'Fds.maturitydate <= ' => $datedto
                                      )
                         )));
            }
         if (($mainbrokerid !='') && ($mainbrokerid !='all')){ $conditions['conditions']['and']['Fds.mainbrokerid'] = "$mainbrokerid"; }
         if (($branch !='') && ($branch !='all')){ $conditions['conditions']['and']['Fds.branch_id'] = "$branch"; }
	     if ($company!='' && $company!='all'){ $conditions['conditions']['and']['Fds.productcompanyid'] = "$company"; }
         if ($typeofdeposit!='' && $typeofdeposit!='all'){ $conditions['conditions']['and']['Fds.typeofdeposit LIKE'] = "%$typeofdeposit%"; }   
         
            if (($company !='' && $company !='all') || ($typeofdeposit != '' && $typeofdeposit != 'all' ) || ($datedform && $datedto)){ 
                $fds = $this->Fds->find('all', $conditions);
				$cnt = $fds->count();
				if($fds) {
					$total_amount = 0;
					foreach ($fds as $fd) {
						$total_amount += $fd->amount;
					}
				}
            }elseif($company =='all' || $typeofdeposit == 'all'){
		$fds = $this->Fds;
			$fds1 = $this->Fds->find('all', array('contain' => ['Companies', 'Brokers', 'Plans']));
			$cnt = $fds1->count();
			if($fds1) {
				$total_amount = 0;
				foreach ($fds1 as $fd) {
				$total_amount += $fd->amount;
				}
				}
	    }else{
                 if($conditions != ''){
                    $fds = $this->Fds->find('all', $conditions);
					$cnt = $fds->count();
					if($fds) {
						$total_amount = 0;
						foreach ($fds as $fd) {
							$total_amount += $fds->amount;
						}
					}
                  }else{
                    $fds = $this->Fds;
					$fds1 = $this->Fds->find('all', array('contain' => ['Companies', 'Brokers', 'Plans']));
			$cnt = $fds1->count();
			if($fds1) {
				$total_amount = 0;
				foreach ($fds1 as $fd) {
				$total_amount += $fd->amount;
				}
				}
                  } 
            }    
            //, 'Banks'
            $this->paginate = [
                'contain' => ['Companies', 'Brokers', 'Plans']
            ]; 
            $fds = $this->paginate($fds ,['order' => ['Fds.id' => 'DESC']]);
            $this->set(compact('fds','company','typeofdeposit','datedform','datedto','panno','cnt','total_amount','dated2','dated1'));
            $this->set('_serialize', ['fds']);
       
      }else{ 
        // $applicationno = '';
        // $fapplicantname = '';          
        // $banks = '';
         $typeofdeposit = '';          
         $datedform = '';
         $datedto = ''; 
	 $company = '';
        // $panno = '';
     /*    if($conditions != ''){
           $fds = $this->Fds->find('all', $conditions);
         }else{
           $fds = $this->Fds;
         } 
            $this->paginate = [
                 'contain' => ['Companies', 'Branches','Brokers', 'Plans', 'Banks']
            ];
      * 
      */
                 $fds = '';
           // $fds = $this->paginate($fds,['order' => ['Fds.id' => 'DESC']]);
          $this->set(compact('fds','company','banks','typeofdeposit','datedform','datedto','cnt','total_amount'));
          $this->set('_serialize', ['fds']);  
  
      } 
    }
        
    function fdreports() {
   
         $this->autoRender = false;
         // $this->layout = false;        
         $fileName = "fdreports_".date("d-m-y:h:s").".xls";        
         $this->loadModel('Fds'); 
         $this->loadModel('Customers'); 
         $this->loadModel('Banks'); 
         $this->loadModel('Plans');
        $conditions = '';
        if($this->Auth->user('group_id')=='3'){ 
            $branch_id = $this->Auth->user('branch_id');     
            $conditions['conditions']['and']['Fds.posteduserbranchid'] = "$branch_id";
        }elseif($this->Auth->user('group_id')=='4' || $this->Auth->user('group_id')=='5' || $this->Auth->user('group_id')=='6' || $this->Auth->user('group_id')=='7'){ 
            $branch_id = $this->Auth->user('branch_id');    
            $userid = $this->Auth->user('id'); 
            $conditions['conditions']['and']['Fds.posteduserbranchid'] = "$branch_id";
            $conditions['conditions']['and']['Fds.postedby'] = "$userid";
        }  
        /* $applicationno = $this->request->query['applicationno'];
        $fapplicantname = $this->request->query['fapplicantname'];
        $panno = $this->request->query['panno'];
        $banks = $this->request->query['banks']; */
	$company = $this->request->query['company'];
        $typeofdeposit = $this->request->query['typeofdeposit']; 
        $datedform = $this->request->query['datedform'];
        $datedto = $this->request->query['datedto']; 
     /*   if ($applicationno){ $conditions['conditions']['and']['Fds.applicationno LIKE'] = "%$applicationno%"; }
       if ($fapplicantname){ $conditions['conditions']['and']['Fds.fapplicantname LIKE'] = "%$fapplicantname%"; }
       if ($panno){ $conditions['conditions']['and']['Fds.panno'] = "$panno"; }
       if ($banks){ $conditions['conditions']['and']['Fds.bank_id'] = "$banks"; } */
	    if ($company){ $conditions['conditions']['and']['Fds.productcompanyid'] = "$company"; }
       if ($typeofdeposit){ $conditions['conditions']['and']['Fds.typeofdeposit LIKE'] = "%$typeofdeposit%"; }   
     if ($datedform && $datedto){             
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                     array('Fds.maturitydate >= ' => $datedform,
                                       'Fds.maturitydate <= ' => $datedto
                                      )
                         )));
            }

           if (($company !='' && $company !='all') || ($typeofdeposit != '' && $typeofdeposit != 'all' ) || ($datedform && $datedto)){ 
                $fds = $this->Fds->find('all', $conditions);
            }elseif($company =='all' || $typeofdeposit == 'all'){
		$fds = $this->Fds;
	    }else{
                 if($conditions != ''){
                    $fds = $this->Fds->find('all', $conditions);
                  }else{
                    $fds = $this->Fds;
                  } 
            }     

          $this->paginate = [
                 'contain' => ['Companies', 'Brokers', 'Plans']
            ];
        $fds = $this->paginate($fds ,['order' => ['Fds.id' => 'DESC']]);
        $datafds = $fds->toArray(); 
      // pr($datafds);    
     
        $headerRow = array("Sr.","Client Name", "Subbroker",'Mainbroker','Product Company','Cheque No','FDR No','Amount','Mature On','Remark');
        $j=1;
            for($i=0; $i< count($datafds); $i++){
                $data[] = [$j,$datafds[$i]->fapplicantname,$datafds[$i]->broker->name,$datafds[$i]->broker->name,$datafds[$i]->company->company,$datafds[$i]->chequeno,$datafds[$i]->fdrno,$datafds[$i]->amount,$datafds[$i]->maturitydate,''];
          $j++;  
                }         
       
        $this->ExportXls->export($fileName, $headerRow, $data);
    }   
    
   public function fdcprofile(){
     $this->loadModel('Fds'); 
      $this->loadModel('Customers'); 
      $this->loadModel('Banks'); 
     
        $all = array('all'=>'All');
        $this->Search->addFilter('company', [
           'attributes'=>['placeholder'=>'Company Name','label'=>'Company Name :','class'=>'searchfrm','value' => isset($this->request->query['company'])?$this->request->query['company']:''],  
            'options' => $all+$this->Fds->Companies->find('list')-> where(['associatewith' => 'product'])->andWhere(['Companies.productid ='=>'2'] )->order(['company' => 'ASC'])->toArray(),
        ]);
	    $this->Search->addFilter('fapplicantname', [
          'attributes'=>['placeholder'=>'Applicant Name','label'=>'Applicant Name :','class'=>'searchfrm','value' => isset($this->request->query['fapplicantname'])?$this->request->query['fapplicantname']:''], 'options' => $all+$this->Fds->Customers->find('list',['keyField' => 'name','valueField' => 'name'])->order(['Customers.name'=>'ASC'])->group(['Customers.name'])->toArray(),
       ]);
	   $typeofdeposit = array('fresh'=>'Fresh','renewal'=>'Renewal','both'=>'Both');
      $this->Search->addFilter('typeofdeposit', [
        'attributes'=>['placeholder'=>'Type of Deposit','label'=>'Type of Deposit :','class'=>'searchfrm','value' => isset($this->request->query['typeofdeposit'])?$this->request->query['typeofdeposit']:''],  
        'options' => $all+$typeofdeposit,
      ]);
      $this->Search->addFilter('datedform', [
         'attributes'=>['placeholder'=>'Despatch Start Date','label'=>'Despatch Start Date :','class'=>'searchfrm','value' => isset($this->request->query['datedform'])?$this->request->query['datedform']:''],
      ]);
      $this->Search->addFilter('datedto', [
         'attributes'=>['placeholder'=>'Despatch End Date','label'=>'Despatch End Date :','class'=>'searchfrm','value' => isset($this->request->query['datedto'])?$this->request->query['datedto']:''],
      ]); 
    
      
      
     $conditions = ''; 
      if($this->Auth->user('group_id')=='3'){             
            $branch_id = $this->Auth->user('branch_id');     
            $conditions['conditions']['and']['Fds.posteduserbranchid'] = "$branch_id";
        } 
		elseif($this->Auth->user('group_id')=='4' || $this->Auth->user('group_id')=='5' || $this->Auth->user('group_id')=='6' || $this->Auth->user('group_id')=='7'){ 
            $branch_id = $this->Auth->user('branch_id');    
            $userid = $this->Auth->user('id'); 
            $conditions['conditions']['and']['Fds.posteduserbranchid'] = "$branch_id";
            $conditions['conditions']['and']['Fds.postedby'] = "$userid";
        } 
      if (!empty($this->request->query) && count($this->request->query) > 1) { 
        // $applicationno = $this->request->query['applicationno'];
        $company = $this->request->query['company'];
         $fapplicantname = $this->request->query['fapplicantname']; 
        /*  $panno = $this->request->query['panno'];
         $banks = $this->request->query['banks']; */
         $typeofdeposit = $this->request->query['typeofdeposit']; 
        /*  
         $datedform = $this->request->query['datedform'];
         $datedto = $this->request->query['datedto'];  */
            $dated2 =  (($this->request->query['datedform'] != '')? $this->request->query['datedform'] : '');
		// $dated2=$this->request->query['datedform'] ;
		 pr($dated2);
		 $date1 = explode('/',$dated2);
         // $datedform = implode('-',$date1);
		  
       $datedform  = implode('-', array_reverse($date1));
		//pr($datedform);
		$dated1= $this->request->query['datedto'];
		$date = explode('/',$dated1);

        $datedto  = implode('-', array_reverse($date));
         /*  if ($datedform && $datedto){
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                    array('trim(Fds.maturitydate) >= ' => $datedform,
                                       'trim(Fds.maturitydate) <= ' => $datedto
                                      )
                         )));
            } */
			if ($datedform && $datedto){             
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                     array('Fds.despatchdate >= ' => $datedform,
                                            'Fds.despatchdate <= ' => $datedto
                                      )
                         )));
            }
            if ($company!='' && $company!='all'){ $conditions['conditions']['and']['Fds.productcompanyid'] = "$company"; }
        // if ($applicationno){ $conditions['conditions']['and']['Fds.applicationno LIKE'] = "%$applicationno%"; }
         if ($fapplicantname!='' && $fapplicantname!='all'){ $conditions['conditions']['and']['Fds.fapplicantname LIKE'] = "%$fapplicantname%"; }
        /*  if ($panno){ $conditions['conditions']['and']['Fds.panno'] = "$panno"; }
         if ($banks){ $conditions['conditions']['and']['Fds.bank_id'] = "$banks"; } */
         if ($typeofdeposit!='' && $typeofdeposit!='all'){ $conditions['conditions']['and']['Fds.typeofdeposit LIKE'] = "%$typeofdeposit%"; }   
         
          if (($company !='' && $company !='all') || ($fapplicantname != '' && $fapplicantname != 'all') || ($typeofdeposit != '' && $typeofdeposit != 'all') || ($datedform && $datedto)){ 
                $fds = $this->Fds->find('all', $conditions);
				$cnt = $fds->count();
				if($fds){
					$total_amount = 0;
					foreach ($fds as $fd) {
						$total_amount += $fd->amount;
					}
				}
            }elseif($company =='all' || $fapplicantname == 'all' || $typeofdeposit == 'all'){
		$fds = $this->Fds;
		$fds1 = $this->Fds->find('all', array('contain' => ['Companies', 'Brokers', 'Plans']));
			$cnt = $fds1->count();
			if($fds1) {
				$total_amount = 0;
				foreach ($fds1 as $fd) {
				$total_amount += $fd->amount;
				}
				}
	    }else{
                 if($conditions != ''){
                    $fds = $this->Fds->find('all', $conditions);
					$cnt = $fds->count();
				if($fds){
					$total_amount = 0;
					foreach ($fds as $fd) {
						$total_amount += $fds->amount;
					}
				}
                  }else{
                    $fds = $this->Fds;
					$fds1 = $this->Fds->find('all', array('contain' => ['Companies', 'Brokers', 'Plans']));
			$cnt = $fds1->count();
			if($fds1) {
				$total_amount = 0;
				foreach ($fds1 as $fd) {
				$total_amount += $fd->amount;
				}
				}
                  } 
            }   
            
               
            $this->paginate = [
                'contain' => ['Companies', 'Brokers', 'Plans']
            ]; 
            $fds = $this->paginate($fds ,['order' => ['Fds.id' => 'DESC']]);
            $this->set(compact('fds','fapplicantname','typeofdeposit','datedform','datedto','cnt','total_amount','dated2','dated1'));
            $this->set('_serialize', ['fds']);
       
      }else{ 
         //$applicationno = '';
         $fapplicantname = '';          
        // $banks = '';
         $typeofdeposit = '';          
         $datedform = '';
         $datedto = ''; 
        // $panno = '';
      /*   if($conditions != ''){
             $fds = $this->Fds->find('all', $conditions);
         }else{
             $fds = $this->Fds;
         } 
            $this->paginate = [
                 'contain' => ['Companies', 'Branches','Brokers', 'Plans', 'Banks']
            ];
            $fds = $this->paginate($fds,['order' => ['Fds.id' => 'DESC']]);
       * 
       */
          $fds = '';
            $this->set(compact('fds','panno','applicationno','fapplicantname','banks','typeofdeposit','datedform','datedto'));
            $this->set('_serialize', ['fds']);
      } 
   }
        
    function fdcprofilereports() {
   
         $this->autoRender = false;
         // $this->layout = false;        
         $fileName = "fdreports_".date("d-m-y:h:s").".xls";        
         $this->loadModel('Fds'); 
         $this->loadModel('Customers'); 
         $this->loadModel('Banks'); 
         $this->loadModel('Plans');
         
        if($this->Auth->user('group_id')=='3'){
            $conditions = '';  
            $branch_id = $this->Auth->user('branch_id');     
            $conditions['conditions']['and']['Fds.posteduserbranchid'] = "$branch_id";
        }   
      //  $applicationno = $this->request->query['applicationno'];
        $fapplicantname = $this->request->query['fapplicantname'];
       /*  $panno = $this->request->query['panno'];
        $banks = $this->request->query['banks']; */
        $typeofdeposit = $this->request->query['typeofdeposit']; 
        $datedform = $this->request->query['datedform'];
        $datedto = $this->request->query['datedto']; 
     //  if ($applicationno){ $conditions['conditions']['and']['Fds.applicationno LIKE'] = "%$applicationno%"; }
       if ($fapplicantname){ $conditions['conditions']['and']['Fds.fapplicantname LIKE'] = "%$fapplicantname%"; }
      /*  if ($panno){ $conditions['conditions']['and']['Fds.panno'] = "$panno"; }
       if ($banks){ $conditions['conditions']['and']['Fds.bank_id'] = "$banks"; } */
       if ($typeofdeposit){ $conditions['conditions']['and']['Fds.typeofdeposit LIKE'] = "%$typeofdeposit%"; }   
      /* if ($datedform && $datedto){
             $conditions = array(
                 'conditions' => array(
                 'and' => array(
                                array('trim(Fds.maturitydate) >= ' => $datedform,
                                       'trim(Fds.maturitydate) <= ' => $datedto
                                      )
                     )));
        }*/
        if ($datedform && $datedto){             
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                     array('Fds.maturitydate >= ' => $datedform,
                                       'Fds.maturitydate <= ' => $datedto
                                      )
                         )));
            }

            if (($fapplicantname != '' && $fapplicantname != 'all') || ($typeofdeposit != '' && $typeofdeposit != 'all') || ($datedform && $datedto)){ 
                $fds = $this->Fds->find('all', $conditions);
            }elseif($fapplicantname == 'all' || $typeofdeposit == 'all'){
		$fds = $this->Fds;
	    }else{
                 if($conditions != ''){
                    $fds = $this->Fds->find('all', $conditions);
                  }else{
                    $fds = $this->Fds;
                  } 
            }   

          $this->paginate = [
                 'contain' => ['Companies','Brokers', 'Plans', 'Banks']
            ];
        $fds = $this->paginate($fds ,['order' => ['Fds.id' => 'DESC']]);
        $datafds = $fds->toArray(); 
       //pr($datafds);    
     
        $headerRow = array("Sr.","Investor", "Fund+Scheme",'Type','Folio No','Option','Start Date','End Date','Amount');
        $j=1;
            for($i=0; $i< count($datafds); $i++){
                $data[] = [$j,$datafds[$i]->fapplicantname,$datafds[$i]->plan->Planname,$datafds[$i]->typeofdeposit,$datafds[$i]->fdrno,$datafds[$i]->fdrno,$datafds[$i]->planstartdate,$datafds[$i]->maturitydate,$datafds[$i]->amount];
            $j++;
                }         
       
        $this->ExportXls->export($fileName, $headerRow, $data);
    }
    
  /* fd profile   */
    
	//SIP Maturity Report
    public function mf(){
       $this->loadModel('Mutualfunds'); 
       $this->loadModel('Customers'); 
       $this->loadModel('Banks'); 
	   $all = array('all'=>'All'); 
   
       $this->Search->addFilter('company', [
        'attributes'=>['placeholder'=>'Company','label'=>'MutualFund :','class'=>'searchfrm', 'value' => isset($this->request->query['company'])?$this->request->query['company']:''],  
        'options' => $all+$this->Mutualfunds->Companies->find('list')-> where(['associatewith' => 'product'])->andWhere(['Companies.productid ='=>'1'] )->order(['company' => 'ASC'])->toArray(),
       ]);
	   
       $this->Search->addFilter('scheme', [
        'attributes'=>['placeholder'=>'Scheme Name','label'=>'Scheme Name :','class'=>'searchfrm','value' => isset($this->request->query['scheme'])?$this->request->query['scheme']:'',],  
        'options' => $all+$this->Mutualfunds->Mffunds->find('list')->order(['fundname' => 'ASC'])->group(['fundname'])->toArray(),
       ]);
       if($this->Auth->user('group_id')=='2'){ 
          $branch = $this->Mutualfunds->Branches->find('list')->toArray();
         
        $this->Search->addFilter('branch', [
        'attributes'=>['placeholder'=>'Branch Name','label'=>'Branch Name :','class'=>'searchfrm','value' => isset($this->request->query['branch'])?$this->request->query['branch']:'',],  
        'options' => $all+$this->Mutualfunds->Branches->find('list')->toArray(),
       ]);
       }  
       
      	$this->Search->addFilter('datedform', [
         'attributes'=>['placeholder'=>'Maturity From Date','label'=>'Maturity From Date :','class'=>'searchfrm','value' => isset($this->request->query['datedform'])?$this->request->query['datedform']:''],
        ]);
        $this->Search->addFilter('datedto', [
           'attributes'=>['placeholder'=>'Maturity To Date','label'=>'Maturity To Date :','class'=>'searchfrm','value' => isset($this->request->query['datedto'])?$this->request->query['datedto']:''],
        ]);
    
		$conditions = '';  
		if($this->Auth->user('group_id')=='3'){        
			$branch_id = $this->Auth->user('branch_id');     
			$conditions['conditions']['and']['Mutualfunds.posteduserbranchid'] = "$branch_id";
		}
       if (!empty($this->request->query) && count($this->request->query) > 1) { 
       
		 $branch = $this->request->query['branch'];
		 $company = $this->request->query['company']; 
		 $scheme = $this->request->query['scheme'];
      
         $dated2 =  (($this->request->query['datedform'] != '')? $this->request->query['datedform'] : '');
		 $date_from = explode('/',$dated2);
         $datedform  = implode('-', array_reverse($date_from));
         
	     $dated1= (($this->request->query['datedto']!='')? $this->request->query['datedto']:'');
	     $date_to = explode('/',$dated1);
         $datedto  = implode('-', array_reverse($date_to));         
            if ($datedform && $datedto){             
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                     array('Mutualfunds.maturitydate >= ' => $datedform,
                                       'Mutualfunds.maturitydate <= ' => $datedto
                                      )
                         )));
            }
         $conditions['conditions']['and']['Mutualfunds.typeofdeposit'] = 'SIP';
		 if ($branch!='' && $branch!='all'){ $conditions['conditions']['and']['Mutualfunds.branch_id'] = "$branch"; }
         if ($company!='' && $company!='all'){ $conditions['conditions']['and']['Mutualfunds.productcompanyid'] = "$company"; }
		 if ($scheme!='' && $scheme!='all') { $conditions['conditions']['and']['Mutualfunds.mffund_id'] = "$scheme"; }
        
		   if ( ($company != '' && $company != 'all') || ($branch != '' &&  $branch != 'all') || ($scheme != '' && $scheme != 'all' ) || ($datedform && $datedto) ){ 
                $mf = $this->Mutualfunds->find('all', $conditions);
				  $cnt = $mf->count();              
                        if($mf){
                            $total_amount = 0;                   
                             foreach ($mf as $md){ 
                                $total_amount += $md->amount;
                             }
                        } 
            }
			elseif($company == 'all' || $branch == 'all' || $scheme == 'all' )
				  {
				 
				   $mf = $this->Mutualfunds;
				   $mf1=$this->Mutualfunds->find('all',array('contain' => ['Companies', 'Branches', 'Mffunds','Brokers']));
			$cnt = $mf1->count();              
                        if($mf1){
                           $total_amount = 0;                   
                             foreach ($mf1 as $md){ 
                                    $total_amount += $md->amount;
                             }
                        } 
				  }
			else{  
                   if($conditions != ''){
				
                    $mf = $this->Mutualfunds->find('all', $conditions);
					$cnt = $mf->count();              
                        if($mutualfunds){
                            $total_amount = 0;                   
                             foreach ($mf as $md){ 
                                $total_amount += $md->amount;
                             }
                        } 
                  } 
				  
				  else{
				 
                    $mf = $this->Mutualfunds;
			$mf1=$this->Mutualfunds->find('all',array('contain' => ['Companies', 'Branches', 'Mffunds','Brokers']));
			$cnt = $mf1->count();              
                        if($mf1){
                           $total_amount = 0;                   
                             foreach ($mf1 as $md){ 
                                    $total_amount += $md->amount;
                             }
                        } 
                  }  
            }    
            //'Banks',
            $this->paginate = [
               'contain' => ['Companies', 'Branches','Brokers','Mffunds']
            ]; 
           // $mfs = $mf;
            
            $mf = $this->paginate($mf ,['order' => ['Mutualfunds.id' => 'DESC']]);
            $this->set(compact('mf','company','branch','scheme','datedform','datedto','total_amount','cnt','dated2','dated1'));
            $this->set('_serialize', ['mf']);
       
      }else{ 
               
        $datedform = '';
        $datedto = ''; 
        $company = '';
		$branch = '';
		$scheme = '';
		$mf = '';
		$this->set(compact('mf','page','company','subbroker','scheme','branch','datedform','datedto','total_amount','cnt'));
		$this->set('_serialize', ['mf']);
			
      } 
    }
    
	//SIP Renewal Maturity Report
    public function mfsiprenewal(){
       $this->loadModel('Mutualfunds'); 
       $this->loadModel('Customers'); 
       $this->loadModel('Banks'); 
	   $all = array('all'=>'All'); 
   
       $this->Search->addFilter('company', [
        'attributes'=>['placeholder'=>'Company','label'=>'MutualFund :','class'=>'searchfrm', 'value' => isset($this->request->query['company'])?$this->request->query['company']:''],  
        'options' => $all+$this->Mutualfunds->Companies->find('list')-> where(['associatewith' => 'product'])->andWhere(['Companies.productid ='=>'1'] )->order(['company' => 'ASC'])->toArray(),
       ]);
	   
       $this->Search->addFilter('scheme', [
        'attributes'=>['placeholder'=>'Scheme Name','label'=>'Scheme Name :','class'=>'searchfrm','value' => isset($this->request->query['scheme'])?$this->request->query['scheme']:'',],  
        'options' => $all+$this->Mutualfunds->Mffunds->find('list')->order(['fundname' => 'ASC'])->group(['fundname'])->toArray(),
       ]);
       if($this->Auth->user('group_id')=='2'){ 
          $branch = $this->Mutualfunds->Branches->find('list')->toArray();
         
        $this->Search->addFilter('branch', [
        'attributes'=>['placeholder'=>'Branch Name','label'=>'Branch Name :','class'=>'searchfrm','value' => isset($this->request->query['branch'])?$this->request->query['branch']:'',],  
        'options' => $all+$this->Mutualfunds->Branches->find('list')->toArray(),
       ]);
       }  
       
      	$this->Search->addFilter('datedform', [
         'attributes'=>['placeholder'=>'Maturity From Date','label'=>'Maturity From Date :','class'=>'searchfrm','value' => isset($this->request->query['datedform'])?$this->request->query['datedform']:''],
        ]);
        $this->Search->addFilter('datedto', [
           'attributes'=>['placeholder'=>'Maturity To Date','label'=>'Maturity To Date :','class'=>'searchfrm','value' => isset($this->request->query['datedto'])?$this->request->query['datedto']:''],
        ]);
    
		$conditions = '';  
		if($this->Auth->user('group_id')=='3'){        
			$branch_id = $this->Auth->user('branch_id');     
			$conditions['conditions']['and']['Mutualfunds.posteduserbranchid'] = "$branch_id";
		}
       if (!empty($this->request->query) && count($this->request->query) > 1) { 
       
		 $branch = $this->request->query['branch'];
		 $company = $this->request->query['company']; 
		 $scheme = $this->request->query['scheme'];
      
         $dated2 =  (($this->request->query['datedform'] != '')? $this->request->query['datedform'] : '');
		 $date_from = explode('/',$dated2);
         $datedform  = implode('-', array_reverse($date_from));
         
	     $dated1= (($this->request->query['datedto']!='')? $this->request->query['datedto']:'');
	     $date_to = explode('/',$dated1);
         $datedto  = implode('-', array_reverse($date_to));         
            if ($datedform && $datedto){             
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                     array('Mutualfunds.maturitydate >= ' => $datedform,
                                       'Mutualfunds.maturitydate <= ' => $datedto
                                      )
                         )));
            }
         $conditions['conditions']['and']['Mutualfunds.typeofdeposit'] = 'SIP - Renewal';
		 if ($branch!='' && $branch!='all'){ $conditions['conditions']['and']['Mutualfunds.branch_id'] = "$branch"; }
         if ($company!='' && $company!='all'){ $conditions['conditions']['and']['Mutualfunds.productcompanyid'] = "$company"; }
		 if ($scheme!='' && $scheme!='all') { $conditions['conditions']['and']['Mutualfunds.mffund_id'] = "$scheme"; }
        
		   if ( ($company != '' && $company != 'all') || ($branch != '' &&  $branch != 'all') || ($scheme != '' && $scheme != 'all' ) || ($datedform && $datedto) ){ 
                $mf = $this->Mutualfunds->find('all', $conditions);
				  $cnt = $mf->count();              
                        if($mf){
                            $total_amount = 0;                   
                             foreach ($mf as $md){ 
                                $total_amount += $md->amount;
                             }
                        } 
            }
			elseif($company == 'all' || $branch == 'all' || $scheme == 'all' )
				  {
				 
				   $mf = $this->Mutualfunds;
				   $mf1=$this->Mutualfunds->find('all',array('contain' => ['Companies', 'Branches', 'Mffunds','Brokers']));
			$cnt = $mf1->count();              
                        if($mf1){
                           $total_amount = 0;                   
                             foreach ($mf1 as $md){ 
                                    $total_amount += $md->amount;
                             }
                        } 
				  }
			else{  
                   if($conditions != ''){
				
                    $mf = $this->Mutualfunds->find('all', $conditions);
					$cnt = $mf->count();              
                        if($mutualfunds){
                            $total_amount = 0;                   
                             foreach ($mf as $md){ 
                                $total_amount += $md->amount;
                             }
                        } 
                  } 
				  
				  else{
				 
                    $mf = $this->Mutualfunds;
			$mf1=$this->Mutualfunds->find('all',array('contain' => ['Companies', 'Branches', 'Mffunds','Brokers']));
			$cnt = $mf1->count();              
                        if($mf1){
                           $total_amount = 0;                   
                             foreach ($mf1 as $md){ 
                                    $total_amount += $md->amount;
                             }
                        } 
                  }  
            }    
            //'Banks',
            $this->paginate = [
               'contain' => ['Companies', 'Branches','Brokers','Mffunds']
            ]; 
           // $mfs = $mf;
            
            $mf = $this->paginate($mf ,['order' => ['Mutualfunds.id' => 'DESC']]);
            $this->set(compact('mf','company','branch','scheme','datedform','datedto','total_amount','cnt','dated2','dated1'));
            $this->set('_serialize', ['mf']);
       
      }else{ 
               
        $datedform = '';
        $datedto = ''; 
        $company = '';
		$branch = '';
		$scheme = '';
		$mf = '';
		$this->set(compact('mf','page','company','subbroker','scheme','branch','datedform','datedto','total_amount','cnt'));
		$this->set('_serialize', ['mf']);
			
      } 
    }
	
    //STP Maturity Report
    public function mfstp(){
       $this->loadModel('Mutualfunds'); 
       $this->loadModel('Customers'); 
       $this->loadModel('Banks'); 
	   $all = array('all'=>'All'); 
   
       $this->Search->addFilter('company', [
        'attributes'=>['placeholder'=>'Company','label'=>'MutualFund :','class'=>'searchfrm', 'value' => isset($this->request->query['company'])?$this->request->query['company']:''],  
        'options' => $all+$this->Mutualfunds->Companies->find('list')-> where(['associatewith' => 'product'])->andWhere(['Companies.productid ='=>'1'] )->order(['company' => 'ASC'])->toArray(),
       ]);
	   
       $this->Search->addFilter('scheme', [
        'attributes'=>['placeholder'=>'Scheme Name','label'=>'Scheme Name :','class'=>'searchfrm','value' => isset($this->request->query['scheme'])?$this->request->query['scheme']:'',],  
        'options' => $all+$this->Mutualfunds->Mffunds->find('list')->order(['fundname' => 'ASC'])->group(['fundname'])->toArray(),
       ]);
       if($this->Auth->user('group_id')=='2'){ 
          $branch = $this->Mutualfunds->Branches->find('list')->toArray();
         
        $this->Search->addFilter('branch', [
        'attributes'=>['placeholder'=>'Branch Name','label'=>'Branch Name :','class'=>'searchfrm','value' => isset($this->request->query['branch'])?$this->request->query['branch']:'',],  
        'options' => $all+$this->Mutualfunds->Branches->find('list')->toArray(),
       ]);
       }  
       
      	$this->Search->addFilter('datedform', [
         'attributes'=>['placeholder'=>'Maturity From Date','label'=>'Maturity From Date :','class'=>'searchfrm','value' => isset($this->request->query['datedform'])?$this->request->query['datedform']:''],
        ]);
        $this->Search->addFilter('datedto', [
           'attributes'=>['placeholder'=>'Maturity To Date','label'=>'Maturity To Date :','class'=>'searchfrm','value' => isset($this->request->query['datedto'])?$this->request->query['datedto']:''],
        ]);
    
		$conditions = '';  
		if($this->Auth->user('group_id')=='3'){        
			$branch_id = $this->Auth->user('branch_id');     
			$conditions['conditions']['and']['Mutualfunds.posteduserbranchid'] = "$branch_id";
		}
       if (!empty($this->request->query) && count($this->request->query) > 1) { 
       
		 $branch = $this->request->query['branch'];
		 $company = $this->request->query['company']; 
		 $scheme = $this->request->query['scheme'];
      
         $dated2 =  (($this->request->query['datedform'] != '')? $this->request->query['datedform'] : '');
		 $date_from = explode('/',$dated2);
         $datedform  = implode('-', array_reverse($date_from));
         
	     $dated1= (($this->request->query['datedto']!='')? $this->request->query['datedto']:'');
	     $date_to = explode('/',$dated1);
         $datedto  = implode('-', array_reverse($date_to));         
            if ($datedform && $datedto){             
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
							 array('Mutualfunds.maturitydate >= ' => $datedform,
							   'Mutualfunds.maturitydate <= ' => $datedto
							  )
                     )));
            }
         $conditions['conditions']['and']['Mutualfunds.typeofdeposit'] = 'STP';
		 if ($branch!='' && $branch!='all'){ $conditions['conditions']['and']['Mutualfunds.branch_id'] = "$branch"; }
         if ($company!='' && $company!='all'){ $conditions['conditions']['and']['Mutualfunds.productcompanyid'] = "$company"; }
		 if ($scheme!='' && $scheme!='all') { $conditions['conditions']['and']['Mutualfunds.mffund_id'] = "$scheme"; }
        
		   if ( ($company != '' && $company != 'all') || ($branch != '' &&  $branch != 'all') || ($scheme != '' && $scheme != 'all' ) || ($datedform && $datedto) ){ 
                $mf = $this->Mutualfunds->find('all', $conditions);
				  $cnt = $mf->count();              
                        if($mf){
                            $total_amount = 0;                   
                             foreach ($mf as $md){ 
                                $total_amount += $md->amount;
                             }
                        } 
            }
			elseif($company == 'all' || $branch == 'all' || $scheme == 'all' )
				  {
				 
				   $mf = $this->Mutualfunds;
				   $mf1=$this->Mutualfunds->find('all',array('contain' => ['Companies', 'Branches', 'Mffunds','Brokers']));
			$cnt = $mf1->count();              
                        if($mf1){
                           $total_amount = 0;                   
                             foreach ($mf1 as $md){ 
                                    $total_amount += $md->amount;
                             }
                        } 
				  }
			else{  
                   if($conditions != ''){
				
                    $mf = $this->Mutualfunds->find('all', $conditions);
					$cnt = $mf->count();              
                        if($mutualfunds){
                            $total_amount = 0;                   
                             foreach ($mf as $md){ 
                                $total_amount += $md->amount;
                             }
                        } 
                  } 
				  
				  else{
				 
                    $mf = $this->Mutualfunds;
			$mf1=$this->Mutualfunds->find('all',array('contain' => ['Companies', 'Branches', 'Mffunds','Brokers']));
			$cnt = $mf1->count();              
                        if($mf1){
                           $total_amount = 0;                   
                             foreach ($mf1 as $md){ 
                                    $total_amount += $md->amount;
                             }
                        } 
                  }  
            }    
            //'Banks',
            $this->paginate = [
               'contain' => ['Companies', 'Branches','Brokers','Mffunds']
            ]; 
           // $mfs = $mf;
            
            $mf = $this->paginate($mf ,['order' => ['Mutualfunds.id' => 'DESC']]);
            $this->set(compact('mf','company','branch','scheme','datedform','datedto','total_amount','cnt','dated2','dated1'));
            $this->set('_serialize', ['mf']);
       
      }else{ 
               
        $datedform = '';
        $datedto = ''; 
        $company = '';
		$branch = '';
		$scheme = '';
		$mf = '';
		$this->set(compact('mf','page','company','subbroker','scheme','branch','datedform','datedto','total_amount','cnt'));
		$this->set('_serialize', ['mf']);
			
      } 
    }	
        
    public function mfcprofile(){
      $this->loadModel('Mutualfunds'); 
      $this->loadModel('Customers'); 
      $this->loadModel('Banks'); 
	  
        $all = array('all'=>'All');
	    $this->Search->addFilter('fapplicantname', [
          'attributes'=>['placeholder'=>'Applicant Name','label'=>'Applicant Name :','class'=>'searchfrm','value' => isset($this->request->query['fapplicantname'])?$this->request->query['fapplicantname']:''], 'options' =>$all+$this->Mutualfunds->Customers->find('list',['keyField' => 'name','valueField' => 'name'])->order(['Customers.name'=>'ASC'])->group(['Customers.name'])->toArray(),
       ]);
    
      $this->Search->addFilter('company', [
        'attributes'=>['placeholder'=>'Company Name','label'=>'Company Name :','class'=>'searchfrm','value' => isset($this->request->query['company'])?$this->request->query['company']:''],  
        'options' => $all+$this->Mutualfunds->Companies->find('list')-> where(['associatewith' => 'product'])->andWhere(['Companies.productid ='=>'1'] )->order(['company' => 'ASC'])->toArray(),
      ]);
	   $this->Search->addFilter('scheme', [
        'attributes'=>['placeholder'=>'Scheme Name','label'=>'Scheme Name :','class'=>'searchfrm','value' => isset($this->request->query['scheme'])?$this->request->query['scheme']:''],  
        'options' => $all+$this->Mutualfunds->Mffunds->find('list')->toArray(),
      ]);
	   $this->Search->addFilter('datedform', [
         'attributes'=>['placeholder'=>'Despatch Start Date','label'=>'Despatch Start Date :','class'=>'searchfrm','value' => isset($this->request->query['datedform'])?$this->request->query['datedform']:''],
      ]);
      $this->Search->addFilter('datedto', [
         'attributes'=>['placeholder'=>'Despatch End Date','label'=>'Despatch End Date :','class'=>'searchfrm','value' => isset($this->request->query['datedto'])?$this->request->query['datedto']:''],
      ]); 
     
      $conditions = '';
      if($this->Auth->user('group_id')=='3'){           
            $branch_id = $this->Auth->user('branch_id');     
            $conditions['conditions']['and']['Mutualfunds.posteduserbranchid'] = "$branch_id";
        } 
      if (!empty($this->request->query) && count($this->request->query) > 1) { 
       
         $fapplicantname = $this->request->query['fapplicantname']; 
       
         $company = $this->request->query['company']; 
         $scheme = $this->request->query['scheme']; 
         $dated2 =  (($this->request->query['datedform'] != '')? $this->request->query['datedform'] : '');
		 $date_from = explode('/',$dated2);
         $datedform  = implode('-', array_reverse($date_from));
         
	   $dated1= (($this->request->query['datedto']!='')? $this->request->query['datedto']:'');
	   $date_to = explode('/',$dated1);
        $datedto  = implode('-', array_reverse($date_to));
        
        if ($datedform && $datedto){             
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                     array('Mutualfunds.despatchdate >= ' => $datedform,
                                            'Mutualfunds.despatchdate <= ' => $datedto
                                      )
                         )));
            }
            if ($fapplicantname!='' && $fapplicantname!='all'){ $conditions['conditions']['and']['Mutualfunds.firstapplicantname LIKE'] = "$fapplicantname"; }
        /*  if ($panno){ $conditions['conditions']['and']['Mutualfunds.panno'] = "$panno"; }
         if ($banks){ $conditions['conditions']['and']['Mutualfunds.bank_id'] = "$banks"; } */
         if ($company!='' && $company!='all'){ $conditions['conditions']['and']['Mutualfunds.productcompanyid'] = "$company"; }
        // if ($subbroker){ $conditions['conditions']['and']['Mutualfunds.broker_id'] = "$subbroker"; }
         if ($scheme!='' && $scheme!='all'){ $conditions['conditions']['and']['Mutualfunds.mffund_id'] = "$scheme"; }
             if ( ($scheme != '' && $scheme != 'all') || ($fapplicantname != '' && $fapplicantname != 'all') || ($company != '' && $company != 'all' )|| ($datedform && $datedto)){ 
                $mf = $this->Mutualfunds->find('all', $conditions);
				 $cnt = $mf->count();              
                        if($mf){
                            $total_amount = 0;                   
                             foreach ($mf as $md){ 
                                $total_amount += $md->amount;
                             }
                        } 
				
            }elseif($scheme == 'all' || $fapplicantname == 'all' || $company == 'all' )
				  {
				   $mf = $this->Mutualfunds;
				    $mf1=$this->Mutualfunds->find('all',array('contain' => ['Companies', 'Branches', 'Mffunds','Brokers']));
			         $cnt = $mf1->count();              
                        if($mf1){
                           $total_amount = 0;                   
                             foreach ($mf1 as $md){ 
                                    $total_amount += $md->amount;
                             }
                        } 
				  }else{
               if($conditions != '') {
               $mf = $this->Mutualfunds->find('all', $conditions);
			    $cnt = $mf->count();              
                        if($mf){
                            $total_amount = 0;                   
                             foreach ($mf as $md){ 
                                $total_amount += $md->amount;
                             }
                        } 
			   }
			   else
			   {
				    $mf = $this->Mutualfunds;
					 $mf1=$this->Mutualfunds->find('all',array('contain' => ['Companies', 'Branches', 'Mffunds','Brokers']));
			         $cnt = $mf1->count();              
                        if($mf1){
                           $total_amount = 0;                   
                             foreach ($mf1 as $md){ 
                                    $total_amount += $md->amount;
                             }
                        } 
			   }
            }   
            //'Banks',
            $this->paginate = [
               'contain' => ['Companies', 'Branches','Brokers','Mffunds']
            ]; 
            $mf = $this->paginate($mf ,['order' => ['Mutualfunds.id' => 'DESC']]);
            $this->set(compact('mf','panno','scheme','branch','applicationno','fapplicantname','banks','company','subbroker','typeofdeposit','datedform','datedto','dated2','dated1','cnt','total_amount'));
            $this->set('_serialize', ['mf']);
       
      }else{ 
       //  $applicationno = '';
         $fapplicantname = '';          
        /*  $banks = '';
         $typeofdeposit = '';   */        
         $datedform = '';
         $datedto = ''; 
        // $panno = '';
         $company = '';
        // $subbroker = '';
         $scheme = '';
        // $branch = '';
      /*
         if($conditions != ''){
              $mf = $this->Mutualfunds->find('all', $conditions);
			   $cnt = $mf->count();              
                        if($mf){
                            $total_amount = 0;                   
                             foreach ($mf as $md){ 
                                $total_amount += $md->amount;
                             }
                        } 
         }else{
              $mf = $this->Mutualfunds;
			   $mf1=$this->Mutualfunds->find('all',array('contain' => ['Companies', 'Branches', 'Mffunds','Brokers']));
			$cnt = $mf1->count();              
                        if($mf1){
                           $total_amount = 0;                   
                             foreach ($mf1 as $md){ 
                                    $total_amount += $md->amount;
                             }
                        } 
         }   
            $this->paginate = [
                'contain' => ['Companies', 'Branches','Brokers','Mffunds']
            ];
        $mf = $this->paginate($mf,['order' => ['Mutualfunds.mffund_id' => 'DESC']]);
       */
          $mf = '';
           
            $this->set(compact('mf','scheme','branch','fapplicantname','company','datedform','datedto','cnt','total_amount'));
            $this->set('_serialize', ['mf']);
      } 
    }
        
    function mfcprofilereports() {
       $conditions = '';  
         $this->autoRender = false;
         // $this->layout = false;        
         $fileName = "mfreports_".date("d-m-y:h:s").".xls";        
         $this->loadModel('Mutualfunds'); 
         $this->loadModel('Customers'); 
         $this->loadModel('Banks'); 
        if($this->Auth->user('group_id')=='3'){            
            $branch_id = $this->Auth->user('branch_id');     
            $conditions['conditions']['and']['Mutualfunds.posteduserbranchid'] = "$branch_id";
        }  
        $applicationno = $this->request->query['applicationno'];
        $fapplicantname = $this->request->query['fapplicantname'];
        $panno = $this->request->query['panno'];
        $banks = $this->request->query['banks'];
        $company = $this->request->query['company']; 
        $subbroker = $this->request->query['subbroker']; 
        $typeofdeposit = $this->request->query['typeofdeposit']; 
        $datedform = $this->request->query['datedform'];
        $datedto = $this->request->query['datedto']; 
        $scheme = $this->request->query['scheme']; 
        $branch = $this->request->query['branch']; 
         
       if ($applicationno){ $conditions['conditions']['and']['Mutualfunds.applicationno LIKE'] = "%$applicationno%"; }
       if ($fapplicantname){ $conditions['conditions']['and']['Mutualfunds.firstapplicantname LIKE'] = "%$fapplicantname%"; }
       if ($panno){ $conditions['conditions']['and']['Mutualfunds.panno'] = "$panno"; }
       if ($banks){ $conditions['conditions']['and']['Mutualfunds.bank_id'] = "$banks"; }
       if ($company){ $conditions['conditions']['and']['Mutualfunds.productcompanyid'] = "$company"; }
       if ($subbroker){ $conditions['conditions']['and']['Mutualfunds.broker_id'] = "$subbroker"; }
       if ($scheme){ $conditions['conditions']['and']['Mutualfunds.mffund_id'] = "$scheme"; }
       if ($branch){ $conditions['conditions']['and']['Mutualfunds.branch_id'] = "$branch"; }
       if ($typeofdeposit){ $conditions['conditions']['and']['Mutualfunds.typeofdeposit LIKE'] = "%$typeofdeposit%"; }   
       /*if ($datedform && $datedto){
             $conditions = array(
                 'conditions' => array(
                 'and' => array(
                                 array('trim(Mutualfunds.maturitydate) >= ' => $datedform,
                                       'trim(Mutualfunds.maturitydate) <= ' => $datedto
                                      )
                     )));
        }*/
        if ($datedform && $datedto){             
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                     array('Mutualfunds.maturitydate >= ' => $datedform,
                                       'Mutualfunds.maturitydate <= ' => $datedto
                                      )
                         )));
            }

           if ($applicationno !='' || $scheme != '' || $branch != '' || $fapplicantname != '' || $panno != '' || $company != '' || $subbroker != '' || $banks !='' || $typeofdeposit != '' || ($datedform && $datedto)){ 
              $mf = $this->Mutualfunds->find('all', $conditions);
           }else{
              if($conditions != ''){ 
                $mf = $this->Mutualfunds->find('all', $conditions);
              }else{
                  $mf = $this->Mutualfunds;
              }   
           }    

           $this->paginate = [
              'contain' => ['Companies', 'Branches','Brokers','Mffunds']
           ]; 
        $mf = $this->paginate($mf ,['order' => ['Mutualfunds.id' => 'DESC']]);
        $datafds = $mf->toArray(); 
       //pr($datafds);die;
        $headerRow = array("Sr.",'Company','Scheme',"Location","Investor",'Type','Folio No','Cheque No','Amount','Period(In month)','App No');
        $j=1;
         for($i=0; $i< count($datafds); $i++){             
            $data[] = [$j,$datafds[$i]->company->company,$datafds[$i]->mffund->fundname,$datafds[$i]->branch->branchaddress,$datafds[$i]->firstapplicantname,$datafds[$i]->typeofdeposit,$datafds[$i]->customerFolioNo,$datafds[$i]->chequeno,$datafds[$i]->amount,$datafds[$i]->tenure,$datafds[$i]->applicationno];
         $j++;
            }          
          $this->ExportXls->export($fileName, $headerRow, $data);
        }
        
    /* end Mf report */  
        
    public function dailyreport()
    {
      $this->loadModel('Fds'); 
      $this->loadModel('Mutualfunds');
      $this->loadModel('Ncds'); 
      $this->loadModel('Ipos'); 
      $this->loadModel('Customers'); 
      $this->loadModel('Banks'); 
      $this->loadModel('Plans'); 
      $this->loadModel('Products');
      
      $all = array('all'=>'All');    
       $this->Search->addFilter('Product', [
            'attributes'=>['placeholder'=>'Product Name','label'=>'Product Name :','class'=>'searchfrm',],  
            'options' => $all+$this->Products->find('list')->toArray(),           
        ]); 
       
      if($this->Auth->user('group_id')=='2'){ 
          $branch = $this->Fds->Branches->find('list')->toArray();
         
        $this->Search->addFilter('branch', [
            'attributes'=>['placeholder'=>'Branch Name','label'=>'Branch Name :','class'=>'searchfrm',],  
            'options' => $all+$this->Fds->Branches->find('list')->toArray(),
        ]);
      }  
       
        $this->Search->addFilter('datedform', [
         'attributes'=>['placeholder'=>'Start Date','label'=>'Start Date :','class'=>'searchfrm',],
        ]);
        $this->Search->addFilter('datedto', [
           'attributes'=>['placeholder'=>'End Date','label'=>'End Date :','class'=>'searchfrm',],
        ]);
       
       $conditions = '';
       if($this->Auth->user('group_id')=='3'){
            //$conditions = '';  
            $branch_id = $this->Auth->user('branch_id');     
            $conditions['conditions']['and']['Fds.posteduserbranchid'] = "$branch_id";
        } 
     
       if (!empty($this->request->query) && count($this->request->query) > 1) { 
          // $conditions = '';
           if($this->Auth->user('group_id')=='2'){
              $branch = (($this->request->query['branch'] != '')? $this->request->query['branch'] : '');       
           }          
           $datedform = (($this->request->query['datedform'] != '')? $this->request->query['datedform'] : ''); 
           $datedto = (($this->request->query['datedto'] != '')? $this->request->query['datedto'] : ''); 
                   
         if ($datedform && $datedto){
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                     array('trim(Fds.despatchdate) >= ' => $datedform,
                                       'trim(Fds.despatchdate) <= ' => $datedto
                                      )
                         )));
            }
            if (($branch !='') && ($branch !='all')){ $conditions['conditions']['and']['Fds.branch_id'] = "$branch"; }
            
            if ($branch != ''  || ($datedform && $datedto)){                 
                 $fds = $this->Fds->find('all', $conditions);
            }else{
                 $fds = $this->Fds->find('all', $conditions);
            } 
            //, 'Banks'
            $this->paginate = [
                'contain' => ['Companies', 'Branches','Brokers', 'Plans']
            ]; 
            $fds = $this->paginate($fds ,['order' => ['Fds.branch_id' => 'ASC']]);
            $this->set(compact('fds','branch','datedform','datedto'));
            $this->set('_serialize', ['fds']);
        }else{
           $branch =''; $datedform =''; $datedto= '';
           if($conditions !=''){
               $fds = $this->Fds->find('all', $conditions);
           }else{
               $fds = $this->Fds;
           }
           
           //, 'Banks'
           $this->paginate = [
                'contain' => ['Companies', 'Branches','Brokers', 'Plans']
            ]; 
            $fds = $this->paginate($fds ,['order' => ['Fds.branch_id' => 'ASC']]);
            $this->set(compact('fds','branch','datedform','datedto'));
            $this->set('_serialize', ['fds']);
        }   
          
        //mf
         $conditions = ''; 
        if($this->Auth->user('group_id')=='3'){            
            $branch_id = $this->Auth->user('branch_id');     
            $conditions['conditions']['and']['Mutualfunds.posteduserbranchid'] = "$branch_id";
        } 
        
        if (!empty($this->request->query) && count($this->request->query) > 1) { 
           // $conditions = '';
             if($this->Auth->user('group_id')=='2'){
               $branch = (($this->request->query['branch'] != '')? $this->request->query['branch'] : '');               
             }  
          
          
            if ($datedform && $datedto){             
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                     array('trim(Mutualfunds.despatchdate) >= ' => $datedform,
                                       'trim(Mutualfunds.despatchdate) <= ' => $datedto
                                      )
                         )));
            }
          if (($branch !='') && ($branch !='all')){ $conditions['conditions']['and']['Mutualfunds.branch_id'] = "$branch"; }
       
            if ($branch != ''  || ($datedform && $datedto)){ 
                 $mutualfunds = $this->Mutualfunds->find('all', $conditions);
            }else{
                if($conditions !=''){
                    $mutualfunds = $this->Mutualfunds->find('all', $conditions);
                  }else{
                     $mutualfunds = $this->Mutualfunds; 
                  } 
            }    
            //, 'Banks',
            
            $this->paginate = [
                 'contain' => ['Companies', 'Branches', 'Mffunds','Brokers']
            ]; 
            
            $mutualfunds = $this->paginate($mutualfunds ,['order' => ['Mutualfunds.branch_id' => 'ASC']]);     
            $this->set(compact('mutualfunds','branch','datedform','datedto'));
            $this->set('_serialize', ['mutualfunds']);
        }else{
           $branch =''; $datedform =''; $datedto= '';
           if($conditions !=''){
             $mutualfunds = $this->Mutualfunds->find('all', $conditions);
           }else{
              $mutualfunds = $this->Mutualfunds; 
           }  
           $this->paginate = [
                 'contain' => ['Companies', 'Branches','Brokers', 'Mffunds']
            ]; 
            $mutualfunds = $this->paginate($mutualfunds ,['order' => ['Mutualfunds.branch_id' => 'ASC']]);
            $this->set(compact('mutualfunds','branch','datedform','datedto'));
            $this->set('_serialize', ['mutualfunds']);
        }   
       
        // ncd
        $conditions = ''; 
        if($this->Auth->user('group_id')=='3'){             
            $branch_id = $this->Auth->user('branch_id');     
            $conditions['conditions']['and']['Ncds.posteduserbranchid'] = "$branch_id";
        } 
        if (!empty($this->request->query) && count($this->request->query) > 1) { 
            //$conditions = '';           
         
            if ($datedform && $datedto){
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                     array('trim(Ncds.despatchdate) >= ' => $datedform,
                                       'trim(Ncds.despatchdate) <= ' => $datedto
                                      )
                         )));
            }
           if (($branch !='') && ($branch !='all')){  $conditions['conditions']['and']['Ncds.branch_id'] = "$branch"; }
            
            if ($branch != ''  || ($datedform && $datedto)){ 
                 $ncds = $this->Ncds->find('all', $conditions);
            }else{
                 $ncds = $this->Ncds->find('all', $conditions);
            }    
            $this->paginate = [
                 'contain' => ['Companies','Branches', 'Banks','Brokers','Plans']
            ]; 
            $ncds = $this->paginate($ncds ,['order' => ['Ncds.branch_id' => 'ASC']]);
            $this->set(compact('ncds','branch','datedform','datedto'));
            $this->set('_serialize', ['ncds']);
        }else{
           $branch =''; $datedform =''; $datedto= ''; 
            if($conditions !=''){
              $ncds = $this->Ncds->find('all', $conditions);
            }else{
                $ncds = $this->Ncds;
            }  
           $this->paginate = [
                 'contain' => ['Companies','Branches', 'Banks','Brokers','Plans']
            ]; 
            $ncds = $this->paginate($ncds ,['order' => ['Ncds.branch_id' => 'ASC']]);
            $this->set(compact('ncds','branch','datedform','datedto'));
            $this->set('_serialize', ['ncds']);
        }   
        
        // ipo
        $conditions = ''; 
        if($this->Auth->user('group_id')=='3'){            
            $branch_id = $this->Auth->user('branch_id');     
            $conditions['conditions']['and']['Ipos.posteduserbranchid'] = "$branch_id";
        } 
        if (!empty($this->request->query) && count($this->request->query) > 1) { 
            //$conditions = '';           
         
            if ($datedform && $datedto){
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                     array('trim(Ipos.despatchdate) >= ' => $datedform,
                                       'trim(Ipos.despatchdate) <= ' => $datedto
                                      )
                         )));
            }
           if (($branch !='') && ($branch !='all')){  $conditions['conditions']['and']['Ipos.branch_id'] = "$branch"; }
            
            if ($branch != ''  || ($datedform && $datedto)){ 
                 $ipos = $this->Ipos->find('all', $conditions);
            }else{
                 $ipos = $this->Ipos->find('all', $conditions);
            }    
            $this->paginate = [
                  'contain' => ['Companies', 'Branches','Banks','Brokers','Plans']
            ]; 
            $ipos = $this->paginate($ipos ,['order' => ['Ipos.branch_id' => 'ASC']]);
            $this->set(compact('ipos','branch','datedform','datedto'));
            $this->set('_serialize', ['ipos']);
        }else{
           $branch =''; $datedform =''; $datedto= ''; 
            if($conditions !=''){
              $ipos = $this->Ipos->find('all', $conditions);
            }else{
                $ipos = $this->Ipos;
            }  
           $this->paginate = [
                  'contain' => ['Companies', 'Branches','Banks','Brokers','Plans']
            ]; 
            $ipos = $this->paginate($ipos ,['order' => ['Ipos.branch_id' => 'ASC']]);
            $this->set(compact('ipos','branch','datedform','datedto'));
            $this->set('_serialize', ['ipos']);
        }
       
      
    }
    
    public function dailymf(){
      
      $this->loadModel('Mutualfunds');    
      $this->loadModel('Customers'); 
      $this->loadModel('Banks'); 
      $this->loadModel('Plans'); 
      $this->loadModel('Products');
       $all = array('all'=>'All');    
       $typeofdeposit = array(
            'Additional' => 'Additional',
            'Fresh' => 'Fresh',
            'SIP' => 'SIP',            
            'Switch' => 'Switch',
            'SIP - Renewal' => 'SIP - Renewal',
            'STP' => 'STP'
        );
      $this->Search->addFilter('typeofdeposit', [
        'attributes'=>['placeholder'=>'Type of Deposit','label'=>'Type of Deposit :     In order to select multiple type click with ctrl key ','multiple' => 'multiple','class'=>'searchfrm','value' => isset($this->request->query['typeofdeposit'])?$this->request->query['typeofdeposit']:''],  
        'options' => $typeofdeposit,
        
      ]);
      
      if($this->Auth->user('group_id')=='2'){ 
          $branch = $this->Mutualfunds->Branches->find('list')->toArray();
         
        $this->Search->addFilter('branch', [
            'attributes'=>['placeholder'=>'Branch Name','label'=>'Branch Name :','class'=>'searchfrm','value' => isset($this->request->query['branch'])?$this->request->query['branch']:''],  
            'options' => $all+$this->Mutualfunds->Branches->find('list')->toArray(),
        ]);
      }  
       /*
        $this->Search->addFilter('datedform', [
         'attributes'=>['placeholder'=>'Despatch Start Date','label'=>'Despatch Start Date :','class'=>'searchfrm','value' => isset($this->request->query['datedform'])?$this->request->query['datedform']:''],
        ]);
        $this->Search->addFilter('datedto', [
           'attributes'=>['placeholder'=>'Despatch End Date','label'=>'Despatch End Date :','class'=>'searchfrm','value' => isset($this->request->query['datedto'])?$this->request->query['datedto']:''],
        ]);
        */
         $conditions = ''; 
        if($this->Auth->user('group_id')=='3'){            
            $branch_id = $this->Auth->user('branch_id');     
            $conditions['conditions']['and']['Mutualfunds.posteduserbranchid'] = "$branch_id";
        } 
        $this->request->query['datedform'] = $this->request->query['datedto'] = date('d/m/Y');
        if (!empty($this->request->query) && count($this->request->query) > 1) { 
           // $conditions = '';
             if($this->Auth->user('group_id')=='2'){
                if(!empty($this->request->query['branch'])){
					$branch = (($this->request->query['branch'] != '')? $this->request->query['branch'] : '');
				}else{
					$branch = '';   
				}               
             }  
             $dated2 =  (($this->request->query['datedform'] != '')? $this->request->query['datedform'] : '');

		 $date1 = explode('/',$dated2);
          $datedform = implode('-',$date1);
		  
       $datedform  = implode('-', array_reverse($date1));
		//pr($datedform);
		$dated1= $this->request->query['datedto'];
		$date = explode('/',$dated1);

        $datedto  = implode('-', array_reverse($date));
        if(!empty($this->request->query['typeofdeposit'])){
              $typeofdeposit_sel = (($this->request->query['typeofdeposit'] != '')? $this->request->query['typeofdeposit'] : ''); 
		}else{
			$typeofdeposit_sel = '';   
		}
   
         $cnt = $total_amount = 0;

            if ($datedform && $datedto){             
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                     array('Mutualfunds.despatchdate >= ' => $datedform,
                                       'Mutualfunds.despatchdate <= ' => $datedto
                                      )
                         )));
            }
           
          if (($branch !='') && ($branch !='all')){ $conditions['conditions']['and']['Mutualfunds.branch_id'] = "$branch"; }
            if (!empty($typeofdeposit_sel)){ 
               $conditions['conditions']['and']['Mutualfunds.typeofdeposit IN '] = $typeofdeposit_sel; 			 
            }  
           
            if ($branch != ''  || ($datedform && $datedto)) {
			//pr($conditions);
                 $mutualfunds = $this->Mutualfunds->find('all', $conditions);
                 
			//$mf1=$this->Mutualfunds->find('all',array('contain' => ['Companies', 'Branches', 'Mffunds','Brokers']), $conditions);
				$cnt = $mutualfunds->count();              
				if($mutualfunds){
					$total_amount = 0;                   
					 foreach ($mutualfunds as $md){ 
						$total_amount += $md->amount;
					 }
				} 
				
            }else{
                if($conditions !=''){
                    $mutualfunds = $this->Mutualfunds->find('all', $conditions);
                        
                      $cnt = $mutualfunds->count();              
                        if($mutualfunds){
                            $total_amount = 0;                   
                             foreach ($mutualfunds as $md){ 
                                $total_amount += $md->amount;
                             }
                        } 
					
                  }else{
                     $mutualfunds = $this->Mutualfunds; 
                     $mf1=$this->Mutualfunds->find('all',array('contain' => ['Companies', 'Branches', 'Mffunds','Brokers']));
					$cnt = $mf1->count();              
                        if($mf1){
                           $total_amount = 0;                   
                             foreach ($mf1 as $md){ 
                                    $total_amount += $md->amount;
                             }
                        } 
                  } 
            } 
          
            //, 'Banks',
            
            $this->paginate = [
                 'contain' => ['Companies', 'Branches', 'Mffunds','Brokers']
            ]; 
             
            $mutualfunds = $this->paginate($mutualfunds ,['order' => ['Mutualfunds.despatchdate' => 'ASC','Mutualfunds.typeofdeposit']]);  
 	    $this->set(compact('mutualfunds','branch','datedform','datedto','total_amount','cnt','dated2','dated1'));
            $this->set('_serialize', ['mutualfunds']);
        }else{
           $branch =''; $datedform =''; $datedto= '';
        /*   
           if($conditions !=''){
             $mutualfunds = $this->Mutualfunds->find('all', $conditions);			 
           }else{
              $mutualfunds = $this->Mutualfunds; 
            
                $mf1=$this->Mutualfunds->find('all',array('contain' => ['Companies', 'Branches', 'Mffunds','Brokers']));
                $cnt = $mf1->count();              
                if($mf1){
                   $total_amount = 0;                   
                     foreach ($mf1 as $md){ 
                            $total_amount += $md->amount;
                     }
                } 
			  
           } 
		   
       
	    $this->paginate = [
                 'contain' => ['Companies', 'Branches','Brokers', 'Mffunds']
            ]; 
            $mutualfunds = $this->paginate($mutualfunds);
	   // $mutualfunds = $this->paginate($mutualfunds ,['order' => ['Mutualfunds.branch_id' => 'ASC']]);
          */ 
           $mutualfunds = '';
            $this->set(compact('mutualfunds','branch','datedform','datedto','total_amount','cnt'));         
            $this->set('_serialize', ['mutualfunds']);
        }   
       
    }
    public function dailyfd(){
      $this->loadModel('Fds');     
      $this->loadModel('Customers'); 
      $this->loadModel('Banks'); 
      $this->loadModel('Plans'); 
      $this->loadModel('Products');
      
      $all = array('all'=>'All');    
   
      if($this->Auth->user('group_id')=='2'){ 
          $branch = $this->Fds->Branches->find('list')->toArray();
         
        $this->Search->addFilter('branch', [
            'attributes'=>['placeholder'=>'Branch Name','label'=>'Branch Name :','class'=>'searchfrm','value' => isset($this->request->query['branch'])?$this->request->query['branch']:''],  
            'options' => $all+$this->Fds->Branches->find('list')->toArray(),
        ]);
      }  
       /*
        $this->Search->addFilter('datedform', [
         'attributes'=>['placeholder'=>'Despatch Start Date','label'=>'Despatch Start Date :','class'=>'searchfrm','value' => isset($this->request->query['datedform'])?$this->request->query['datedform']:''],
        ]);
        $this->Search->addFilter('datedto', [
           'attributes'=>['placeholder'=>'Despatch End Date','label'=>'Despatch End Date :','class'=>'searchfrm','value' => isset($this->request->query['datedto'])?$this->request->query['datedto']:''],
        ]);
       */
       $this->request->query['datedform'] = $this->request->query['datedto'] = date('d/m/Y');
       $conditions = '';
       if($this->Auth->user('group_id')=='3'){
            //$conditions = '';  
            $branch_id = $this->Auth->user('branch_id');     
            $conditions['conditions']['and']['Fds.posteduserbranchid'] = "$branch_id";
        } 
     
       if (!empty($this->request->query) && count($this->request->query) > 1) { 
          // $conditions = '';
           if($this->Auth->user('group_id')=='2'){
              if(!empty($this->request->query['branch'])){
                $branch = (($this->request->query['branch'] != '')? $this->request->query['branch'] : '');
			  }else{
				$branch = '';   
			  }	       
           }          
          // $datedform = (($this->request->query['datedform'] != '')? $this->request->query['datedform'] : ''); 
          // $datedto = (($this->request->query['datedto'] != '')? $this->request->query['datedto'] : ''); 
        $dated2 =  (($this->request->query['datedform'] != '')? $this->request->query['datedform'] : '');
		// $dated2=$this->request->query['datedform'] ;
		 pr($dated2);
		 $date1 = explode('/',$dated2);
         // $datedform = implode('-',$date1);
		  
       $datedform  = implode('-', array_reverse($date1));
		//pr($datedform);
		$dated1= $this->request->query['datedto'];
		$date = explode('/',$dated1);

        $datedto  = implode('-', array_reverse($date));
        /* if ($datedform && $datedto){
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                     array('trim(Fds.despatchdate) >= ' => $datedform,
                                       'trim(Fds.despatchdate) <= ' => $datedto
                                      )
                         )));
            }*/
            if ($datedform && $datedto){
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                     array('Fds.despatchdate >= ' => $datedform,
                                       'Fds.despatchdate <= ' => $datedto
                                      )
                         )));
            }
            if (($branch !='') && ($branch !='all')){ $conditions['conditions']['and']['Fds.branch_id'] = "$branch"; }
            
            if ($branch != ''  || ($datedform && $datedto)){                 
                 $fds = $this->Fds->find('all', $conditions);
                 $cnt = $fds->count();
				if($fds) {
					$total_amount = 0;
					foreach ($fds as $fd) {
						$total_amount += $fd->amount;
					}
				}
                 
            }else{
                 $fds = $this->Fds->find('all', $conditions);
                 $cnt = $fds->count();
				if($fds) {
					$total_amount = 0;
					foreach ($fds as $fd) {
						$total_amount += $fd->amount;
					}
				}
            } 
            //, 'Banks'
            $this->paginate = [
                'contain' => ['Companies', 'Branches','Brokers', 'Plans']
            ]; 
            $fds = $this->paginate($fds ,['order' => ['Fds.despatchdate' => 'ASC']]);
            $this->set(compact('fds','branch','datedform','datedto','dated2','dated1','cnt','total_amount'));
            $this->set('_serialize', ['fds']);
        }else{
           $branch =''; $datedform =''; $datedto= '';
         /*  if($conditions !=''){
               $fds = $this->Fds->find('all', $conditions);
           }else{
               $fds = $this->Fds;
           }
           
           //, 'Banks'
           $this->paginate = [
                'contain' => ['Companies', 'Branches','Brokers', 'Plans']
            ]; 
            $fds = $this->paginate($fds ,['order' => ['Fds.branch_id' => 'ASC']]);
          * 
          */
           $fds = '';
            $this->set(compact('fds','branch','datedform','datedto'));
            $this->set('_serialize', ['fds']);
        }   
          
    }
    public function dailyncd(){      
      $this->loadModel('Ncds');      
      $this->loadModel('Customers'); 
      $this->loadModel('Banks'); 
      $this->loadModel('Plans'); 
      $this->loadModel('Products');
       $all = array('all'=>'All');    
    
      if($this->Auth->user('group_id')=='2'){ 
          $branch = $this->Ncds->Branches->find('list')->toArray();
         
        $this->Search->addFilter('branch', [
            'attributes'=>['placeholder'=>'Branch Name','label'=>'Branch Name :','class'=>'searchfrm','value' => isset($this->request->query['branch'])?$this->request->query['branch']:''],  
            'options' => $all+$this->Ncds->Branches->find('list')->toArray(),
        ]);
      }  
       /*
        $this->Search->addFilter('datedform', [
         'attributes'=>['placeholder'=>'Despatch Start Date','label'=>'Despatch Start Date :','class'=>'searchfrm','value' => isset($this->request->query['datedform'])?$this->request->query['datedform']:''],
        ]);
        $this->Search->addFilter('datedto', [
           'attributes'=>['placeholder'=>'Despatch End Date','label'=>'Despatch End Date :','class'=>'searchfrm','value' => isset($this->request->query['datedto'])?$this->request->query['datedto']:''],
        ]);
        */
       $this->request->query['datedform'] = $this->request->query['datedto'] = date('d/m/Y');
        $conditions = ''; 
        if($this->Auth->user('group_id')=='3'){             
            $branch_id = $this->Auth->user('branch_id');     
            $conditions['conditions']['and']['Ncds.posteduserbranchid'] = "$branch_id";
        } 
        if (!empty($this->request->query) && count($this->request->query) > 1) { 
             if($this->Auth->user('group_id')=='2'){
               if(!empty($this->request->query['branch'])){
                 $branch = (($this->request->query['branch'] != '')? $this->request->query['branch'] : '');
			   }else{
				$branch = '';   
			   }	               
             } 
            //$conditions = '';           
         // $datedform = (($this->request->query['datedform'] != '')? $this->request->query['datedform'] : ''); 
          // $datedto = (($this->request->query['datedto'] != '')? $this->request->query['datedto'] : ''); 
           $dated2 =  (($this->request->query['datedform'] != '')? $this->request->query['datedform'] : '');
		// $dated2=$this->request->query['datedform'] ;
		
		 $date1 = explode('/',$dated2);
         // $datedform = implode('-',$date1);
		  
       $datedform  = implode('-', array_reverse($date1));
		//pr($datedform);
		$dated1= $this->request->query['datedto'];
		$date = explode('/',$dated1);

        $datedto  = implode('-', array_reverse($date));
           /* if ($datedform && $datedto){
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                     array('trim(Ncds.despatchdate) >= ' => $datedform,
                                       'trim(Ncds.despatchdate) <= ' => $datedto
                                      )
                         )));
            }*/
              if ($datedform && $datedto){
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                     array('Ncds.despatchdate >= ' => $datedform,
                                       'Ncds.despatchdate <= ' => $datedto
                                      )
                         )));
            }
           if (($branch !='') && ($branch !='all')){  $conditions['conditions']['and']['Ncds.branch_id'] = "$branch"; }
            
            if ($branch != ''  || ($datedform && $datedto)){ 
                 $ncds = $this->Ncds->find('all', $conditions);
                 $cnt = $ncds->count();
				if($ncds) {
					$total_amount = 0;
					foreach ($ncds as $ncd) {
						$total_amount += $ncd->amount;
					}
				}
            }else{
                 $ncds = $this->Ncds->find('all', $conditions);
                 $cnt = $ncds->count();
				if($ncds) {
					$total_amount = 0;
					foreach ($ncds as $ncd) {
						$total_amount += $ncd->amount;
					}
				}
            }    
            $this->paginate = [
                 'contain' => ['Companies','Branches','Brokers','Plans']
            ]; 
            $ncds = $this->paginate($ncds ,['order' => ['Ncds.despatchdate' => 'ASC']]);
            $this->set(compact('ncds','branch','datedform','datedto','dated1','dated2','total_amount','cnt'));
            $this->set('_serialize', ['ncds']);
        }else{
           $branch =''; $datedform =''; $datedto= ''; 
         /*   if($conditions !=''){
              $ncds = $this->Ncds->find('all', $conditions);
            }else{
                $ncds = $this->Ncds;
            }  
           $this->paginate = [
                 'contain' => ['Companies','Branches', 'Banks','Brokers','Plans']
            ]; 
            $ncds = $this->paginate($ncds ,['order' => ['Ncds.branch_id' => 'ASC']]);
          * 
          */
           $ncds = '';
            $this->set(compact('ncds','branch','datedform','datedto'));
            $this->set('_serialize', ['ncds']);
        }   
    }
    public function dailyipo(){     
      $this->loadModel('Ipos'); 
      $this->loadModel('Customers'); 
      $this->loadModel('Banks'); 
      $this->loadModel('Plans'); 
      $this->loadModel('Products');
       $all = array('all'=>'All');    
      /* $this->Search->addFilter('Product', [
            'attributes'=>['placeholder'=>'Product Name','label'=>'Product Name :','class'=>'searchfrm',],  
            'options' => $all+$this->Products->find('list')->toArray(),           
        ]); 
      */ 
      if($this->Auth->user('group_id')=='2'){ 
          $branch = $this->Ipos->Branches->find('list')->toArray();
         
        $this->Search->addFilter('branch', [
            'attributes'=>['placeholder'=>'Branch Name','label'=>'Branch Name :','class'=>'searchfrm','value' => isset($this->request->query['branch'])?$this->request->query['branch']:''],  
            'options' => $all+$this->Ipos->Branches->find('list')->toArray(),
        ]);
      }  
       /*
        $this->Search->addFilter('datedform', [
         'attributes'=>['placeholder'=>'Despatch Start Date','label'=>'Despatch Start Date :','class'=>'searchfrm','value' => isset($this->request->query['datedform'])?$this->request->query['datedform']:''],
        ]);
        $this->Search->addFilter('datedto', [
           'attributes'=>['placeholder'=>'Despatch End Date','label'=>'Despatch End Date :','class'=>'searchfrm','value' => isset($this->request->query['datedto'])?$this->request->query['datedto']:''],
        ]);
       */
       $this->request->query['datedform'] = $this->request->query['datedto'] = date('d/m/Y');
        $conditions = ''; 
        if($this->Auth->user('group_id')=='3'){            
            $branch_id = $this->Auth->user('branch_id');     
            $conditions['conditions']['and']['Ipos.posteduserbranchid'] = "$branch_id";
        } 
        if (!empty($this->request->query) && count($this->request->query) > 1) { 
             if($this->Auth->user('group_id')=='2'){
               if(!empty($this->request->query['branch'])){
                 $branch = (($this->request->query['branch'] != '')? $this->request->query['branch'] : '');
			    }else{
				 $branch = '';   
			    }	             
             } 
             $dated2 =  (($this->request->query['datedform'] != '')? $this->request->query['datedform'] : '');
	
		
		 $date1 = explode('/',$dated2);
        	  
       $datedform  = implode('-', array_reverse($date1));
		//pr($datedform);
		$dated1= $this->request->query['datedto'];
		$date = explode('/',$dated1);

        $datedto  = implode('-', array_reverse($date));
            //$conditions = '';           
         // $datedform = (($this->request->query['datedform'] != '')? $this->request->query['datedform'] : ''); 
         //  $datedto = (($this->request->query['datedto'] != '')? $this->request->query['datedto'] : ''); 
           /* if ($datedform && $datedto){
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                     array('trim(Ipos.despatchdate) >= ' => $datedform,
                                       'trim(Ipos.despatchdate) <= ' => $datedto
                                      )
                         )));
            }*/
            if ($datedform && $datedto){
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                     array('Ipos.despatchdate >= ' => $datedform,
                                       'Ipos.despatchdate <= ' => $datedto
                                      )
                         )));
            }
           if (($branch !='') && ($branch !='all')){  $conditions['conditions']['and']['Ipos.branch_id'] = "$branch"; }
            
            if ($branch != ''  || ($datedform && $datedto)){ 
                 $ipos = $this->Ipos->find('all', $conditions);
                 $cnt = $ipos->count();
				if($ipos) {
					$total_amount = 0;
					foreach ($ipos as $ipo) {
						$total_amount += $ipo->amount;
					}
				}
            }else{
                 $ipos = $this->Ipos->find('all', $conditions);
                 $cnt = $ipos->count();
				if($fds) {
					$total_amount = 0;
					foreach ($ipos as $ipo) {
						$total_amount += $ipo->amount;
					}
				}
            }    
            $this->paginate = [
                  'contain' => ['Companies', 'Branches','Brokers','Plans']
            ]; 
            $ipos = $this->paginate($ipos ,['order' => ['Ipos.despatchdate' => 'ASC']]);
            $this->set(compact('ipos','branch','datedform','datedto','dated1','total_amount','dated2'));
            $this->set('_serialize', ['ipos']);
        }else{
           $branch =''; $datedform =''; $datedto= ''; 
        /*    if($conditions !=''){
              $ipos = $this->Ipos->find('all', $conditions);
            }else{
                $ipos = $this->Ipos;
            }  
           $this->paginate = [
                  'contain' => ['Companies', 'Branches','Banks','Brokers','Plans']
            ]; 
            $ipos = $this->paginate($ipos ,['order' => ['Ipos.branch_id' => 'ASC']]);
         * 
         */
           $ipos = '';
            $this->set(compact('ipos','branch','datedform','datedto'));
            $this->set('_serialize', ['ipos']);
        }
    }
    
    public function dtwsmf(){
		$this->loadModel('Mutualfunds');    
		$this->loadModel('Customers'); 
		$this->loadModel('Banks'); 
		$this->loadModel('Plans'); 
		$this->loadModel('Products');
		$all = array('all'=>'All');
		$typeofdeposit = array(
            'Additional' => 'Additional',
            'Fresh' => 'Fresh',
            'SIP' => 'SIP',            
            'Switch' => 'Switch',
            'SIP - Renewal' => 'SIP - Renewal',
            'STP' => 'STP'
        );
		$this->Search->addFilter('typeofdeposit', [
		'attributes'=>['placeholder'=>'Type of Deposit','label'=>'Type of Deposit :     In order to select multiple type click with ctrl key ','multiple' => 'multiple','class'=>'searchfrm','value' => isset($this->request->query['typeofdeposit'])?$this->request->query['typeofdeposit']:''],  
		'options' => $typeofdeposit,]);
      
        if($this->Auth->user('group_id')=='2'){ 
			$branch = $this->Mutualfunds->Branches->find('list')->toArray();
			$this->Search->addFilter('branch', [
				'attributes'=>['placeholder'=>'Branch Name','label'=>'Branch Name :','class'=>'searchfrm','value' => isset($this->request->query['branch'])?$this->request->query['branch']:''],  
				'options' => $all+$this->Mutualfunds->Branches->find('list')->toArray(),
			]);
        }  
      
        $this->Search->addFilter('datedform', [
         'attributes'=>['placeholder'=>'Despatch Start Date','label'=>'Despatch Start Date :','class'=>'searchfrm acb','value' => isset($this->request->query['datedform'])?$this->request->query['datedform']:''],
        ]);
        $this->Search->addFilter('datedto', [
           'attributes'=>['placeholder'=>'Despatch End Date','label'=>'Despatch End Date :','class'=>'searchfrm abc','value' => isset($this->request->query['datedto'])?$this->request->query['datedto']:''],
        ]);
       
        $conditions = ''; 
        if($this->Auth->user('group_id')=='3'){            
            $branch_id = $this->Auth->user('branch_id');     
            $conditions['conditions']['and']['Mutualfunds.posteduserbranchid'] = "$branch_id";
        } 
		
        if (!empty($this->request->query) && count($this->request->query) > 1) { 
           // $conditions = '';
			if($this->Auth->user('group_id')=='2'){
				if(!empty($this->request->query['branch'])){
					$branch = (($this->request->query['branch'] != '')? $this->request->query['branch'] : '');
				}else{
					$branch = '';   
				}              
			}  
			$dated2 =  (($this->request->query['datedform'] != '')? $this->request->query['datedform'] : '');
		    $date1 = explode('/',$dated2);
            $datedform = implode('-',$date1);
			$datedform  = implode('-', array_reverse($date1));
			//pr($datedform);
			$dated1= $this->request->query['datedto'];
			$date = explode('/',$dated1);
			$datedto  = implode('-', array_reverse($date));
			if(!empty($this->request->query['typeofdeposit'])){
              $typeofdeposit_sel = (($this->request->query['typeofdeposit'] != '')? $this->request->query['typeofdeposit'] : ''); 
			}else{
				$typeofdeposit_sel = '';   
			}
          
			$cnt = $total_amount = 0;
            if ($datedform && $datedto){             
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
						 array('Mutualfunds.despatchdate >= ' => $datedform,
						   'Mutualfunds.despatchdate <= ' => $datedto
						  )
                         )));
            }
            if (($branch !='') && ($branch !='all')){ $conditions['conditions']['and']['Mutualfunds.branch_id'] = "$branch"; }
            if (!empty($typeofdeposit_sel)){ 
               $conditions['conditions']['and']['Mutualfunds.typeofdeposit IN '] = $typeofdeposit_sel; 			 
            }  
            if ($branch != ''  || ($datedform && $datedto)) {
                $mutualfunds = $this->Mutualfunds->find('all', $conditions);
				$cnt = $mutualfunds->count();              
				if($mutualfunds){
					$total_amount = 0;                   
					 foreach ($mutualfunds as $md){ 
						$total_amount += $md->amount;
					 }
				} 
				
            }else{
                if($conditions !=''){
                    $mutualfunds = $this->Mutualfunds->find('all', $conditions);  
                    $cnt = $mutualfunds->count();              
                        if($mutualfunds){
                            $total_amount = 0;                   
							foreach ($mutualfunds as $md){ 
								$total_amount += $md->amount;
							}
                        } 
                }else{
                    $mutualfunds = $this->Mutualfunds; 
                    $mf1=$this->Mutualfunds->find('all',array('contain' => ['Companies', 'Branches', 'Mffunds','Brokers']));
					$cnt = $mf1->count();              
                        if($mf1){
                           $total_amount = 0;                   
                             foreach ($mf1 as $md){ 
                                    $total_amount += $md->amount;
                             }
                        } 
                  } 
            } 
          
            //, 'Banks',
            $this->paginate = [
                'contain' => ['Companies', 'Branches', 'Mffunds','Brokers']
            ]; 
             
            $mutualfunds = $this->paginate($mutualfunds ,['order' => ['Mutualfunds.despatchdate' => 'ASC','Mutualfunds.typeofdeposit']]);  
 	        $this->set(compact('mutualfunds','branch','datedform','datedto','total_amount','cnt','dated2','dated1'));
            $this->set('_serialize', ['mutualfunds']);
        }else{
            $branch =''; $datedform =''; $datedto= '';
            $mutualfunds = '';
            $this->set(compact('mutualfunds','branch','datedform','datedto','total_amount','cnt'));         
            $this->set('_serialize', ['mutualfunds']);
        }      
    }
	
	public function dtwsfd(){
      $this->loadModel('Fds');     
      $this->loadModel('Customers'); 
      $this->loadModel('Banks'); 
      $this->loadModel('Plans'); 
      $this->loadModel('Products');
      
      $all = array('all'=>'All');    
   
      if($this->Auth->user('group_id')=='2'){ 
          $branch = $this->Fds->Branches->find('list')->toArray();
         
        $this->Search->addFilter('branch', [
            'attributes'=>['placeholder'=>'Branch Name','label'=>'Branch Name :','class'=>'searchfrm','value' => isset($this->request->query['branch'])?$this->request->query['branch']:''],  
            'options' => $all+$this->Fds->Branches->find('list')->toArray(),
        ]);
      }  
       
        $this->Search->addFilter('datedform', [
         'attributes'=>['placeholder'=>'Despatch Start Date','label'=>'Despatch Start Date :','class'=>'searchfrm','value' => isset($this->request->query['datedform'])?$this->request->query['datedform']:''],
        ]);
        $this->Search->addFilter('datedto', [
           'attributes'=>['placeholder'=>'Despatch End Date','label'=>'Despatch End Date :','class'=>'searchfrm','value' => isset($this->request->query['datedto'])?$this->request->query['datedto']:''],
        ]);
       
       $conditions = '';
       if($this->Auth->user('group_id')=='3'){
            //$conditions = '';  
            $branch_id = $this->Auth->user('branch_id');     
            $conditions['conditions']['and']['Fds.posteduserbranchid'] = "$branch_id";
        } 
        if (!empty($this->request->query) && count($this->request->query) > 1) { 
          // $conditions = '';
           if($this->Auth->user('group_id')=='2'){
			   if(!empty($this->request->query['branch'])){
              $branch = (($this->request->query['branch'] != '')? $this->request->query['branch'] : '');
			   }else{
				$branch = '';   
			   }			  
           }    
        $dated2 =  (($this->request->query['datedform'] != '')? $this->request->query['datedform'] : '');
		$date1 = explode('/',$dated2);
        $datedform  = implode('-', array_reverse($date1));
		$dated1= $this->request->query['datedto'];
		$date = explode('/',$dated1);

        $datedto  = implode('-', array_reverse($date));
            if ($datedform && $datedto){
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                     array('Fds.despatchdate >= ' => $datedform,
                                       'Fds.despatchdate <= ' => $datedto
                                      )
                         )));
            }
            if (($branch !='') && ($branch !='all')){ $conditions['conditions']['and']['Fds.branch_id'] = "$branch"; }
            
            if ($branch != ''  || ($datedform && $datedto)){                 
                 $fds = $this->Fds->find('all', $conditions);
                 $cnt = $fds->count();
				if($fds) {
					$total_amount = 0;
					foreach ($fds as $fd) {
						$total_amount += $fd->amount;
					}
				}
                 
            }else{
                 $fds = $this->Fds->find('all', $conditions);
                 $cnt = $fds->count();
				if($fds) {
					$total_amount = 0;
					foreach ($fds as $fd) {
						$total_amount += $fd->amount;
					}
				}
            } 
            //, 'Banks'
            $this->paginate = [
                'contain' => ['Companies', 'Branches','Brokers', 'Plans']
            ]; 
            $fds = $this->paginate($fds ,['order' => ['Fds.despatchdate' => 'ASC']]);
            $this->set(compact('fds','branch','datedform','datedto','dated2','dated1','cnt','total_amount'));
            $this->set('_serialize', ['fds']);
        }else{
            $branch =''; $datedform =''; $datedto= '';
            $fds = '';
            $this->set(compact('fds','branch','datedform','datedto'));
            $this->set('_serialize', ['fds']);
        }   
          
    }
	
	public function dtwsncd(){      
      $this->loadModel('Ncds');      
      $this->loadModel('Customers'); 
      $this->loadModel('Banks'); 
      $this->loadModel('Plans'); 
      $this->loadModel('Products');
       $all = array('all'=>'All');    
    
      if($this->Auth->user('group_id')=='2'){ 
          $branch = $this->Ncds->Branches->find('list')->toArray();
         
        $this->Search->addFilter('branch', [
            'attributes'=>['placeholder'=>'Branch Name','label'=>'Branch Name :','class'=>'searchfrm','value' => isset($this->request->query['branch'])?$this->request->query['branch']:''],  
            'options' => $all+$this->Ncds->Branches->find('list')->toArray(),
        ]);
      }  
      
        $this->Search->addFilter('datedform', [
         'attributes'=>['placeholder'=>'Despatch Start Date','label'=>'Despatch Start Date :','class'=>'searchfrm','value' => isset($this->request->query['datedform'])?$this->request->query['datedform']:''],
        ]);
        $this->Search->addFilter('datedto', [
           'attributes'=>['placeholder'=>'Despatch End Date','label'=>'Despatch End Date :','class'=>'searchfrm','value' => isset($this->request->query['datedto'])?$this->request->query['datedto']:''],
        ]);
       
        $conditions = ''; 
        if($this->Auth->user('group_id')=='3'){             
            $branch_id = $this->Auth->user('branch_id');     
            $conditions['conditions']['and']['Ncds.posteduserbranchid'] = "$branch_id";
        } 
	
        if (!empty($this->request->query) && count($this->request->query) > 1) { 
             if($this->Auth->user('group_id')=='2'){
               if(!empty($this->request->query['branch'])){
					$branch = (($this->request->query['branch'] != '')? $this->request->query['branch'] : '');
				}else{
					$branch = '';   
				}              
             } 

        $dated2 =  (($this->request->query['datedform'] != '')? $this->request->query['datedform'] : '');
		$date1 = explode('/',$dated2);
        $datedform  = implode('-', array_reverse($date1));
		//pr($datedform);
		$dated1= $this->request->query['datedto'];
		$date = explode('/',$dated1);

        $datedto  = implode('-', array_reverse($date));
            if ($datedform && $datedto){
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                     array('Ncds.despatchdate >= ' => $datedform,
                                       'Ncds.despatchdate <= ' => $datedto
                                      )
                         )));
            }
           if (($branch !='') && ($branch !='all')){  $conditions['conditions']['and']['Ncds.branch_id'] = "$branch"; }
            if ($branch != ''  || ($datedform && $datedto)){ 
                 $ncds = $this->Ncds->find('all', $conditions);
                 $cnt = $ncds->count();
				if($ncds) {
					$total_amount = 0;
					foreach ($ncds as $ncd) {
						$total_amount += $ncd->amount;
					}
				}
            }else{
                 $ncds = $this->Ncds->find('all', $conditions);
                 $cnt = $ncds->count();
				if($ncds) {
					$total_amount = 0;
					foreach ($ncds as $ncd) {
						$total_amount += $ncd->amount;
					}
				}
            }    
            $this->paginate = [
                 'contain' => ['Companies','Branches','Brokers','Plans']
            ]; 
            $ncds = $this->paginate($ncds ,['order' => ['Ncds.despatchdate' => 'ASC']]);
            $this->set(compact('ncds','branch','datedform','datedto','dated1','dated2','total_amount','cnt'));
            $this->set('_serialize', ['ncds']);
        }else{
            $branch =''; $datedform =''; $datedto= ''; 
            $ncds = '';
            $this->set(compact('ncds','branch','datedform','datedto'));
            $this->set('_serialize', ['ncds']);
        }   
    }
    public function dtwsipo(){     
      $this->loadModel('Ipos'); 
      $this->loadModel('Customers'); 
      $this->loadModel('Banks'); 
      $this->loadModel('Plans'); 
      $this->loadModel('Products');
       $all = array('all'=>'All');    
      if($this->Auth->user('group_id')=='2'){ 
          $branch = $this->Ipos->Branches->find('list')->toArray();
         
        $this->Search->addFilter('branch', [
            'attributes'=>['placeholder'=>'Branch Name','label'=>'Branch Name :','class'=>'searchfrm','value' => isset($this->request->query['branch'])?$this->request->query['branch']:''],  
            'options' => $all+$this->Ipos->Branches->find('list')->toArray(),
        ]);
      }  
       
        $this->Search->addFilter('datedform', [
         'attributes'=>['placeholder'=>'Despatch Start Date','label'=>'Despatch Start Date :','class'=>'searchfrm','value' => isset($this->request->query['datedform'])?$this->request->query['datedform']:''],
        ]);
        $this->Search->addFilter('datedto', [
           'attributes'=>['placeholder'=>'Despatch End Date','label'=>'Despatch End Date :','class'=>'searchfrm','value' => isset($this->request->query['datedto'])?$this->request->query['datedto']:''],
        ]);
       
        $conditions = ''; 
        if($this->Auth->user('group_id')=='3'){            
            $branch_id = $this->Auth->user('branch_id');     
            $conditions['conditions']['and']['Ipos.posteduserbranchid'] = "$branch_id";
        } 
		//$this->request->query['datedform'] = $this->request->query['datedto'] = date('d/m/Y');
        if (!empty($this->request->query) && count($this->request->query) > 1) { 
             if($this->Auth->user('group_id')=='2'){
               if(!empty($this->request->query['branch'])){
					$branch = (($this->request->query['branch'] != '')? $this->request->query['branch'] : '');
				}else{
					$branch = '';   
				}              
             } 
             $dated2 =  (($this->request->query['datedform'] != '')? $this->request->query['datedform'] : '');
	
		
		 $date1 = explode('/',$dated2);
        	  
       $datedform  = implode('-', array_reverse($date1));
		//pr($datedform);
		$dated1= $this->request->query['datedto'];
		$date = explode('/',$dated1);

        $datedto  = implode('-', array_reverse($date));
            if ($datedform && $datedto){
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                     array('Ipos.despatchdate >= ' => $datedform,
                                       'Ipos.despatchdate <= ' => $datedto
                                      )
                         )));
            }
           if (($branch !='') && ($branch !='all')){  $conditions['conditions']['and']['Ipos.branch_id'] = "$branch"; }
            
            if ($branch != ''  || ($datedform && $datedto)){ 
                 $ipos = $this->Ipos->find('all', $conditions);
                 $cnt = $ipos->count();
				if($ipos) {
					$total_amount = 0;
					foreach ($ipos as $ipo) {
						$total_amount += $ipo->amount;
					}
				}
            }else{
                 $ipos = $this->Ipos->find('all', $conditions);
                 $cnt = $ipos->count();
				if($fds) {
					$total_amount = 0;
					foreach ($ipos as $ipo) {
						$total_amount += $ipo->amount;
					}
				}
            }    
            $this->paginate = [
                  'contain' => ['Companies', 'Branches','Brokers','Plans']
            ]; 
            $ipos = $this->paginate($ipos ,['order' => ['Ipos.despatchdate' => 'ASC']]);
            $this->set(compact('ipos','branch','datedform','datedto','dated1','total_amount','dated2'));
            $this->set('_serialize', ['ipos']);
        }else{
           $branch =''; $datedform =''; $datedto= ''; 
            $ipos = '';
            $this->set(compact('ipos','branch','datedform','datedto'));
            $this->set('_serialize', ['ipos']);
        }
    }
     public function dailymfexcelreport(){   
         $this->autoRender = false;
         // $this->layout = false;        
        $fileName = "dailyreportsmf_".date("d-m-y:h:s").".xls";  
        $this->loadModel('Mutualfunds');
        $this->loadModel('Customers'); 
        $this->loadModel('Banks'); 
        $this->loadModel('Plans'); 
        
        $conditions = '';  
        if($this->Auth->user('group_id')=='3'){           
            $branch_id = $this->Auth->user('branch_id');     
            $conditions['conditions']['and']['Mutualfunds.posteduserbranchid'] = "$branch_id";
        }  
       
        $branch = $this->request->query['branch'];   
        $datedform = $this->request->query['datedform'];
        $datedto = $this->request->query['datedto'];
         
            if ($datedform && $datedto){
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                     array('trim(Mutualfunds.despatchdate) >= ' => $datedform,
                                       'trim(Mutualfunds.despatchdate) <= ' => $datedto
                                      )
                         )));
            }
           if (($branch !='') && ($branch !='all')){  $conditions['conditions']['or']['Mutualfunds.branch_id'] = "$branch"; }
            
            if ($branch != ''  || ($datedform && $datedto)){ 
                 $mutualfunds = $this->Mutualfunds->find('all', $conditions);
            }else{                
                  if($conditions !=''){
                    $mutualfunds = $this->Mutualfunds->find('all', $conditions);
                  }else{
                     $mutualfunds = $this->Mutualfunds; 
                  } 
            }   
            
            //, 'Banks'
          $this->paginate = [
                 'contain' => ['Companies', 'Branches','Brokers', 'Mffunds']
            ];
        $mutualfunds = $this->paginate($mutualfunds ,['order' => ['Mutualfunds.branch_id' => 'ASC']]);
        $datafds = $mutualfunds->toArray(); 
       //pr($datafds);  
        
        $banks = TableRegistry::get('Banks');
     
        $headerRow = array("Sr.","Company", "Type of Deposit",'Name','Product','Scheme','Amount','Cheque No','Folio No','Application No','Bank Name');
        $j=1;
            for($i=0; $i< count($datafds); $i++){
                        if($datafds[$i]->bank_id > 0){
                            $banksid = $banks->find()->where(['id' => $datafds[$i]->bank_id]);
                            $data1 = $banksid->toArray();
                            $banksName = $data1[0]->banks;
                        }else{
                            $banksName = '';
                        }   
                $data[] = [$j,$datafds[$i]->company->company,$datafds[$i]->typeofdeposit,$datafds[$i]->firstapplicantname,"Mutual Fund",$datafds[$i]->mffund->fundname,$datafds[$i]->amount,$datafds[$i]->chequeno,$datafds[$i]->customerFolioNo,$datafds[$i]->applicationno,$banksName];
            $j++;
                } 
        $this->ExportXls->export($fileName, $headerRow, $data);
    }  
    
    public function dailyfdsexcelreport(){   $conditions = '';
         $this->autoRender = false;
         // $this->layout = false;        
         $fileName = "dailyreportsfds_".date("d-m-y:h:s").".xls";        
        $this->loadModel('Fds');
        $this->loadModel('Customers'); 
        $this->loadModel('Banks'); 
        $this->loadModel('Plans'); 
        
        if($this->Auth->user('group_id')=='3'){           
            $branch_id = $this->Auth->user('branch_id');     
            $conditions['conditions']['and']['Fds.posteduserbranchid'] = "$branch_id";
        }  
        $branch = $this->request->query['branch'];   
        $datedform = $this->request->query['datedform'];
        $datedto = $this->request->query['datedto'];
        
         if ($datedform && $datedto){
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                     array('trim(Fds.despatchdate) >= ' => $datedform,
                                       'trim(Fds.despatchdate) <= ' => $datedto
                                      )
                         )));
            }
        if (($branch !='') && ($branch !='all')){  $conditions['conditions']['or']['Fds.branch_id'] = "$branch"; }
            if ($branch != ''  || ($datedform && $datedto)){                 
                 $fds = $this->Fds->find('all', $conditions);
            }else{
                if($conditions !=''){
                 $fds = $this->Fds->find('all', $conditions);
                }else{
                  $fds = $this->Fds;
                }  
            }  
          $this->paginate = [
                 'contain' => ['Companies', 'Branches','Brokers', 'Plans', 'Banks']
            ];
        $fds = $this->paginate($fds ,['order' => ['Fds.branch_id' => 'ASC']]);
        $datafds = $fds->toArray(); 
      // pr($datafds);    
     
        $headerRow = array("Sr.","Company", "Type of Deposit",'Name','Product','Scheme','Amount','Cheque No','Folio/FDR No','Application No','Bank Name');
        $j=1;
            for($i=0; $i< count($datafds); $i++){
                $data[] = [$j,$datafds[$i]->company->company,$datafds[$i]->typeofdeposit,$datafds[$i]->fapplicantname,"Fixed Deposit",$datafds[$i]->plan->Planname,$datafds[$i]->amount,$datafds[$i]->chequeno,$datafds[$i]->fdrno,$datafds[$i]->applicationno,$datafds[$i]->bank->banks];
            $j++;
                } 
        $this->ExportXls->export($fileName, $headerRow, $data);
    }       
     public function dailyncdexcelreport(){   
         $this->autoRender = false;
         // $this->layout = false;        
         $fileName = "dailyreportsncd_".date("d-m-y:h:s").".xls"; 
        $this->loadModel('Ncds'); 
        $this->loadModel('Customers'); 
        $this->loadModel('Banks'); 
        $this->loadModel('Plans'); 
        $conditions = ''; 
        if($this->Auth->user('group_id')=='3'){             
            $branch_id = $this->Auth->user('branch_id');     
            $conditions['conditions']['and']['Ncds.posteduserbranchid'] = "$branch_id";
        }  
        $branch = $this->request->query['branch'];   
        $datedform = $this->request->query['datedform'];
        $datedto = $this->request->query['datedto'];
         
         if ($datedform && $datedto){
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                     array('trim(Ncds.despatchdate) >= ' => $datedform,
                                       'trim(Ncds.despatchdate) <= ' => $datedto
                                      )
                         )));
            }
          if (($branch !='') && ($branch !='all')){  $conditions['conditions']['or']['Ncds.branch_id'] = "$branch"; }
          
            if ($branch != ''  || ($datedform && $datedto)){ 
                 $ncds = $this->Ncds->find('all', $conditions);
            }else{
                if($conditions !=''){
                    $ncds = $this->Ncds->find('all', $conditions);
                }else{
                    $ncds = $this->Ncds;
                } 
            }    
        $this->paginate = [
            'contain' => ['Companies','Branches', 'Banks','Brokers','Plans']
        ];
        $ncds = $this->paginate($ncds,['order' => ['Ncds.branch_id' => 'ASC']]);
        $datafds = $ncds->toArray(); 
      // pr($datafds);    
     
        $headerRow = array("Sr.","Company", "Type of Deposit",'Name','Product','Scheme','Amount','Cheque No','Folio/FDR No','Application No','Bank Name');
        $j=1;
            for($i=0; $i< count($datafds); $i++){
                $data[] = [$j,$datafds[$i]->company->company,$datafds[$i]->typeofdeposit,$datafds[$i]->firstapplicantname,"NCD",$datafds[$i]->plan->Planname,$datafds[$i]->amount,$datafds[$i]->chequeno,$datafds[$i]->fdrno,$datafds[$i]->applicationno,$datafds[$i]->bank->banks];
            $j++;
                } 
        $this->ExportXls->export($fileName, $headerRow, $data);
    } 
     public function dailyipoexcelreport(){   
         $this->autoRender = false;
         // $this->layout = false;        
         $fileName = "dailyreportsipo_".date("d-m-y:h:s").".xls"; 
        $this->loadModel('Ipos'); 
        $this->loadModel('Customers'); 
        $this->loadModel('Banks'); 
        $this->loadModel('Plans'); 
         $conditions = '';  
        if($this->Auth->user('group_id')=='3'){           
            $branch_id = $this->Auth->user('branch_id');     
            $conditions['conditions']['and']['Ipos.posteduserbranchid'] = "$branch_id";
        } 
        $branch = $this->request->query['branch'];   
        $datedform = $this->request->query['datedform'];
        $datedto = $this->request->query['datedto'];
                
        if ($datedform && $datedto){
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                     array('trim(Ipos.despatchdate) >= ' => $datedform,
                                       'trim(Ipos.despatchdate) <= ' => $datedto
                                      )
                         )));
            }
          if (($branch !='') && ($branch !='all')){  $conditions['conditions']['or']['Ipos.branch_id'] = "$branch"; }
          
            if ($branch != ''  || ($datedform && $datedto)){ 
                 $ipos = $this->Ipos->find('all', $conditions);
            }else{
                if($conditions !=''){
                 $ipos = $this->Ipos->find('all', $conditions);
                }else{
                    $ipos = $this->Ipos;
                } 
            }   
       
        $this->paginate = [
            'contain' => ['Companies', 'Branches','Banks','Brokers','Plans']
        ]; 
        $ipos = $this->paginate($ipos,['order' => ['Ipos.branch_id' => 'ASC']]);
        $datafds = $ipos->toArray(); 
      // pr($datafds);    
     
        $headerRow = array("Sr.","Company", "Type of Deposit",'Name','Product','Scheme','Amount','Cheque No','Folio/FDR No','Application No','Bank Name');
        $j=1;
            for($i=0; $i< count($datafds); $i++){
                $data[] = [$j,$datafds[$i]->company->company,$datafds[$i]->typeofdeposit,$datafds[$i]->biddername,"IPO",$datafds[$i]->plan->Planname,$datafds[$i]->amount,$datafds[$i]->chequeno,$datafds[$i]->fdrno,$datafds[$i]->applicationno,$datafds[$i]->bank->banks];
            $j++;
                } 
        $this->ExportXls->export($fileName, $headerRow, $data);
    } 
    
   public function ncd()
    {
      $this->loadModel('Ncds'); 
      $this->loadModel('Customers'); 
      $this->loadModel('Banks'); 
      $this->loadModel('Plans'); 
      
      $this->Search->addFilter('applicationno', [
          'attributes' => ['placeholder'=>'Appliation Number','label'=>'Appliation Number :','class'=>'searchfrm',],
       ]);
      $this->Search->addFilter('fapplicantname', [
          'attributes'=>['placeholder'=>'Applicant Name','label'=>'Applicant Name :','class'=>'searchfrm',],
       ]);
       $this->Search->addFilter('panno', [
          'attributes'=>['placeholder'=>'Pan No','label'=>'Pan Number :','class'=>'searchfrm',],
       ]);
      $this->Search->addFilter('datedform', [
         'attributes'=>['placeholder'=>'Date From','label'=>'Date From :','class'=>'searchfrm',],
      ]);
      $this->Search->addFilter('datedto', [
         'attributes'=>['placeholder'=>'Date to','label'=>'Date to :','class'=>'searchfrm',],
      ]); 
      $this->Search->addFilter('banks', [
        'attributes'=>['placeholder'=>'Bank Name','label'=>'Bank Name :','class'=>'searchfrm',],  
        'options' => $this->Ncds->Banks->find('list')->toArray(),
      ]);
      $this->Search->addFilter('customerid', [
        'attributes'=>['placeholder'=>'Customer Account','label'=>'Customer Account :','class'=>'searchfrm',],  
        'options' => $this->Ncds->Customers->find('list')->toArray(),
      ]);
     
      if (!empty($this->request->query)) { 
         $applicationno = $this->request->query['applicationno'];
         $fapplicantname = $this->request->query['fapplicantname']; 
         $panno = $this->request->query['panno'];
         $banks = $this->request->query['banks'];
         $customerid = $this->request->query['customerid'];          
         $datedform = $this->request->query['datedform'];
         $datedto = $this->request->query['datedto'];           
         
         if ($applicationno){ $conditions['conditions']['or']['Ncds.applicationno LIKE'] = "%$applicationno%"; }
         if ($fapplicantname){ $conditions['conditions']['or']['Ncds.fapplicantname LIKE'] = "%$fapplicantname%"; }
         if ($panno){ $conditions['conditions']['or']['Ncds.firstapplicantpan'] = "$panno"; }
         if ($banks){ $conditions['conditions']['or']['Ncds.bank_id'] = "$banks"; }
         if ($customerid){ $conditions['conditions']['or']['Ncds.customer_id'] = "$customerid"; }   
          if ($datedform && $datedto){
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                     array('Ncds.created >= ' => $datedform,
                                           'Ncds.created <= ' => $datedto
                                          )
                         )));
            }

            if ($applicationno !='' || $fapplicantname != '' || $panno != '' || $banks !='' || $customerid != '' || ($datedform && $datedto)){ 
                  $ncds = $this->Ncds->find('all', $conditions);
            }else{
                  $ncds = $this->Ncds;
            }    
            $this->paginate = [
               'contain' => []
            ]; 
            $ncds = $this->paginate($ncds ,['order' => ['Ncds.id' => 'DESC']]);
            $this->set(compact('ncds','panno','applicationno','fapplicantname','banks','customerid','datedform','datedto'));
            $this->set('_serialize', ['ncds']);
       
      }else{ 
         $applicationno = '';
         $fapplicantname = '';          
         $banks = '';
         $customerid = '';          
         $datedform = '';
         $datedto = ''; 
         $panno = '';
         
            $this->paginate = [
                'contain' => []
            ];
            $ncds = $this->paginate($this->Ncds,['order' => ['Ncds.id' => 'DESC']]);
            $this->set(compact('ncds','panno','applicationno','fapplicantname','banks','customerid','datedform','datedto'));
            $this->set('_serialize', ['ncds']);
      } 
    }
        
    function ncdreports() {
   
         $this->autoRender = false;
         // $this->layout = false;        
         $fileName = "ncdreports_".date("d-m-y:h:s").".xls";        
         $this->loadModel('Ncds'); 
         $this->loadModel('Customers'); 
         $this->loadModel('Banks'); 
         $this->loadModel('Plans'); 
         
        $applicationno = $this->request->query['applicationno'];
        $fapplicantname = $this->request->query['fapplicantname'];
        $panno = $this->request->query['panno'];
        $banks = $this->request->query['banks'];
        $customerid = $this->request->query['customerid']; 
        $datedform = $this->request->query['datedform'];
        $datedto = $this->request->query['datedto']; 
       if ($applicationno){ $conditions['conditions']['or']['Ncds.applicationno LIKE'] = "%$applicationno%"; }
       if ($fapplicantname){ $conditions['conditions']['or']['Ncds.fapplicantname LIKE'] = "%$fapplicantname%"; }
       if ($panno){ $conditions['conditions']['or']['Ncds.firstapplicantpan'] = "$panno"; }
       if ($banks){ $conditions['conditions']['or']['Ncds.bank_id'] = "$banks"; }
       if ($customerid){ $conditions['conditions']['or']['Ncds.customer_id'] = "$customerid"; }   
       if ($datedform && $datedto){
             $conditions = array(
                 'conditions' => array(
                 'and' => array(
                                 array('Ncds.created >= ' => $datedform,
                                       'Ncds.created <= ' => $datedto
                                      )
                     )));
        }

           if ($applicationno !='' || $fapplicantname != '' || $panno != '' || $banks !='' || $customerid != '' || ($datedform && $datedto)){ 
              $ncds = $this->Ncds->find('all', $conditions);
           }else{
              $ncds = $this->Ncds;
           }    

           $this->paginate = [
              'contain' => ['Banks','Bankbranches','Searies']
           ]; 
        $ncds = $this->paginate($ncds ,['order' => ['Ncds.id' => 'DESC']]);
        $datafds = $ncds->toArray(); 
        
        $headerRow = array("Application No","Applicant Name", "Pan No",
             "Amount","Banks","Bank Branch");
        
         for($i=0; $i< count($datafds); $i++){
            $data[] = [$datafds[$i]->applicationno,$datafds[$i]->firstapplicantname,$datafds[$i]->firstapplicantpan,
                       $datafds[$i]->amount,
                        $datafds[$i]->bank->banks,$datafds[$i]->bankbranch->branchaddress];
          }            
          $this->ExportXls->export($fileName, $headerRow, $data);
        }
        
        
    public function ipo()
    {
      $this->loadModel('Ipos'); 
      $this->loadModel('Customers'); 
      $this->loadModel('Banks'); 
      $this->loadModel('Plans'); 
      
      $this->Search->addFilter('applicationno', [
          'attributes' => ['placeholder'=>'Appliation Number','label'=>'Appliation Number :','class'=>'searchfrm',],
       ]);
      $this->Search->addFilter('fapplicantname', [
          'attributes'=>['placeholder'=>'Applicant Name','label'=>'Applicant Name :','class'=>'searchfrm',],
       ]);
       $this->Search->addFilter('panno', [
          'attributes'=>['placeholder'=>'Pan No','label'=>'Pan Number :','class'=>'searchfrm',],
       ]);
      $this->Search->addFilter('datedform', [
         'attributes'=>['placeholder'=>'Date From','label'=>'Date From :','class'=>'searchfrm',],
      ]);
      $this->Search->addFilter('datedto', [
         'attributes'=>['placeholder'=>'Date to','label'=>'Date to :','class'=>'searchfrm',],
      ]); 
      $this->Search->addFilter('banks', [
        'attributes'=>['placeholder'=>'Bank Name','label'=>'Bank Name :','class'=>'searchfrm',],  
        'options' => $this->Ipos->Banks->find('list')->toArray(),
      ]);
      $this->Search->addFilter('customerid', [
        'attributes'=>['placeholder'=>'Customer Account','label'=>'Customer Account :','class'=>'searchfrm',],  
        'options' => $this->Ipos->Customers->find('list')->toArray(),
      ]);

      if (!empty($this->request->query)) {  
         $applicationno = (($this->request->query['applicationno'])? $this->request->query['applicationno'] : '');
         $fapplicantname = $this->request->query['fapplicantname']; 
         $panno = $this->request->query['panno'];
         $banks = $this->request->query['banks'];
         $customerid = $this->request->query['customerid'];          
         $datedform = $this->request->query['datedform'];
         $datedto = $this->request->query['datedto'];           
         
         if ($applicationno){ $conditions['conditions']['or']['Ipos.applicationno LIKE'] = "%$applicationno%"; }
         if ($fapplicantname){ $conditions['conditions']['or']['Ipos.fapplicantname LIKE'] = "%$fapplicantname%"; }
         if ($panno){ $conditions['conditions']['or']['Ipos.bidderpanno'] = "$panno"; }
         if ($banks){ $conditions['conditions']['or']['Ipos.bank_id'] = "$banks"; }
         if ($customerid){ $conditions['conditions']['or']['Ipos.customer_id'] = "$customerid"; }   
          if ($datedform && $datedto){
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                     array('Ipos.created >= ' => $datedform,
                                           'Ipos.created <= ' => $datedto
                                          )
                         )));
            }

            if ($applicationno !='' || $fapplicantname != '' || $panno != '' || $banks !='' || $customerid != '' || ($datedform && $datedto)){ 
               $ipos = $this->Ipos->find('all', $conditions);
            }else{
               $ipos = $this->Ipos;                
            }    
            $this->paginate = [
               'contain' => []
            ]; 
            $ipos = $this->paginate($ipos ,['order' => ['Ipos.id' => 'DESC']]);
            $this->set(compact('ipos','panno','applicationno','fapplicantname','banks','customerid','datedform','datedto'));
            $this->set('_serialize', ['ipos']);
       
      }else{ 
         $applicationno = '';
         $fapplicantname = '';          
         $banks = '';
         $customerid = '';          
         $datedform = '';
         $datedto = ''; 
         $panno = '';
            $this->paginate = [
                'contain' => []
            ];
            $ipos = $this->paginate($this->Ipos,['order' => ['Ipos.id' => 'DESC']]);
            $this->set(compact('ipos','panno','applicationno','fapplicantname','banks','customerid','datedform','datedto'));
            $this->set('_serialize', ['ipos']);
      } 
    }
        
    function iporeports() {
   
         $this->autoRender = false;
         // $this->layout = false;        
         $fileName = "iporeports_".date("d-m-y:h:s").".xls";        
         $this->loadModel('Ipos'); 
         $this->loadModel('Customers'); 
         $this->loadModel('Banks'); 
         $this->loadModel('Plans'); 
         
        $applicationno = $this->request->query['applicationno'];
        $fapplicantname = $this->request->query['fapplicantname'];
        $panno = $this->request->query['panno'];
        $banks = $this->request->query['banks'];
        $customerid = $this->request->query['customerid']; 
        $datedform = $this->request->query['datedform'];
        $datedto = $this->request->query['datedto']; 
       if ($applicationno){ $conditions['conditions']['or']['Ipos.applicationno LIKE'] = "%$applicationno%"; }
       if ($fapplicantname){ $conditions['conditions']['or']['Ipos.fapplicantname LIKE'] = "%$fapplicantname%"; }
       if ($panno){ $conditions['conditions']['or']['Ipos.bidderpanno'] = "$panno"; }
       if ($banks){ $conditions['conditions']['or']['Ipos.bank_id'] = "$banks"; }
       if ($customerid){ $conditions['conditions']['or']['Ipos.customer_id'] = "$customerid"; }   
       if ($datedform && $datedto){
             $conditions = array(
                 'conditions' => array(
                 'and' => array(
                                 array('Ipos.created >= ' => $datedform,
                                       'Ipos.created <= ' => $datedto
                                      )
                     )));
        }

           if ($applicationno !='' || $fapplicantname != '' || $panno != '' || $banks !='' || $customerid != '' || ($datedform && $datedto)){ 
              $ipos = $this->Ipos->find('all', $conditions);
           }else{
              $ipos = $this->Ipos;
           }    

           $this->paginate = [
              'contain' => ['Banks','Bankbranches']
           ]; 
        $ipos = $this->paginate($ipos ,['order' => ['Ipos.id' => 'DESC']]);
        $datafds = $ipos->toArray(); 
          
        $headerRow = array("Application No","Applicant Name", "Pan No",
             "Amount","Banks","Bank Branch");
        
         for($i=0; $i< count($datafds); $i++){
            $data[] = [$datafds[$i]->applicationno,$datafds[$i]->biddername,$datafds[$i]->bidderpanno,
                       $datafds[$i]->amount,
                        $datafds[$i]->bank->banks,$datafds[$i]->bankbranch->branchaddress];
          }           
          $this->ExportXls->export($fileName, $headerRow, $data);
    } 

    public function customerdetail()
    {   
     // $this->loadModel('Ipos','Mutualfunds','Ncds','Fds'); 
     // $this->loadModel('Bankbranches', 'Investments','Searies');
     // $this->loadModel('Banks'); 
      $this->loadModel('Customers'); 
      
      $this->Search->addFilter('customername', [
          'attributes'=>['placeholder'=>'Customer Name','label'=>'Customer Name :','class'=>'searchfrm',],
       ]);
       $this->Search->addFilter('panno', [
          'attributes'=>['placeholder'=>'Pan No','label'=>'Pan Number :','class'=>'searchfrm',],
       ]);
      $this->Search->addFilter('datedform', [
         'attributes'=>['placeholder'=>'Date From','label'=>'Date From :','class'=>'searchfrm',],
      ]);
      $this->Search->addFilter('datedto', [
         'attributes'=>['placeholder'=>'Date to','label'=>'Date to :','class'=>'searchfrm',],
      ]); 
     
      $this->Search->addFilter('customerid', [
        'attributes'=>['placeholder'=>'Customer Account','label'=>'Customer Account :','class'=>'searchfrm',],  
        'options' => $this->Customers->find('list')->toArray(),
      ]);

      if (!empty($this->request->query)) {  
         $customername = $this->request->query['customername']; 
         $panno = $this->request->query['panno'];
       
         $customerid = $this->request->query['customerid'];          
         $datedform = $this->request->query['datedform'];
         $datedto = $this->request->query['datedto'];           
         
         if ($customername){ $conditions['conditions']['or']['Customers.name LIKE'] = "%$customername%"; }
         if ($panno){ $conditions['conditions']['or']['Customers.panno'] = "$panno"; }
         if ($customerid){ $conditions['conditions']['or']['Customers.id'] = "$customerid"; }   
          if ($datedform && $datedto){
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                     array('Customers.created >= ' => $datedform,
                                           'Customers.created <= ' => $datedto
                                          )
                         )));
            }

            if ($customername != '' || $panno != '' || $customerid != '' || ($datedform && $datedto)){ 
               $customers = $this->Customers->find('all', $conditions);
            }else{
               $customers = $this->Customers;                
            }    
            $this->paginate = [
               'contain' => ['Companies','Branches','Fds','Mutualfunds','Ncds','Ipos']
            ];
            
            
            $customers = $this->paginate($customers ,['order' => ['Customers.id' => 'DESC']]);
            //pr($customers);die; 
            $this->set(compact('customers','panno','customername','customerid','datedform','datedto'));
            $this->set('_serialize', ['customers']);
       
      }else{ 
       
         $customername = '';  
         $customerid = '';          
         $datedform = '';
         $datedto = ''; 
         $panno = '';
            $this->paginate = [
               'contain' => ['Companies','Branches','Fds','Mutualfunds','Ncds','Ipos']
            ];
            $customers = $this->paginate($this->Customers ,['order' => ['Customers.id' => 'DESC']]);
        
            $this->set(compact('customers','panno','customername','customerid','datedform','datedto'));
            $this->set('_serialize', ['customers']);
      } 
    }
        
    function customerdetailreports() {
   
         $this->autoRender = false;
         // $this->layout = false;        
         $fileName = "customerRports_".date("d-m-y:h:s").".xls";        
         $this->loadModel('Fds'); 
         $this->loadModel('Ncds');
         $this->loadModel('Mutualfunds');
         $this->loadModel('Ipos');
         $this->loadModel('Customers'); 
         $this->loadModel('Banks');
         $this->loadModel('Bankbranches'); 
         $this->loadModel('Searies'); 
         $this->loadModel('Investments'); 
         
        $this->Search->addFilter('customername', [
          'attributes'=>['placeholder'=>'Customer Name','label'=>'Customer Name :','class'=>'searchfrm',],
       ]);
       $this->Search->addFilter('panno', [
          'attributes'=>['placeholder'=>'Pan No','label'=>'Pan Number :','class'=>'searchfrm',],
       ]);
      $this->Search->addFilter('datedform', [
         'attributes'=>['placeholder'=>'Date From','label'=>'Date From :','class'=>'searchfrm',],
      ]);
      $this->Search->addFilter('datedto', [
         'attributes'=>['placeholder'=>'Date to','label'=>'Date to :','class'=>'searchfrm',],
      ]); 
     
      $this->Search->addFilter('customerid', [
        'attributes'=>['placeholder'=>'Customer Account','label'=>'Customer Account :','class'=>'searchfrm',],  
        'options' => $this->Customers->find('list')->toArray(),
      ]);

      if (!empty($this->request->query)) {  
         $customername = $this->request->query['customername']; 
         $panno = $this->request->query['panno'];
       
         $customerid = $this->request->query['customerid'];          
         $datedform = $this->request->query['datedform'];
         $datedto = $this->request->query['datedto'];           
         
         if ($customername){ $conditions['conditions']['or']['Customers.name LIKE'] = "%$customername%"; }
         if ($panno){ $conditions['conditions']['or']['Customers.panno'] = "$panno"; }
         if ($customerid){ $conditions['conditions']['or']['Customers.id'] = "$customerid"; }   
          if ($datedform && $datedto){
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                     array('Customers.created >= ' => $datedform,
                                           'Customers.created <= ' => $datedto
                                          )
                         )));
            }

            if ($customername != '' || $panno != '' || $customerid != '' || ($datedform && $datedto)){ 
               $customers = $this->Customers->find('all', $conditions);
            }else{
               $customers = $this->Customers;                
            }
      }   
            $this->paginate = [
               'contain' => ['Companies','Branches','Fds','Mutualfunds','Ncds','Ipos']
            ];
            
            
        $customers = $this->paginate($customers ,['order' => ['Customers.id' => 'DESC']]);
        $datafds = $customers->toArray(); 
       //pr($datafds);die;
        $headerRow = array("Account No","Customer Name", "Pan No",
             "Email","Address","City","State","Country","Phone No","Company","Company Branch");
        
         for($i=0; $i< count($datafds); $i++){
            $data[] = [$datafds[$i]->accountno,$datafds[$i]->name.' '.$datafds[$i]->lastname,$datafds[$i]->panno,
                       $datafds[$i]->email,$datafds[$i]->address,$datafds[$i]->City,$datafds[$i]->State,$datafds[$i]->Country,$datafds[$i]->phoneno,
                        $datafds[$i]->company->company,$datafds[$i]->branch->branchname];
            
         /*   $headerRow[$i] = array("Application No","Payment Option", "Amount");
            for($j=0; $j< count($datafds[$i]->ipos); $j++){
              $data[$i] = [$datafds[$j]->ipos->applicationno,$datafds[$j]->ipos->paymentoption,$datafds[$j]->ipos->amount];  
                
            } */
            
            
         }           
          $this->ExportXls->export($fileName, $headerRow, $data);
    }  
     public function companywiseproduct()
    {
         
     } 
     
    public function companywisemf(){
      $this->loadModel('Mutualfunds'); 
		$this->loadModel('Fds'); 
		$this->loadModel('Customers'); 
		$this->loadModel('Banks'); 
		$this->loadModel('Plans'); 
		$this->loadModel('Products');
		$this->loadModel('Companies');
		$all = array('all'=>'All');
	    $this->Search->addFilter('company', [
            'attributes'=>['placeholder'=>'Company Name','label'=>'Company Name :','class'=>'searchfrm','value' => isset($this->request->query['company'])?$this->request->query['company']:''],  
            'options' => $all+$this->Companies->find('list')-> where(['associatewith' => 'product'])->order(['company' => 'ASC'])->toArray(),           
        ]); 
        if($this->Auth->user('group_id')=='2'){ 
           $branch = $this->Fds->Branches->find('list')->toArray();
           
        $this->Search->addFilter('branch', [
            'attributes'=>['placeholder'=>'Branch Name','label'=>'Branch Name :','class'=>'searchfrm','value' => isset($this->request->query['branch'])?$this->request->query['branch']:''],  
            'options' => $all+$this->Fds->Branches->find('list')->toArray(),
        ]);
      }  
        
        $this->Search->addFilter('datedform', [
         'attributes'=>['placeholder'=>'Despatch Start Date','label'=>'Despatch Start Date :','class'=>'searchfrm','value' => isset($this->request->query['datedform'])?$this->request->query['datedform']:''],
        ]);
        $this->Search->addFilter('datedto', [
           'attributes'=>['placeholder'=>'Despatch End Date','label'=>'Despatch End Date :','class'=>'searchfrm','value' => isset($this->request->query['datedto'])?$this->request->query['datedto']:''],
        ]);
		
	 $conditions = ''; 
        if($this->Auth->user('group_id')=='3'){             
            $branch_id = $this->Auth->user('branch_id');     
            $conditions['conditions']['and']['Fds.posteduserbranchid'] = "$branch_id";
        }elseif($this->Auth->user('group_id')=='4' || $this->Auth->user('group_id')=='5' || $this->Auth->user('group_id')=='6' || $this->Auth->user('group_id')=='7'){ 
            $branch_id = $this->Auth->user('branch_id');    
            $userid = $this->Auth->user('id'); 
            $conditions['conditions']['and']['Fds.posteduserbranchid'] = "$branch_id";
            $conditions['conditions']['and']['Fds.postedby'] = "$userid";
        }
		$result = '';
		if (!empty($this->request->query) && count($this->request->query) > 1) { 
            $branch = ($this->request->query['branch'])? $this->request->query['branch'] : '';            
            $dated2 =  (($this->request->query['datedform'] != '')? $this->request->query['datedform'] : '');
		 $date_from = explode('/',$dated2);
         $datedform  = implode('-', array_reverse($date_from));
         
	   $dated1= (($this->request->query['datedto']!='')? $this->request->query['datedto']:'');
	   $date_to = explode('/',$dated1);
        $datedto  = implode('-', array_reverse($date_to));
            $company = ($this->request->query['company'])? $this->request->query['company'] : ''; 
        }    
		$connection = ConnectionManager::get('default');
		if(isset($branch) && isset($datedform) && isset($datedto) && isset($company)){
			if($branch == 'all' && $company == 'all'){
			   	$result['MF'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM mutualfunds WHERE despatchdate >= :fromdate AND despatchdate <= :todate',['fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
				$result['FD'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM fds WHERE despatchdate >= :fromdate AND despatchdate <= :todate',['fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
				$result['NCD'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM ncds WHERE despatchdate >= :fromdate AND despatchdate <= :todate',['fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
				$result['IPO'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM ipos WHERE despatchdate >= :fromdate AND despatchdate <= :todate',['fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
			}
			elseif($branch == 'all' && $company != 'all'){
				$result['MF'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM mutualfunds WHERE productcompanyid = :company AND despatchdate >= :fromdate AND despatchdate <= :todate',['company'=>$company, 'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
				$result['FD'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM fds WHERE productcompanyid = :company AND despatchdate >= :fromdate AND despatchdate <= :todate',['company'=>$company, 'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
				$result['NCD'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM ncds WHERE productcompanyid = :company AND despatchdate >= :fromdate AND despatchdate <= :todate',['company'=>$company, 'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
				$result['IPO'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM ipos WHERE productcompanyid = :company AND despatchdate >= :fromdate AND despatchdate <= :todate',['company'=>$company, 'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
			}
			elseif($branch != 'all' && $company == 'all'){
				$result['MF'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM mutualfunds WHERE branch_id = :branch AND despatchdate >= :fromdate AND despatchdate <= :todate',['branch'=>$branch, 'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
				$result['FD'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM fds WHERE branch_id = :branch AND despatchdate >= :fromdate AND despatchdate <= :todate',['branch'=>$branch, 'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
				$result['NCD'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM ncds WHERE branch_id = :branch AND despatchdate >= :fromdate AND despatchdate <= :todate',['branch'=>$branch, 'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
				$result['IPO'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM ipos WHERE branch_id = :branch AND despatchdate >= :fromdate AND despatchdate <= :todate',['branch'=>$branch, 'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
			}
			else{
				$result['MF'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM mutualfunds WHERE branch_id = :branch AND productcompanyid = :company AND despatchdate >= :fromdate AND despatchdate <= :todate',['branch'=>$branch, 'company'=>$company, 'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
				$result['FD'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM fds WHERE branch_id = :branch AND productcompanyid = :company AND despatchdate >= :fromdate AND despatchdate <= :todate',['branch'=>$branch, 'company'=>$company, 'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
				$result['NCD'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM ncds WHERE branch_id = :branch AND productcompanyid = :company AND despatchdate >= :fromdate AND despatchdate <= :todate',['branch'=>$branch, 'company'=>$company, 'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
				$result['IPO'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM ipos WHERE branch_id = :branch AND productcompanyid = :company AND despatchdate >= :fromdate AND despatchdate <= :todate',['branch'=>$branch, 'company'=>$company, 'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
			}
		}
		
		//$resultss = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM fds WHERE created BETWEEN 2017-06-01 00:00:00.000000 AND 2017-07-14 00:00:00.000000 ORDER BY id DESC')->fetchAll('assoc');
		//pr($result);
			$this->set(compact('result','company','branch','datedform','datedto','dated2','dated1'));
            $this->set('_serialize', ['result']);
		//die();
    }
    
	//Schemewise MF
	public function schemewisemf(){
		$this->loadModel('Mutualfunds'); 
		$this->loadModel('Fds'); 
		$this->loadModel('Customers'); 
		$this->loadModel('Banks'); 
		$this->loadModel('Plans'); 
		$this->loadModel('Products');
		$this->loadModel('Companies');
		$all = array('all'=>'All');
	    $this->Search->addFilter('company', [
            'attributes'=>['placeholder'=>'Company Name','label'=>'Company Name :','class'=>'searchfrm','value' => isset($this->request->query['company'])?$this->request->query['company']:''],  
            'options' => $this->Companies->find('list')-> where(['associatewith' => 'product'])->order(['company' => 'ASC'])->toArray(),           
        ]); 
		$this->Search->addFilter('scheme', [
        'attributes'=>['placeholder'=>'Scheme Name','label'=>'Scheme Name :','class'=>'searchfrm','value' => isset($this->request->query['scheme'])?$this->request->query['scheme']:''],  
        'options' => $all+$this->Mutualfunds->Mffunds->find('list')->toArray(),
      ]);
        if($this->Auth->user('group_id')=='2'){ 
           $branch = $this->Fds->Branches->find('list')->toArray();
           
			$this->Search->addFilter('branch', [
            'attributes'=>['placeholder'=>'Branch Name','label'=>'Branch Name :','class'=>'searchfrm','value' => isset($this->request->query['branch'])?$this->request->query['branch']:''],  
            'options' => $all+$this->Fds->Branches->find('list')->toArray(),
			]);
        }  
        
        $this->Search->addFilter('datedform', [
         'attributes'=>['placeholder'=>'Despatch Start Date','label'=>'Despatch Start Date :','class'=>'searchfrm','value' => isset($this->request->query['datedform'])?$this->request->query['datedform']:''],
        ]);
        $this->Search->addFilter('datedto', [
           'attributes'=>['placeholder'=>'Despatch End Date','label'=>'Despatch End Date :','class'=>'searchfrm','value' => isset($this->request->query['datedto'])?$this->request->query['datedto']:''],
        ]);
		
		$conditions = ''; 
        if($this->Auth->user('group_id')=='3'){             
            $branch_id = $this->Auth->user('branch_id');     
            $conditions['conditions']['and']['Fds.posteduserbranchid'] = "$branch_id";
        }elseif($this->Auth->user('group_id')=='4' || $this->Auth->user('group_id')=='5' || $this->Auth->user('group_id')=='6' || $this->Auth->user('group_id')=='7'){ 
            $branch_id = $this->Auth->user('branch_id');    
            $userid = $this->Auth->user('id'); 
            $conditions['conditions']['and']['Fds.posteduserbranchid'] = "$branch_id";
            $conditions['conditions']['and']['Fds.postedby'] = "$userid";
        }
		$result = '';
		if (!empty($this->request->query) && count($this->request->query) > 1) {  
            $branch = ($this->request->query['branch'])? $this->request->query['branch'] : '';            
            $dated2 =  (($this->request->query['datedform'] != '')? $this->request->query['datedform'] : '');
		    $date_from = explode('/',$dated2);
            $datedform  = implode('-', array_reverse($date_from));
			$dated1= (($this->request->query['datedto']!='')? $this->request->query['datedto']:'');
			$date_to = explode('/',$dated1);
			$datedto  = implode('-', array_reverse($date_to));
            $company = ($this->request->query['company'])? $this->request->query['company'] : '';
			$sscheme = $scheme = $this->request->query['scheme'];			
        }    
		$connection = ConnectionManager::get('default');
		if(isset($branch) && isset($datedform) && isset($datedto) && isset($company)){
			if($branch == 'all' && $scheme == 'all'){
			$result['MF'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount, mffund_id FROM mutualfunds WHERE  productcompanyid = :company AND despatchdate >= :fromdate AND despatchdate <= :todate GROUP BY mffund_id',['company'=>$company,'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
			}elseif($branch != 'all' && $scheme == 'all'){
			$result['MF'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount, mffund_id FROM mutualfunds WHERE  branch_id = :branch AND productcompanyid = :company AND despatchdate >= :fromdate AND despatchdate <= :todate GROUP BY mffund_id',['company'=>$company, 'branch'=>$branch, 'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
			}elseif($branch == 'all' && $scheme != 'all'){
			$result['MF'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount, mffund_id FROM mutualfunds WHERE mffund_id = :mffund AND productcompanyid = :company AND despatchdate >= :fromdate AND despatchdate <= :todate GROUP BY mffund_id',['mffund'=>$scheme, 'company'=>$company, 'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
			}else{
			$result['MF'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount, mffund_id FROM mutualfunds WHERE mffund_id = :mffund AND branch_id = :branch AND productcompanyid = :company AND despatchdate >= :fromdate AND despatchdate <= :todate GROUP BY mffund_id',['mffund'=>$scheme, 'company'=>$company, 'branch'=>$branch, 'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');	
			}
		}
			$this->set(compact('result','company','branch','datedform','datedto','dated2','dated1','scheme','sscheme'));
            $this->set('_serialize', ['result']);
		//die();
    }
    
    public function schemewiseuserlist(){
		$this->loadModel('Mutualfunds'); 
       $this->loadModel('Customers'); 
       $this->loadModel('Banks'); 
	   $all = array('all'=>'All'); 
   
       $this->Search->addFilter('company', [
        'attributes'=>['placeholder'=>'Company','label'=>'MutualFund :','class'=>'searchfrm', 'value' => isset($this->request->query['company'])?$this->request->query['company']:''],  
        'options' => $all+$this->Mutualfunds->Companies->find('list')-> where(['associatewith' => 'product'])->andWhere(['Companies.productid ='=>'1'] )->order(['company' => 'ASC'])->toArray(),
       ]);
	   
       $this->Search->addFilter('scheme', [
        'attributes'=>['placeholder'=>'Scheme Name','label'=>'Scheme Name :','class'=>'searchfrm','value' => isset($this->request->query['scheme'])?$this->request->query['scheme']:'',],  
        'options' => $all+$this->Mutualfunds->Mffunds->find('list')->order(['fundname' => 'ASC'])->group(['fundname'])->toArray(),
       ]);
       if($this->Auth->user('group_id')=='2'){ 
          $branch = $this->Mutualfunds->Branches->find('list')->toArray();
         
        $this->Search->addFilter('branch', [
        'attributes'=>['placeholder'=>'Branch Name','label'=>'Branch Name :','class'=>'searchfrm','value' => isset($this->request->query['branch'])?$this->request->query['branch']:'',],  
        'options' => $all+$this->Mutualfunds->Branches->find('list')->toArray(),
       ]);
       }  
       
      	$this->Search->addFilter('datedform', [
         'attributes'=>['placeholder'=>'Despatch From Date','label'=>'Despatch From Date :','class'=>'searchfrm','value' => isset($this->request->query['datedform'])?$this->request->query['datedform']:''],
        ]);
        $this->Search->addFilter('datedto', [
           'attributes'=>['placeholder'=>'Despatch To Date','label'=>'Despatch To Date :','class'=>'searchfrm','value' => isset($this->request->query['datedto'])?$this->request->query['datedto']:''],
        ]);
    
		$conditions = '';  
		if($this->Auth->user('group_id')=='3'){        
			$branch_id = $this->Auth->user('branch_id');     
			$conditions['conditions']['and']['Mutualfunds.posteduserbranchid'] = "$branch_id";
		}
       if (!empty($this->request->query) && count($this->request->query) > 1) { 
       
		 $branch = $this->request->query['branch'];
		 $company = $this->request->query['company']; 
		 $scheme = $this->request->query['scheme'];
      
         $dated2 =  (($this->request->query['datedform'] != '')? $this->request->query['datedform'] : '');
		 $date_from = explode('/',$dated2);
         $datedform  = implode('-', array_reverse($date_from));
         
	     $dated1= (($this->request->query['datedto']!='')? $this->request->query['datedto']:'');
	     $date_to = explode('/',$dated1);
         $datedto  = implode('-', array_reverse($date_to));         
            if ($datedform && $datedto){             
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                     array('Mutualfunds.despatchdate >= ' => $datedform,
                                       'Mutualfunds.despatchdate <= ' => $datedto
                                      )
                         )));
            }
		
		 if ($branch!='' && $branch!='all'){ $conditions['conditions']['and']['Mutualfunds.branch_id'] = "$branch"; }
         if ($company!='' && $company!='all'){ $conditions['conditions']['and']['Mutualfunds.productcompanyid'] = "$company"; }
		 if ($scheme!='' && $scheme!='all') { $conditions['conditions']['and']['Mutualfunds.mffund_id'] = "$scheme"; }
        
		   if ( ($company != '' && $company != 'all') || ($branch != '' &&  $branch != 'all') || ($scheme != '' && $scheme != 'all' ) || ($datedform && $datedto) ){ 
                $mf = $this->Mutualfunds->find('all', $conditions);
				  $cnt = $mf->count();              
                        if($mf){
                            $total_amount = 0;                   
                             foreach ($mf as $md){ 
                                $total_amount += $md->amount;
                             }
                        } 
            }
			elseif($company == 'all' || $branch == 'all' || $scheme == 'all' )
				  {
				   $mf = $this->Mutualfunds;
				   $mf1=$this->Mutualfunds->find('all',array('contain' => ['Companies', 'Branches', 'Mffunds','Brokers']));
			$cnt = $mf1->count();              
                        if($mf1){
                           $total_amount = 0;                   
                             foreach ($mf1 as $md){ 
                                    $total_amount += $md->amount;
                             }
                        } 
				  }
			else{  
                   if($conditions != ''){
				
                    $mf = $this->Mutualfunds->find('all', $conditions);
					$cnt = $mf->count();              
                        if($mutualfunds){
                            $total_amount = 0;                   
                             foreach ($mf as $md){ 
                                $total_amount += $md->amount;
                             }
                        } 
                  } 
				  
				  else{
				 
                    $mf = $this->Mutualfunds;
					$mf1=$this->Mutualfunds->find('all',array('contain' => ['Companies', 'Branches', 'Mffunds','Brokers']));
					$cnt = $mf1->count();              
                        if($mf1){
                           $total_amount = 0;                   
                             foreach ($mf1 as $md){ 
                                    $total_amount += $md->amount;
                             }
                        } 
                  }  
            }    
            //'Banks',
            $this->paginate = [
               'contain' => ['Companies', 'Branches','Brokers','Mffunds']
            ]; 
           // $mfs = $mf;
            
            $mf = $this->paginate($mf ,['order' => ['Mutualfunds.id' => 'DESC']]);
            $this->set(compact('mf','company','branch','scheme','datedform','datedto','total_amount','cnt','dated2','dated1'));
            $this->set('_serialize', ['mf']);
       
      }
	}
     public function companywisemfexcelreport(){   
        $this->autoRender = false;       
        $fileName = "companywisereportsmf_".date("d-m-y:h:s").".xls";  
        $this->loadModel('Mutualfunds');
        $this->loadModel('Customers'); 
        $this->loadModel('Banks'); 
        $this->loadModel('Plans'); 
        $this->loadModel('Products');
		$this->loadModel('Companies');
        $conditions = '';  
        if($this->Auth->user('group_id')=='3'){           
            $branch_id = $this->Auth->user('branch_id');     
            $conditions['conditions']['and']['Mutualfunds.posteduserbranchid'] = "$branch_id";
        }  
       
        $company = $this->request->query['company'];
        $branch = $this->request->query['branch'];   
        $datedform = $this->request->query['datedform'];
        $datedto = $this->request->query['datedto'];
         
            if ($datedform && $datedto){
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                     array('trim(Mutualfunds.despatchdate) >= ' => $datedform,
                                       'trim(Mutualfunds.despatchdate) <= ' => $datedto
                                      )
                         )));
            }
           if (($company !='') && ($company !='all')){ $conditions['conditions']['and']['Mutualfunds.productcompanyid'] = "$company"; }  
           if (($branch !='') && ($branch !='all')){  $conditions['conditions']['or']['Mutualfunds.branch_id'] = "$branch"; }
            
            if ($branch != ''  || ($datedform && $datedto)){ 
                 $mutualfunds = $this->Mutualfunds->find('all', $conditions);
            }else{                
                  if($conditions !=''){
                    $mutualfunds = $this->Mutualfunds->find('all', $conditions);
                  }else{
                     $mutualfunds = $this->Mutualfunds; 
                  } 
            }   
            
            //, 'Banks'
          $this->paginate = [
                 'contain' => ['Companies', 'Branches','Brokers', 'Mffunds']
            ];
        $mutualfunds = $this->paginate($mutualfunds ,['order' => ['Mutualfunds.branch_id' => 'ASC']]);
        $datafds = $mutualfunds->toArray(); 
       //pr($datafds);  
        
        $banks = TableRegistry::get('Banks');
     
        $headerRow = array("Sr.","Company", "Type of Deposit",'Name','Product','Scheme','Amount','Cheque No','Folio No','Application No','Bank Name');
        $j=1;
            for($i=0; $i< count($datafds); $i++){
                        if($datafds[$i]->bank_id > 0){
                            $banksid = $banks->find()->where(['id' => $datafds[$i]->bank_id]);
                            $data1 = $banksid->toArray();
                            $banksName = $data1[0]->banks;
                        }else{
                            $banksName = '';
                        }   
                $data[] = [$j,$datafds[$i]->company->company,$datafds[$i]->typeofdeposit,$datafds[$i]->firstapplicantname,"Mutual Fund",$datafds[$i]->mffund->fundname,$datafds[$i]->amount,$datafds[$i]->chequeno,$datafds[$i]->customerFolioNo,$datafds[$i]->applicationno,$banksName];
            $j++;
                } 
        $this->ExportXls->export($fileName, $headerRow, $data);
    }  
    
    public function csltdmoblztion(){
      $this->loadModel('Mutualfunds'); 
		$this->loadModel('Fds'); 
		$this->loadModel('Customers'); 
		$this->loadModel('Banks'); 
		$this->loadModel('Plans'); 
		$this->loadModel('Products');
		$this->loadModel('Companies');
		$all = array('all'=>'All');
	    $this->Search->addFilter('company', [
            'attributes'=>['placeholder'=>'Company Name','label'=>'Company Name :','class'=>'searchfrm','value' => isset($this->request->query['company'])?$this->request->query['company']:''],  
            'options' => $all+$this->Companies->find('list')-> where(['associatewith' => 'product'])->order(['company' => 'ASC'])->toArray(),           
        ]); 
        
        $this->Search->addFilter('datedform', [
         'attributes'=>['placeholder'=>'Despatch Start Date','label'=>'Despatch Start Date :','class'=>'searchfrm','value' => isset($this->request->query['datedform'])?$this->request->query['datedform']:''],
        ]);
        $this->Search->addFilter('datedto', [
           'attributes'=>['placeholder'=>'Despatch End Date','label'=>'Despatch End Date :','class'=>'searchfrm','value' => isset($this->request->query['datedto'])?$this->request->query['datedto']:''],
        ]);
		
	 $conditions = ''; 
 
		$result = '';
		if (!empty($this->request->query) && count($this->request->query) > 1) { 
                 
            $dated2 =  (($this->request->query['datedform'] != '')? $this->request->query['datedform'] : '');
		 $date_from = explode('/',$dated2);
         $datedform  = implode('-', array_reverse($date_from));
         
	   $dated1= (($this->request->query['datedto']!='')? $this->request->query['datedto']:'');
	   $date_to = explode('/',$dated1);
        $datedto  = implode('-', array_reverse($date_to));
            $company = ($this->request->query['company'])? $this->request->query['company'] : ''; 
        }    
		$connection = ConnectionManager::get('default');
		if(isset($datedform) && isset($datedto) && isset($company)){
			if($company == 'all'){
			   	$result['andheri']['MF'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM mutualfunds WHERE branch_id = :branch and despatchdate >= :fromdate AND despatchdate <= :todate',['branch'=> 2,'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
			   	$result['bandra']['MF'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM mutualfunds WHERE branch_id = :branch and despatchdate >= :fromdate AND despatchdate <= :todate',['branch'=> 6,'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
			   	$result['fort']['MF'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM mutualfunds WHERE branch_id = :branch and despatchdate >= :fromdate AND despatchdate <= :todate',['branch'=> 4,'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
				
				$result['andheri']['FD'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM fds WHERE branch_id = :branch and despatchdate >= :fromdate AND despatchdate <= :todate',['branch'=> 2,'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
				$result['bandra']['FD'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM fds WHERE branch_id = :branch and despatchdate >= :fromdate AND despatchdate <= :todate',['branch'=> 6,'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
				$result['fort']['FD'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM fds WHERE branch_id = :branch and despatchdate >= :fromdate AND despatchdate <= :todate',['branch'=> 4,'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
				
				$result['andheri']['NCD'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM ncds WHERE branch_id = :branch and despatchdate >= :fromdate AND despatchdate <= :todate',['branch'=> 2,'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
				$result['bandra']['NCD'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM ncds WHERE branch_id = :branch and despatchdate >= :fromdate AND despatchdate <= :todate',['branch'=> 6,'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
				$result['fort']['NCD'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM ncds WHERE branch_id = :branch and despatchdate >= :fromdate AND despatchdate <= :todate',['branch'=> 4,'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
				
				
				$result['andheri']['IPO'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM ipos WHERE branch_id = :branch and despatchdate >= :fromdate AND despatchdate <= :todate',['branch'=> 2,'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
				$result['bandra']['IPO']= $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM ipos WHERE branch_id = :branch and despatchdate >= :fromdate AND despatchdate <= :todate',['branch'=> 6,'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
				$result['fort']['IPO'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM ipos WHERE branch_id = :branch and despatchdate >= :fromdate AND despatchdate <= :todate',['branch'=> 4,'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
			}
			else{
			   	$result['andheri']['MF'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM mutualfunds WHERE productcompanyid = :company and branch_id = :branch and despatchdate >= :fromdate AND despatchdate <= :todate',['company'=>$company, 'branch'=> 2,'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
			   	$result['bandra']['MF'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM mutualfunds WHERE productcompanyid = :company and branch_id = :branch and despatchdate >= :fromdate AND despatchdate <= :todate',['company'=>$company, 'branch'=> 6,'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
			   	$result['fort']['MF'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM mutualfunds WHERE productcompanyid = :company and branch_id = :branch and despatchdate >= :fromdate AND despatchdate <= :todate',['company'=>$company, 'branch'=> 4,'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
				
				$result['andheri']['FD'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM fds WHERE productcompanyid = :company and branch_id = :branch and despatchdate >= :fromdate AND despatchdate <= :todate',['company'=>$company, 'branch'=> 2,'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
				$result['bandra']['FD'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM fds WHERE productcompanyid = :company and branch_id = :branch and despatchdate >= :fromdate AND despatchdate <= :todate',['company'=>$company, 'branch'=> 6,'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
				$result['fort']['FD'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM fds WHERE productcompanyid = :company and branch_id = :branch and despatchdate >= :fromdate AND despatchdate <= :todate',['company'=>$company, 'branch'=> 4,'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
				
				$result['andheri']['NCD'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM ncds WHERE productcompanyid = :company and branch_id = :branch and despatchdate >= :fromdate AND despatchdate <= :todate',['company'=>$company, 'branch'=> 2,'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
				$result['bandra']['NCD'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM ncds WHERE productcompanyid = :company and branch_id = :branch and despatchdate >= :fromdate AND despatchdate <= :todate',['company'=>$company, 'branch'=> 6,'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
				$result['fort']['NCD'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM ncds WHERE productcompanyid = :company and branch_id = :branch and despatchdate >= :fromdate AND despatchdate <= :todate',['company'=>$company, 'branch'=> 4,'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
				
				
				$result['andheri']['IPO'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM ipos WHERE productcompanyid = :company and branch_id = :branch and despatchdate >= :fromdate AND despatchdate <= :todate',['company'=>$company, 'branch'=> 2,'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
				$result['bandra']['IPO'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM ipos WHERE productcompanyid = :company and branch_id = :branch and despatchdate >= :fromdate AND despatchdate <= :todate',['company'=>$company, 'branch'=> 6,'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
				$result['fort']['IPO'] = $connection->execute('SELECT count(*) as cnumber,sum(amount) as tamount FROM ipos WHERE productcompanyid = :company and branch_id = :branch and despatchdate >= :fromdate AND despatchdate <= :todate',['company'=>$company, 'branch'=> 4,'fromdate'=>$datedform, 'todate'=>$datedto])->fetchAll('assoc');
			}
			
		}
	
			$this->set(compact('result','company','datedform','datedto','dated2','dated1'));
            $this->set('_serialize', ['result']);
    }
    
    public function switchrecdsmry(){
		$this->loadModel('Mutualfunds'); 
		$this->loadModel('Fds'); 
		$this->loadModel('Customers'); 
		$this->loadModel('Banks'); 
		$this->loadModel('Plans'); 
		$this->loadModel('Products');
		$this->loadModel('Companies');
		
		$conditions = ''; 
		$connection = ConnectionManager::get('default');
		$abranch =2;$bbranch =6;$fbranch =4;
		$swichall = 1;
		$result['andheri'] = $result['bandra'] = $result['fort']='';
		$result['andheri'] = $connection->execute('SELECT count(*) as cnumber,postedby FROM mutualfunds WHERE branch_id = :branch AND swichall = :swichall GROUP BY postedby', ['branch'=>$abranch, 'swichall'=>$swichall])->fetchAll('assoc');
		$result['bandra'] = $connection->execute('SELECT count(*) as cnumber,postedby FROM mutualfunds WHERE branch_id = :branch AND swichall = :swichall GROUP BY postedby', ['branch'=>$bbranch, 'swichall'=>$swichall])->fetchAll('assoc');
		$result['fort'] = $connection->execute('SELECT count(*) as cnumber,postedby FROM mutualfunds WHERE branch_id = :branch AND swichall = :swichall GROUP BY postedby', ['branch'=>$fbranch, 'swichall'=>$swichall])->fetchAll('assoc');
		$this->set(compact('result'));
        $this->set('_serialize', ['result']);
		//die();
    }
    
    public function userreport(){
      $this->loadModel('fds'); 
      $this->loadModel('ncds'); 
      $this->loadModel('ipos'); 
      $this->loadModel('Mutualfunds');    
      $this->loadModel('Customers'); 
      $this->loadModel('Banks'); 
      $this->loadModel('Plans'); 
      $this->loadModel('Products');
        
       $this->Search->addFilter('customer', [
            'attributes'=>['placeholder'=>'Customer Name','label'=>'Customer Name :','class'=>'searchfrm','value' => isset($this->request->query['customer'])?$this->request->query['customer']:''],  
            'options' => $this->Customers->find('list',['keyField' => 'id','valueField' => 'name'])->order(['Customers.name'=>'ASC'])->toArray(),           
        ]); 
        $this->Search->addFilter('cpanno', [
         'attributes'=>['placeholder'=>'Pan No','label'=>'Pan No :','class'=>'searchfrm','value' => isset($this->request->query['cpanno'])?$this->request->query['cpanno']:''],
        ]);
        
        if (!empty($this->request->query)) {         
           
           $customer = $this->request->query['customer'];
           
           $panno = (($this->request->query['cpanno'] != '')? $this->request->query['cpanno'] : '');
           if($panno !=''){
                $custmoerId = $this->getCustomerId($panno);
                if($custmoerId != ''){
                     $customer = $custmoerId;
                }
           }
            if($customer !=''){  
               $customer = $this->Customers->get($customer, [
                    'contain' => ['Mutualfunds','Fds','Ncds','Ipos']
                ]);
               //$this->set(compact('customer','panno'));
                $this->set('customer', $customer);
               // $this->set('panno', $panno);
                $this->set('_serialize', ['customer']);

            }else{
                $customer = array();
                $this->set('customer', $customer);
                $this->set('_serialize', ['customer']);
            }
        }else{
                $customer = array();
                $this->set('customer', $customer);
                $this->set('_serialize', ['customer']);
        }
    }   /* *add new controller like pin,city,sr,mobile for report
	    */
         public function pin(){
			  $this->loadModel('Customers');   
	  $this->Search->addFilter('pincode',['attributes'=>['placeholder'=>'Enter Pincode','label'=>'Pincode','class'=>'serachfrm','value'=>isset($this->request->query['pincode'])?$this->request->query['pincode']:''],]);
	   if(!empty($this->request->query['pincode'])){
		   $query=$this->request->query['pincode'];
		   
		   if($query){
			   
			   $conditions['conditions']['and']['Customers.pincode'] ="$query";
		   }
		   if($query!=''){
			   
			   $pincode=$this->Customers->find('All',$conditions);
			   
			   
			   
		   }else{
			   $pincode=$this->Customers;
		      
	   }
	   
	   $pincode=$this->paginate($pincode);
	   $this->set(compact('pincode'));
	   $this->set('_serialize','pincode');//pr($pincode);
	   
	   }
  
else{ 

	 $pincode = $this->paginate($this->Customers,['order' =>['Customers.pincode'=>'ASC']]);

        $this->set(compact('pincode'));
        $this->set('_serialize', ['pincode']);
	
}  
}

      public function mobile(){
	  $this->loadModel('Customers');
	   $this->Search->addFilter('mobile',['attributes'=> ['placeholder' => 'Customer mobile','label'=>'Mobile No','class'=>'serachfrm','value'=>isset($this->request->query['mobile'])? $this->request->query['mobile']:''],]);
	   
	   if(!empty($this->request->query)){
		   $mobile = $this->request->query['mobile'];
		   if($mobile){
			   $conditions['conditions']['and']['Customers.mobile'] = "$mobile";
			   
			   
		   }
		   if($mobile!=''){
			   $mobno=$this->Customers->find('all',$conditions,['conditions'=>['Customers.status'=>1]]);
			   $mobno=$this->paginate($mobno);
			   
		   }else{
			   $mobno=$this->Customers;
			   $mobno=$this->paginate($mobno,['order' =>['Customers.mobile'=>'ASC',['conditions'=>['Customers.status'=>1]]]]);
			   
		   }
		   $this->set(compact('mobno'));
		   $this->set('_serialize','mobno');
	   }
		else{
			 $mobno = $this->paginate($this->Customers,['order' =>['Customers.mobile'=>'ASC','conditions'=>['Customers.status'=>1]]]);

        $this->set(compact('mobno'));
        $this->set('_serialize', ['mobno']);
			
		}
		
  }
       public function sr(){
		   
		  $this->loadModel('Customers');
		   //$all = array('all'=>'All');
		   $this->Search->addFilter('id', ['attributes'=>['placeholder'=>'Customer id','label'=>'Customer Srno. :','class'=>'searchfrm','value'=>isset($this->request->query['id'])? $this->request->query['id']:''],]);  
        
	    if(!empty($this->request->query)){
			$id = $this->request->query['id'];
			if($id){
				$conditions['conditions']['and']['Customers.id'] ="$id";
				
			}
			if($id!='' &&$id!='All')
			{
				$srno = $this->Customers->find('all',$conditions);
				$srno = $this->paginate($srno);
			}else{
				$srno = $this->Customers;
				$srno = $this->paginate($srno,['order' =>['Customers.id'=>'ASC']]);
			}
		
			//debug($srno);
			$this->set(compact('srno'));
			$this->set('_serialize', ['srno']);	
		}
		else
	  {
	  
        $srno = $this->paginate($this->Customers,['order' =>['Customers.id'=>'ASC']]);

        $this->set(compact('srno'));
        $this->set('_serialize', ['srno']);
	  
	  }
	   }
  public function city(){
	  $this->loadModel('Customers');
	  $this->Search->addFilter('city',['attributes'=>['placeholder'=>'Enter City','label'=>'City','class'=>'serachfrm','value'=>isset($this->request->query['city'])?$this->request->query['city']:''],]);
	   if(!empty($this->request->query)){
		   $query=$this->request->query['city'];
		   if($query){
			   $conditions['conditions']['and']['Customers.city'] ="$query";
		   }
		   if($query!=''){
			   $city=$this->Customers->find('all',$conditions);
		   }else{
			   $city=$this->Customers;
	   }
	   $city=$this->paginate($city);
	   $this->set(compact('city'));
	   $this->set('_serialize','city');
	   }
else{
	 $city = $this->paginate($this->Customers,['order' =>['Customers.city'=>'ASC'],'conditions'=>['Customers.status'=>1]]);
    $this->set(compact('city'));
    $this->set('_serialize', ['city']);
	
}  
}

}
?>