<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;
/**
 * Ncds Controller
 *
 * @property \App\Model\Table\NcdsTable $Ncds
 */
class NcdsController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {    
  $this->Search->addFilter('fapplicantname', [
          'attributes'=>['placeholder'=>'Applicant Name','label'=>'Applicant Name :','class'=>'searchfrm','value' => isset($this->request->query['name'])?$this->request->query['name']:''], 'options' => $this->Ncds->Customers->find('list',['keyField' => 'name','valueField' => 'name'])->order(['Customers.name'=>'ASC'])->group(['Customers.name'])->toArray(),
       ]);
		$this->Search->addFilter('datedform', [
         'attributes'=>['placeholder'=>'Start Date','label'=>'Start Date :','class'=>'searchfrm','value' => isset($this->request->query['datedform'])?$this->request->query['datedform']:''],
        ]);
        $this->Search->addFilter('datedto', [
           'attributes'=>['placeholder'=>'End Date','label'=>'End Date :','class'=>'searchfrm','value' => isset($this->request->query['datedto'])?$this->request->query['datedto']:''],
        ]);
    
         $conditions = '';  
        if($this->Auth->user('group_id')=='3'){        
            $branch_id = $this->Auth->user('branch_id');     
            $conditions['conditions']['and']['Ncds.posteduserbranchid'] = "$branch_id";
        }elseif($this->Auth->user('group_id')=='4' || $this->Auth->user('group_id')=='5' || $this->Auth->user('group_id')=='6' || $this->Auth->user('group_id')=='7'){ 
            $branch_id = $this->Auth->user('branch_id');    
            $userid = $this->Auth->user('id'); 
            $conditions['conditions']['and']['Ncds.posteduserbranchid'] = "$branch_id";
            $conditions['conditions']['and']['Ncds.postedby'] = "$userid";
        }    
      
      
// if (!empty($this->request->query)) { 
        	 if((!empty($this->request->query['fapplicantname']))||(!empty($this->request->query['datedform'])) ||(!empty($this->request->query['datedto'])) ){ 
         $fapplicantname = $this->request->query['fapplicantname'];       
         $dated2 =  (($this->request->query['datedform'] != '')? $this->request->query['datedform'] : '');
		 $date_from = explode('/',$dated2);
         $datedform  = implode('-', array_reverse($date_from));
         
	   $dated1= (($this->request->query['datedto']!='')? $this->request->query['datedto']:'');
	   $date_to = explode('/',$dated1);
        $datedto  = implode('-', array_reverse($date_to));
         
		  if ($datedform && $datedto){
		      if($datedform == $datedto){
                $adt = new \DateTime($datedto);
                $adt->modify('+1 day');
                $datedto = $adt->format('Y-m-d');        
            }
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                    array('Ncds.created >= ' => $datedform,
                                       'Ncds.created <= ' => $datedto
                                      )
                         )));
            }
            if ($fapplicantname){ $conditions['conditions']['or']['Ncds.firstapplicantname LIKE'] = "%$fapplicantname%"; }
            if (( $fapplicantname != '')  || ($datedform && $datedto)){ 
               $ncds = $this->Ncds->find('all', $conditions);
            }else{
               $ncds = $this->Ncds;
            }    
            $this->paginate = [
               'contain' => ['Companies', 'Branches','Brokers']
            ]; 
            $fds = $this->paginate($ncds ,['order' => ['ncds.id' => 'DESC']]);
            $this->set(compact('ncds'));
            $this->set('_serialize', ['ncds']);
       
      }else{
//'Companies','Branches', 'Banks','Users'
        $this->paginate = [
            'contain' => ['Companies','Branches', 'Banks','Brokers']
        ];
        $conditions['conditions']['or']['DATE(Ncds.created) = '] = date('Y-m-d'); 
        $ncds = $this->Ncds->find('all', $conditions);
        $ncds = $this->paginate($ncds,['order' => ['Ncds.id' => 'DESC']]);

        $this->set(compact('ncds'));
        $this->set('_serialize', ['ncds']);
}
    }

    /**
     * View method
     *
     * @param string|null $id Ncd id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $ncd = $this->Ncds->get($id, [
            'contain' => ['Companies','Branches', 'Banks','Brokers']
        ]);

        
		$companies = TableRegistry::get('Companies');
		$branches = TableRegistry::get('Branches');
		$plans = TableRegistry::get('Plans');
		$banks = TableRegistry::get('Banks');
		$users = TableRegistry::get('Users');
		$brokers = TableRegistry::get('Brokers');
		 if($ncd->productcompanyid > 0) {
			$productcompanyid = $companies->find()->where(['id' => $ncd->productcompanyid]);
			$data1 = $productcompanyid->toArray();
			$productcompanyName = $data1[0]->company;
			}
			else{
			$productcompanyName = '';
			}
			$this->set('productcompanyName',$productcompanyName);
			
		if($ncd->mainbrokerid > 0) {
			$mainbrokerid = $brokers->find()->where(['id' => $ncd->mainbrokerid]);
			$data1 = $mainbrokerid->toArray();
			$mainbrokerName = $data1[0]->name;
			//pr()
			}
			else{
			$mainbrokerName = '';
			}
			$this->set('mainbrokerName',$mainbrokerName);	
		if($ncd->plan_id > 0) 
		{
			$planid = $plans->find()->where(['id' => $ncd->plan_id]);
			$data2 = $planid->toArray();
			$planname = $data2[0]->Planname;
		}
		else{
		$planname = '';
		}
		$this->set('planname',$planname);
		//pr($ncd->bank_id);
		//die();
		if($ncd->bank_id > 0)
		{
			$bank_id = $banks->find()->where(['id' => $ncd->bank_id]);
			$data3 = $bank_id->toArray();
			$bankname = $data3[0]->banks;
		}
		else{
		$bankname = '';
		}
		$this->set('bankname',$bankname);
		//pr($fd->posteduserbranchid);
		//die();
		if($ncd->posteduserbranchid > 0) {
			$posteduserbranchid = $branches->find()->where(['id' => $ncd->posteduserbranchid]);
			$data4 = $posteduserbranchid->toArray();
			$branchname = $data4[0]->branchname;
		}
		else
		{
			$branchname = '';
		}
		$this->set('branchname', $branchname);
		 if($ncd->postedby > 0){
            $postedby = $users->find()->where(['id' => $ncd->postedby]);
            $data11 = $postedby->toArray();
            $userName = $data11[0]->username;
       }else{
           $userName = '';
       }    
            $this->set('userName', $userName);
       
        //$fd = $this->Fds->get($id);
        $this->set('ncd', $ncd);
        $this->set('_serialize', ['ncd']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        
        if ($this->request->is('ajax','get')) {         
            $terms = $this->Ncds->Customers->find('all', [
                'conditions' => array('Customers.name LIKE ' => '%' . $this->request->query["term"] . '%'),
                'limit' => 10
            ]);
          
            $data = array();$data1 = array();
            foreach($terms as $term) {
                $row = $term->name;
                array_push($data, $row);
            }
            $this->autoRender = false;      
            // $this->layout = 'ajax';
            $this->set('terms', $terms);
            echo json_encode($data);
            exit;
            //return json_encode($data);
         }else {
            //echo json_encode('Nothings found');
         }
         
         
        $ncd = $this->Ncds->newEntity();
        if ($this->request->is('post')) {
            $ncd = $this->Ncds->patchEntity($ncd, $this->request->data);
            $ncd->postedby = $this->Auth->user('id');
            $ncd->posteduserbranchid = $this->Auth->user('branch_id');
          //  $ncd->branch_id = $this->Auth->user('branch_id');
            if($ncd->subbroker_id != ''){
                $ncd->broker_id = $ncd->subbroker_id;
            }else{
                $ncd->broker_id = 1;
            }
             $custmoerId = $this->getCustomerId($ncd->panno);
           if($custmoerId != ''){
                $ncd->customer_id = $custmoerId;
            }
            if ($this->Ncds->save($ncd)) {
                $this->Flash->success(__('The ncd has been saved.'));
                  return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The ncd could not be saved. Please, try again.'));
            }
        }
        $users = $this->Ncds->Customers->find('list', ['limit' => 200]); 
        $subbrokers = $this->Ncds->Brokers->find('list', [
            'keyField' => 'id',
            'valueField' => 'name'
        ])-> where(['role' => 'Subbroker']);
        $mainbrokers = $this->Ncds->Brokers->find('list', [
            'keyField' => 'id',
            'valueField' => 'name'
        ])-> where(['role' => 'Mainbroker']);
        $usercompanies = $this->Ncds->Companies->find('list')-> where(['associatewith' => 'user'])->order(['company' => 'ASC']);
	$userbranches = $this->Ncds->Branches->find('list', ['limit' => 200])->order(['branchname' => 'ASC']);
        //$productcompanies = $this->Ncds->Companies->find('list')-> where(['associatewith' => 'product'])->order(['company' => 'ASC']);
         $productcompanies = $this->Ncds->Companies->find('list')-> where(['associatewith' => 'product'])->where(['productid LIKE' => '%5%'])->order(['company' => 'ASC']);
        $typeofdeposit = array('fresh'=>'Fresh','renewal'=>'Renewal','both'=>'Both');
        $tenure = array('12'=>'12 Month','24'=>'24 Month','36'=>'36 Month','48'=>'48 Month','60'=>'60 Month','72'=>'72 Month');
      
        $banks = $this->Ncds->Banks->find('list', ['limit' => 200])->order(['banks' => 'ASC']);
       // $plans = $this->Ncds->Plans->find('list')-> where(['product_id' => 5])->order(['planname' => 'ASC']);
        $this->set(compact('ncd', 'users','mainbrokers', 'subbrokers','typeofdeposit','tenure','usercompanies', 'userbranches', 'productcompanies', 'banks','bankbranchs'));
        $this->set('_serialize', ['ncd']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Ncd id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        if ($this->request->is('ajax','get')) {         
            $terms = $this->Ncds->Customers->find('all', [
                'conditions' => array('Customers.name LIKE ' => '%' . $this->request->query["term"] . '%'),
                'limit' => 10
            ]);
          
            $data = array();$data1 = array();
            foreach($terms as $term) {
                $row = $term->name;
                array_push($data, $row);
            }
            $this->autoRender = false;      
            // $this->layout = 'ajax';
            $this->set('terms', $terms);
            echo json_encode($data);
            exit;
            //return json_encode($data);
         }else {
            //echo json_encode('Nothings found');
         }
         
         
        $ncd = $this->Ncds->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $ncd = $this->Ncds->patchEntity($ncd, $this->request->data);
            $ncd->postedby = $this->Auth->user('id');
            $ncd->posteduserbranchid = $this->Auth->user('branch_id');
          //  $ncd->branch_id = $this->Auth->user('branch_id');
            if($ncd->subbroker_id != ''){
                $ncd->broker_id = $ncd->subbroker_id;
            }else{
                $ncd->broker_id = 1;
            }
             $custmoerId = $this->getCustomerId($ncd->panno);
           if($custmoerId != ''){
                $ncd->customer_id = $custmoerId;
            }
            if ($this->Ncds->save($ncd)) {
                $this->Flash->success(__('The ncd has been saved.'));

                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The ncd could not be saved. Please, try again.'));
            }
        }
        $users = $this->Ncds->Customers->find('list', ['limit' => 200]);
        $subbrokers = $this->Ncds->Brokers->find('list', [
            'keyField' => 'id',
            'valueField' => 'name'
        ])-> where(['role' => 'Subbroker']);
        $mainbrokers = $this->Ncds->Brokers->find('list', [
            'keyField' => 'id',
            'valueField' => 'name'
        ])-> where(['role' => 'Mainbroker']);
        $usercompanies = $this->Ncds->Companies->find('list')-> where(['associatewith' => 'user'])->order(['company' => 'ASC']);
	$userbranches = $this->Ncds->Branches->find('list', ['limit' => 200])->order(['branchname' => 'ASC']);
        //$productcompanies = $this->Ncds->Companies->find('list')-> where(['associatewith' => 'product'])->order(['company' => 'ASC']);
         $productcompanies = $this->Ncds->Companies->find('list')-> where(['associatewith' => 'product'])->where(['productid LIKE' => '%5%'])->order(['company' => 'ASC']);
        $banks = $this->Ncds->Banks->find('list', ['limit' => 200])->order(['banks' => 'ASC']);
        $typeofdeposit = array('fresh'=>'Fresh','renewal'=>'Renewal','both'=>'Both');
        $tenure = array('12'=>'12 Month','24'=>'24 Month','36'=>'36 Month','48'=>'48 Month','60'=>'60 Month','72'=>'72 Month');
       // $plans = $this->Ncds->Plans->find('list')-> where(['product_id' => 5])->order(['planname' => 'ASC']);
         
        $this->set(compact('ncd', 'users','mainbrokers', 'subbrokers', 'usercompanies','typeofdeposit','tenure', 'userbranches', 'productcompanies', 'banks','bankbranchs'));
        $this->set('_serialize', ['ncd']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Ncd id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $ncd = $this->Ncds->get($id);
        if ($this->Ncds->delete($ncd)) {
            $this->Flash->success(__('The ncd has been deleted.'));
        } else {
            $this->Flash->error(__('The ncd could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
	
	public function fdsupdate(){
		$this->loadModel('Fds');
		$all = array('all'=>'All');    
   
		if($this->Auth->user('group_id')=='2'){ 
            $branch = $this->Fds->Branches->find('list')->toArray();
			$this->Search->addFilter('branch', [
				'attributes'=>['placeholder'=>'Branch Name','label'=>'Branch Name :','class'=>'searchfrm','value' => isset($this->request->query['branch'])?$this->request->query['branch']:''],  
				'options' => $all+$this->Fds->Branches->find('list')->toArray(),
			]);
		}
		$this->Search->addFilter('fapplicantname', [
          'attributes'=>['placeholder'=>'Applicant Name','label'=>'Applicant Name :','class'=>'searchfrm','value' => isset($this->request->query['fapplicantname'])?$this->request->query['fapplicantname']:''], 'options' => $this->Fds->Customers->find('list',['keyField' => 'name','valueField' => 'name'])->order(['Customers.name'=>'ASC'])->group(['Customers.name'])->toArray(),
       ]);
		$this->Search->addFilter('datedform', [
         'attributes'=>['placeholder'=>'Start Date','label'=>'Start Date :','class'=>'searchfrm','value' => isset($this->request->query['datedform'])?$this->request->query['datedform']:''],
        ]);
        $this->Search->addFilter('datedto', [
           'attributes'=>['placeholder'=>'End Date','label'=>'End Date :','class'=>'searchfrm','value' => isset($this->request->query['datedto'])?$this->request->query['datedto']:''],
        ]);
    
         $conditions = '';  
        if($this->Auth->user('group_id')=='3'){        
            $branch_id = $this->Auth->user('branch_id');     
            $conditions['conditions']['and']['Fds.posteduserbranchid'] = "$branch_id";
         }elseif($this->Auth->user('group_id')=='4' || $this->Auth->user('group_id')=='5' || $this->Auth->user('group_id')=='6' || $this->Auth->user('group_id')=='7'){ 
            $branch_id = $this->Auth->user('branch_id');    
            $userid = $this->Auth->user('id'); 
            $conditions['conditions']['and']['Fds.posteduserbranchid'] = "$branch_id";
            $conditions['conditions']['and']['Fds.postedby'] = "$userid";
        }   
     
		// if (!empty($this->request->query)) { 
        	 if((!empty($this->request->query['fapplicantname']))||(!empty($this->request->query['datedform'])) ||(!empty($this->request->query['datedto'])) ){ 
			 
			 if($this->Auth->user('group_id')=='2'){
			   if(!empty($this->request->query['branch'])){
              $branch = (($this->request->query['branch'] != '')? $this->request->query['branch'] : '');
			   }else{
				$branch = '';   
			   }			  
             } 

        $fapplicantname = $this->request->query['fapplicantname'];       
        
		$dated2 =  (($this->request->query['datedform'] != '')? $this->request->query['datedform'] : '');
	    $date_from = explode('/',$dated2);
        $datedform  = implode('-', array_reverse($date_from));
	
		$dated1= (($this->request->query['datedto'] != '')? $this->request->query['datedto']:'');
		$date_to = explode('/',$dated1);
        $datedto  = implode('-', array_reverse($date_to));
        
		if ($datedform && $datedto){
	         if($datedform == $datedto){
                $adt = new \DateTime($datedto);
                $adt->modify('+1 day');
                $datedto = $adt->format('Y-m-d');        
            }
                 $conditions = array(
        'conditions' => array(
        'and' => array(
                        array('Fds.created >= ' => $datedform,
                              'Fds.created <= ' => $datedto
                             ))));
            } 
			if (($branch !='') && ($branch !='all')){ $conditions['conditions']['and']['Fds.branch_id'] = "$branch"; }
			if ($fapplicantname){ $conditions['conditions']['or']['Fds.fapplicantname'] = "$fapplicantname"; }
		    if (( $fapplicantname != '')  || ($datedform && $datedto)){ 
               $fds = $this->Fds->find('all', $conditions);
					$cnt = $fds->count();              
					if($fds){
						$total_amount = 0;                   
						 foreach ($fds as $fd){ 
							$total_amount += $fd->amount;
						 }
					} 
			   
            }else{
               $fds = $this->Fds;
			   $cnt = $fds->count();
				if($fds) {
					$total_amount = 0;
					foreach ($fds as $fd) {
						$total_amount += $fd->amount;
					}
				}
            }    
            $this->paginate = [
               'contain' => ['Companies', 'Branches','Brokers']
            ]; 
            $fds = $this->paginate($fds ,['order' => ['Fds.id' => 'DESC']]);
            $this->set(compact('fds','total_amount','cnt'));
            $this->set('_serialize', ['fds']);
       
		}else{          
		// 'contain' => ['Companies', 'Branches','Brokers', 'Plans', 'Banks']
			$this->paginate = [
            'contain' => ['Companies', 'Branches','Brokers']
			];
        $conditions['conditions']['or']['DATE(Fds.created) > '] = date('Y-m-d');
        $fds = $this->Fds->find('all', $conditions);
		$cnt = $fds->count();              
		if($fds){
			$total_amount = 0;                   
			 foreach ($fds as $fd){ 
				$total_amount += $fd->amount;
			 }
		} 	  
        $fds = $this->paginate($fds,['order' => ['Fds.id' => 'DESC']]);
        $this->set(compact('fds','total_amount','cnt'));
        $this->set('_serialize', ['fds']);
      }      
	}
    public function getuserinfo(){
       $id = $this->request->query('id');
        if (!$id) {
                throw new NotFoundException();
        }
        $query = $this->Ncds->Customers->find('all',['conditions' => array('Customers.name LIKE ' => '%' . $id . '%')]);          
        $data = $query->toArray();       
        $this->set(compact('data')); 
                
    }

    public function getbankinfo(){
        $id = $this->request->query('id');
        if (!$id) {
            throw new NotFoundException();
        }   
        $databank = $this->Ncds->Bankbranches->find('all',['conditions' => ['id' => $id]]); 
        $this->set(compact('databank')); 
    }
    public function getbankbranchinfo(){
        $id = $this->request->query('id');
        if (!$id) {
            throw new NotFoundException();
        }   
        $queryncd = $this->Ncds->Bankbranches->find('all',['conditions' => ['id' => $id]]); 
        $databranch = $queryncd->toArray();       
        $this->set(compact('databranch')); 
    }
     public function getplan(){
        $id = $this->request->query('id');
        if (!$id) {
            throw new NotFoundException();
        }   
        $dataplan = $this->Ncds->Plans->find('all',['conditions' => ['company_id' => $id, 'product_id' => '5']]); 
        $this->set(compact('dataplan')); 
    }
}
