<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;
/**
 * Fds Controller
 *
 * @property \App\Model\Table\FdsTable $Fds
 */
class FdsController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index(){
	 $all = array('all'=>'All');    
   
      if($this->Auth->user('group_id')=='2'){ 
            $branch = $this->Fds->Branches->find('list')->toArray();
			$this->Search->addFilter('branch', [
				'attributes'=>['placeholder'=>'Branch Name','label'=>'Branch Name :','class'=>'searchfrm','value' => isset($this->request->query['branch'])?$this->request->query['branch']:''],  
				'options' => $all+$this->Fds->Branches->find('list')->toArray(),
			]);
      }
     $this->Search->addFilter('fapplicantname', [
          'attributes'=>['placeholder'=>'Applicant Name','label'=>'Applicant Name :','class'=>'searchfrm','value' => isset($this->request->query['fapplicantname'])?$this->request->query['fapplicantname']:''], 'options' => $this->Fds->Customers->find('list',['keyField' => 'name','valueField' => 'name'])->order(['Customers.name'=>'ASC'])->group(['Customers.name'])->toArray(),
       ]);
		$this->Search->addFilter('datedform', [
         'attributes'=>['placeholder'=>'Start Date','label'=>'Start Date :','class'=>'searchfrm','value' => isset($this->request->query['datedform'])?$this->request->query['datedform']:''],
        ]);
        $this->Search->addFilter('datedto', [
           'attributes'=>['placeholder'=>'End Date','label'=>'End Date :','class'=>'searchfrm','value' => isset($this->request->query['datedto'])?$this->request->query['datedto']:''],
        ]);
    
         $conditions = '';  
        if($this->Auth->user('group_id')=='3'){        
            $branch_id = $this->Auth->user('branch_id');     
            $conditions['conditions']['and']['Fds.posteduserbranchid'] = "$branch_id";
         }elseif($this->Auth->user('group_id')=='4' || $this->Auth->user('group_id')=='5' || $this->Auth->user('group_id')=='6' || $this->Auth->user('group_id')=='7'){ 
            $branch_id = $this->Auth->user('branch_id');    
            $userid = $this->Auth->user('id'); 
            $conditions['conditions']['and']['Fds.posteduserbranchid'] = "$branch_id";
            $conditions['conditions']['and']['Fds.postedby'] = "$userid";
        }   
     
     // if (!empty($this->request->query)) { 
        	 if((!empty($this->request->query['fapplicantname']))||(!empty($this->request->query['datedform'])) ||(!empty($this->request->query['datedto'])) ){ 
			 
			 if($this->Auth->user('group_id')=='2'){
			   if(!empty($this->request->query['branch'])){
              $branch = (($this->request->query['branch'] != '')? $this->request->query['branch'] : '');
			   }else{
				$branch = '';   
			   }			  
             } 

         $fapplicantname = $this->request->query['fapplicantname'];       
        
       $dated2 =  (($this->request->query['datedform'] != '')? $this->request->query['datedform'] : '');
	    $date_from = explode('/',$dated2);
        $datedform  = implode('-', array_reverse($date_from));
	
		$dated1= (($this->request->query['datedto'] != '')? $this->request->query['datedto']:'');
		$date_to = explode('/',$dated1);
        $datedto  = implode('-', array_reverse($date_to));
        
	   if ($datedform && $datedto){
	         if($datedform == $datedto){
                $adt = new \DateTime($datedto);
                $adt->modify('+1 day');
                $datedto = $adt->format('Y-m-d');        
            }
                 $conditions = array(
        'conditions' => array(
        'and' => array(
                        array('Fds.created >= ' => $datedform,
                              'Fds.created <= ' => $datedto
                             ))));
            } 
			if (($branch !='') && ($branch !='all')){ $conditions['conditions']['and']['Fds.branch_id'] = "$branch"; }
         if ($fapplicantname){ $conditions['conditions']['or']['Fds.fapplicantname'] = "$fapplicantname"; }
		    if (( $fapplicantname != '')  || ($datedform && $datedto)){ 
               $fds = $this->Fds->find('all', $conditions);
					$cnt = $fds->count();              
					if($fds){
						$total_amount = 0;                   
						 foreach ($fds as $fd){ 
							$total_amount += $fd->amount;
						 }
					} 
			   
            }else{
               $fds = $this->Fds;
			   $cnt = $fds->count();
				if($fds) {
					$total_amount = 0;
					foreach ($fds as $fd) {
						$total_amount += $fd->amount;
					}
				}
            }    
            $this->paginate = [
               'contain' => ['Companies', 'Branches','Brokers']
            ]; 
            $fds = $this->paginate($fds ,['order' => ['Fds.id' => 'DESC']]);
            $this->set(compact('fds','total_amount','cnt'));
            $this->set('_serialize', ['fds']);
       
      }else{          
       // 'contain' => ['Companies', 'Branches','Brokers', 'Plans', 'Banks']
        $this->paginate = [
            'contain' => ['Companies', 'Branches','Brokers']
        ];
        $conditions['conditions']['or']['DATE(Fds.created) = '] = date('Y-m-d');
        $fds = $this->Fds->find('all', $conditions);
		$cnt = $fds->count();              
		if($fds){
			$total_amount = 0;                   
			 foreach ($fds as $fd){ 
				$total_amount += $fd->amount;
			 }
		} 	  
        $fds = $this->paginate($fds,['order' => ['Fds.id' => 'DESC']]);
        $this->set(compact('fds','total_amount','cnt'));
        $this->set('_serialize', ['fds']);
      }      
 }

    /**
     * View method
     *
     * @param string|null $id Fd id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
   public function view($id = null)
    {
        $fd = $this->Fds->get($id, [
            'contain' => ['Companies','Brokers']
        ]); 
		$companies = TableRegistry::get('Companies');
		$branches = TableRegistry::get('Branches');
		$plans = TableRegistry::get('Plans');
		$banks = TableRegistry::get('Banks');
		$users = TableRegistry::get('Users');
		$brokers = TableRegistry::get('Brokers');
		 if($fd->productcompanyid > 0) {
			$productcompanyid = $companies->find()->where(['id' => $fd->productcompanyid]);
			$data1 = $productcompanyid->toArray();
			$productcompanyName = $data1[0]->company;
			}
			else{
			$productcompanyName = '';
			}
			$this->set('productcompanyName',$productcompanyName);
			
		if($fd->mainbrokerid > 0) {
			$mainbrokerid = $brokers->find()->where(['id' => $fd->mainbrokerid]);
			$data1 = $mainbrokerid->toArray();
			$mainbrokerName = $data1[0]->name;
			//pr()
			}
			else{
			$mainbrokerName = '';
			}
			$this->set('mainbrokerName',$mainbrokerName);	
		if($fd->plan_id > 0) 
		{
			$planid = $plans->find()->where(['id' => $fd->plan_id]);
			$data2 = $planid->toArray();
			$planname = $data2[0]->Planname;
		}
		else{
		$planname = '';
		}
		$this->set('planname',$planname);
		pr($fd->bank_id);
		//die();
		if($fd->bank_id > 0)
		{
			$bank_id = $banks->find()->where(['id' => $fd->bank_id]);
			$data3 = $bank_id->toArray();
			$bankname = $data3[0]->banks;
		}
		else{
		$bankname = '';
		}
		$this->set('bankname',$bankname);
		//pr($fd->posteduserbranchid);
		//die();
		if($fd->posteduserbranchid > 0) {
			$posteduserbranchid = $branches->find()->where(['id' => $fd->posteduserbranchid]);
			$data4 = $posteduserbranchid->toArray();
			$branchname = $data4[0]->branchname;
		}
		else
		{
			$branchname = '';
		}
		$this->set('branchname', $branchname);
		 if($fd->postedby > 0){
            $postedby = $users->find()->where(['id' => $fd->postedby]);
            $data11 = $postedby->toArray();
            $userName = $data11[0]->username;
       }else{
           $userName = '';
       }    
            $this->set('userName', $userName);
       
        //$fd = $this->Fds->get($id);
        $this->set('fd', $fd);
        $this->set('_serialize', ['fd']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        
        if ($this->request->is('ajax','get')) {         
            $terms = $this->Fds->Customers->find('all', [
                'conditions' => array('Customers.name LIKE ' => '%' . $this->request->query["term"] . '%'),
                'limit' => 10
            ]);
          
            $data = array();$data1 = array();
            foreach($terms as $term) {
                $row = $term->name;
                array_push($data, $row);
            }
            $this->autoRender = false;      
            // $this->layout = 'ajax';
            $this->set('terms', $terms);
            echo json_encode($data);
            exit;
            //return json_encode($data);
         }else {
            //echo json_encode('Nothings found');
         }
         
         
        $fd = $this->Fds->newEntity();
        if ($this->request->is('post')) {
            $fd = $this->Fds->patchEntity($fd, $this->request->data);
            $fd->postedby = $this->Auth->user('id');
            $fd->posteduserbranchid = $this->Auth->user('branch_id');
          //  $fd->branch_id = $this->Auth->user('branch_id');
            if($fd->subbroker_id != ''){
                $fd->broker_id = $fd->subbroker_id;
            }else{
                $fd->broker_id = 1;
            }
            
           $custmoerId = $this->getCustomerId($fd->panno);
           if($custmoerId != ''){
                $fd->customer_id = $custmoerId;
            }
            
            if ($this->Fds->save($fd)) {
                $this->Flash->success(__('The fd has been saved.'));

                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The fd could not be saved. Please, try again.'));
            }
        }
        $users = $this->Fds->Customers->find('list')->order(['name' => 'ASC']);
     
        $subbrokers = $this->Fds->Brokers->find('list', [
            'keyField' => 'id',
            'valueField' => 'name'
        ])-> where(['role' => 'Subbroker']);
        $mainbrokers = $this->Fds->Brokers->find('list', [
            'keyField' => 'id',
            'valueField' => 'name'
        ])-> where(['role' => 'Mainbroker']);
        
        $usercompanies = $this->Fds->Companies->find('list')-> where(['associatewith' => 'user'])->order(['company' => 'ASC']);
		$userbranches = $this->Fds->Branches->find('list', ['limit' => 200])->order(['branchname' => 'ASC']);
        //$productcompanies = $this->Fds->Companies->find('list')-> where(['associatewith' => 'product'])->order(['company' => 'DESC']);
        $productcompanies = $this->Fds->Companies->find('list')-> where(['associatewith' => 'product'])->where(['productid LIKE' => '%2%'])->order(['company' => 'ASC']);
        $plans = $this->Fds->Plans->find('list')-> where(['product_id' => 2])->order(['planname' => 'ASC']);
        
        
        //$subbrokers = $this->Fds->Subbrokers->find('list', ['limit' => 200]);
        $banks = $this->Fds->Banks->find('list', ['limit' => 200])->order(['banks' => 'ASC']);
        
        $typeofdeposit = array('fresh'=>'Fresh','renewal'=>'Renewal','both'=>'Both');
       
        
        $this->set(compact('fd','users','mainbrokers','productcompanies', 'usercompanies', 'userbranches', 'plans', 'subbrokers', 'banks', 'bankdetails', 'typeofdeposit'));
       // $this->set(compact('fd', 'companies', 'branches', 'plans', 'subbrokers', 'banks', 'bankdetails'));
        $this->set('_serialize', ['fd']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Fd id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        
        if ($this->request->is('ajax','get')) {         
            $terms = $this->Fds->Customers->find('all', [
                'conditions' => array('Customers.name LIKE ' => '%' . $this->request->query["term"] . '%'),
                'limit' => 10
            ]);
          
            $data = array();$data1 = array();
            foreach($terms as $term) {
                $row = $term->name;
                array_push($data, $row);
            }
            $this->autoRender = false;      
            // $this->layout = 'ajax';
            $this->set('terms', $terms);
            echo json_encode($data);
            exit;
            //return json_encode($data);
         }else {
            //echo json_encode('Nothings found');
         }
         
         
        $fd = $this->Fds->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $fd = $this->Fds->patchEntity($fd, $this->request->data);
            $fd->postedby = $this->Auth->user('id');
            $fd->posteduserbranchid = $this->Auth->user('branch_id');
           // $fd->branch_id = $this->Auth->user('branch_id');
            if($fd->subbroker_id != ''){
                $fd->broker_id = $fd->subbroker_id;
            }else{
                $fd->broker_id = 1;
            }
             $custmoerId = $this->getCustomerId($fd->panno);
           if($custmoerId != ''){
                $fd->customer_id = $custmoerId;
            }
            if ($this->Fds->save($fd)) {
                $this->Flash->success(__('The fd has been saved.'));

                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The fd could not be saved. Please, try again.'));
            }
        }
        $users = $this->Fds->Customers->find('list')->order(['name' => 'ASC']);
        $subbrokers = $this->Fds->Brokers->find('list', [
            'keyField' => 'id',
            'valueField' => 'name'
        ])-> where(['role' => 'Subbroker']);
        $mainbrokers = $this->Fds->Brokers->find('list', [
            'keyField' => 'id',
            'valueField' => 'name'
        ])-> where(['role' => 'Mainbroker']);
        $usercompanies = $this->Fds->Companies->find('list')-> where(['associatewith' => 'user'])->order(['company' => 'ASC']);
		$userbranches = $this->Fds->Branches->find('list', ['limit' => 200])->order(['branchname' => 'ASC']);
        //$productcompanies = $this->Fds->Companies->find('list')-> where(['associatewith' => 'product'])->order(['company' => 'ASC']);
        $productcompanies = $this->Fds->Companies->find('list')-> where(['associatewith' => 'product'])->where(['productid LIKE' => '%2%'])->order(['company' => 'ASC']);
        $plans = $this->Fds->Plans->find('list', ['limit' => 200])->order(['planname' => 'ASC']);
        //$subbrokers = $this->Fds->Subbrokers->find('list', ['limit' => 200]);
        $banks = $this->Fds->Banks->find('list', ['limit' => 200])->order(['banks' => 'ASC']);
        $gender  = array('male'=>'Male','female'=>'Female');
        $typeofdeposit = array('fresh'=>'Fresh','renewal'=>'Renewal','both'=>'Both');
        $tenure = array('12'=>'12 Month','24'=>'24 Month','36'=>'36 Month','48'=>'48 Month','60'=>'60 Month','72'=>'72 Month');
        $interestmode = array('monthly'=>'Monthly','quarterly'=>'Quarterly','halfyearly'=>'Half Yearly','yearly'=>'Annual');
        $paymentoption = array('cheque'=>'Cheque','rtgs'=>'RTGS/NEFT','utrno'=>'If RTGS/NEFT, UTR No');
        $kycdocument = array(
            'Passport'=> 'Passport',
            'PAN Card with Address proof'=> 'PAN Card with Address proof',
            'Voters Identity Card issued by Election Commission of India'=> 'Voters Identity Card issued by Election Commission of India',
            'Driving License'=> 'Driving License',
            'Job card issued by NREGA duly signed by an officer of the State Government'=> 'Job card issued by NREGA duly signed by an officer of the State Government',
            'The letter issued by Unique Identification Authority of India containing details of
Name, Address & Aadhar Number'=> 'The letter issued by Unique Identification Authority of India containing details of
Name, Address & Aadhar Number',
            'Utility Bill (Electricity/Telephone/Postpaid mobile phone/Piped Gas/Water Bill) not more than 2 months old'=> 'Utility Bill (Electricity/Telephone/Postpaid mobile phone/Piped Gas/Water Bill) not more than 2 months old',
            'Bank Account or Post Office saving bank account statement'=> 'Bank Account or Post Office saving bank account statement',
            'Others'=> 'Others (Kindly Specify)'
        );
        $this->set(compact('fd','users','mainbrokers','productcompanies', 'usercompanies', 'userbranches', 'plans', 'subbrokers', 'banks', 'bankdetails', 'typeofdeposit','tenure','interestmode','paymentoption','kycdocument','gender'));
      
        //$this->set(compact('fd', 'companies', 'branches', 'plans', 'subbrokers', 'banks', 'bankdetails'));
        $this->set('_serialize', ['fd']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Fd id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $fd = $this->Fds->get($id);
        if ($this->Fds->delete($fd)) {
            $this->Flash->success(__('The fd has been deleted.'));
        } else {
            $this->Flash->error(__('The fd could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
    
	
	
    public function getuserinfo(){
        $id = $this->request->query('id');
        if (!$id) {
            throw new NotFoundException();
        }   
        $query = $this->Fds->Customers->find('all',['conditions' => array('Customers.name LIKE ' => '%' . $id . '%')]);    
        $data = $query->toArray();       
        $this->set(compact('data')); 
           
    }
    public function getplan(){
        $id = $this->request->query('id');
        if (!$id) {
            throw new NotFoundException();
        }   
        $dataplan = $this->Fds->Plans->find('all',['conditions' => ['company_id' => $id, 'product_id' => '2']]); 
        $this->set(compact('dataplan')); 
    }
    public function getplaninfo(){
        $pid = $this->request->query('plan-id');
        $tenure = $this->request->query('tenure');
        if (!$pid && !$tenure) {
            throw new NotFoundException();
        } 
        $query = $this->Fds->Plans->find('all',['conditions' => ['id' => $pid,'tenure' => $tenure]]);        
        $data = $query->toArray();       
        $this->set(compact('data')); 
    }
    
    public function getbankinfo(){
        $id = $this->request->query('id');
        if (!$id) {
            throw new NotFoundException();
        }   
        $data = $this->Fds->Bankbranches->find('all',['conditions' => ['id' => $id]]); 
        $this->set(compact('data')); 
    }
    
    
}
