<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;
/**
 * Customers Controller
 *
 * @property \App\Model\Table\CustomersTable $Customers
 */
class CustomersController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
         
         $all = array('all'=>'All');
         $this->Search->addFilter('name', [
        'attributes'=>['placeholder'=>'Customer Name','label'=>'Customer Name :','class'=>'searchfrm',],  
        'options' => $all+$this->Customers->find('list',['keyField'=>'name','valueField'=>'name'])->order(['name' => 'ASC'])->toArray(),
      ]);
      /*  $this->paginate = [
            'contain' => [ 'Companies', 'Branches']
        ];
        */
          if (!empty($this->request->query['name'])) { 
	  $firstname = $this->request->query['name']; 
	  if ($firstname){ $conditions['conditions']['or']['name LIKE'] = "%$firstname%"; }
      if ( $firstname != '' && $firstname != 'all' ) { 
               $customers = $this->Customers->find('all', $conditions);

			    $customers = $this->paginate($customers);
            }else{
               $customers = $this->Customers;
			    $customers = $this->paginate($customers,['order' =>['Customers.name'=>'ASC']]);
            }  
			
		$this->set(compact('customers'));
        $this->set('_serialize', ['customers']);			
}			
      else
	  {
	  
        $customers = $this->paginate($this->Customers,['order' =>['Customers.name'=>'ASC'],['conditions'=>['Customers.status'=>0]]]);

        $this->set(compact('customers'));
        $this->set('_serialize', ['customers']);
	  
	  }
    }
    /**
     * View method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {   //'Companies', 'Branches'
       $customer = $this->Customers->get($id, [
            'contain' => []
        ]);
     
        $this->set('customer', $customer);
        $this->set('_serialize', ['customer']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $customer = $this->Customers->newEntity();
        if ($this->request->is('post')) {
            $customer = $this->Customers->patchEntity($customer, $this->request->data);
            
             /* insert account no */
			  
            $query = $this->Customers->find('all', ['order' => ['Customers.created' => 'DESC']]);
			
            
             $lastuid = $query->first()->id;  
           
            $accountNo = (1000 + ($lastuid + 1));
            $customer->accountno = $accountNo;
            
            if ($this->Customers->save($customer)) {
                $this->Flash->success(__('The customer has been saved.'));

                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The customer could not be saved. Please, try again.'));
            }
        }
       // $groups = $this->Customers->Groups->find('list', ['limit' => 200]);
        $companies = $this->Customers->Companies->find('list', ['limit' => 200])->order(['company' => 'ASC']);
        $branches = $this->Customers->Branches->find('list', ['limit' => 200])->order(['branchname' => 'ASC']);
        $gender  = array('male'=>'Male','female'=>'Female');
        $this->set(compact('customer',  'companies', 'branches','gender'));
        $this->set('_serialize', ['customer']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $customer = $this->Customers->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $customer = $this->Customers->patchEntity($customer, $this->request->data);
            if ($this->Customers->save($customer)) {
                $this->Flash->success(__('The customer has been saved.'));

                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The customer could not be saved. Please, try again.'));
            }
        }
        //$groups = $this->Customers->Groups->find('list', ['limit' => 200]);
        $companies = $this->Customers->Companies->find('list', ['limit' => 200])->order(['company' => 'ASC']);
        $branches = $this->Customers->Branches->find('list', ['limit' => 200])->order(['branchname' => 'ASC']);
        $gender  = array('male'=>'Male','female'=>'Female');
        $this->set(compact('customer', 'companies', 'branches','gender'));
        $this->set('_serialize', ['customer']);
    }    

    /**
     * Delete method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $customer = $this->Customers->get($id);
		$customer->status=0;
		if ($this->Customers->save($customer)) {
                $this->Flash->success(__('The customer has been delete.'));
		}
        
        
		

        return $this->redirect(['action' => 'index']);
    }
		 
			  
    
	   public function del(){
		   
			 $del=$this->Customers->find('all',['conditions'=>['Customers.status'=>0]]);
			  $this->set('del',$del);
			  
}
    public function ud($id= null){
		 
		 $customer = $this->Customers->get($id);
		 $customer->status=1;
		 if($this->Customers->save($customer)){
			 $this->Flash->success(__('your data has been undo '));
			 
		 }
		   return $this->redirect(['action' => 'del']);
	}
		  
}
        
?>
