<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;
/**
 * Customers Controller
 *
 * @property \App\Model\Table\CustomersTable $Customers
 */
class CustomersController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
         
         //$all = array('all'=>'All');
         //$this->Search->addFilter('firstname', [
        //'attributes'=>['placeholder'=>'Customer Name','label'=>'Customer Name :','class'=>'searchfrm',],  
        //'options' => $all+$this->Customers->find('list',['keyField'=>'firstname','valueField'=>'firstname'])->order(['Firstname' => 'ASC'])->toArray(),
      //]);
      /*  $this->paginate = [
            'contain' => [ 'Companies', 'Branches']
        ];
        */
        
        $this->Search->addFilter('firstname',['attributes'=>['placeholder'=>'Customer Name','label'=>'Customer Name','class'=>'serachfrm','id'=>'autocomplete','value'=>''],]);
        
        if ($this->request->is('ajax','get')) {         
            $terms = $this->Customers->find('all', [
                'conditions' => array('Customers.firstname LIKE ' => '%' . $this->request->query["term"] . '%', 'Customers.status !='=>0),
                'limit' => 10
            ]);
            $data = array();$data1 = array();
            foreach($terms as $term) {
                $row = $term->firstname;
                array_push($data, $row);
            }
            $this->autoRender = false;      
            $this->set('terms', $terms);
            echo json_encode($data);
            exit;
            //return json_encode($data);
         }
        
         if (!empty($this->request->query['firstname'])) { 
	     $firstname = $this->request->query['firstname']; 
	     if ($firstname){ $conditions['conditions']['or']['firstname LIKE'] = "%$firstname%"; }
	     
	     //conditions['Customers.status !='] = 0;
	     $conditions['conditions']['and']['status !='] = "0";
	     
	     
         if ( $firstname != '' && $firstname != 'all' ) { 
               $customers = $this->Customers->find('all', $conditions);

			    $customers = $this->paginate($customers);
            }else{
               $customers = $this->Customers;
			    $customers = $this->paginate($customers,['order' =>['Customers.firstname'=>'ASC']]);
            }  
			
		$this->set(compact('customers'));
        $this->set('_serialize', ['customers']);			
}			
      else
	  {
	  
        //$customers = $this->paginate($this->Customers,['order' =>['Customers.name'=>'ASC'],['conditions'=>['Customers.status'=>0]]]);
        $customers = array();
        $this->set(compact('customers'));
        $this->set('_serialize', ['customers']);
	  
	  }
    }
    /**
     * View method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {   //'Companies', 'Branches'
       $customer = $this->Customers->get($id, [
            'contain' => []
        ]);
     
        $this->set('customer', $customer);
        $this->set('_serialize', ['customer']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $customer = $this->Customers->newEntity();
        if ($this->request->is('post')) {
            $customer = $this->Customers->patchEntity($customer, $this->request->data);
            
            $product_id = $this->request->data['product_id'];
			$product_id = implode(',',$product_id);
			$customer->product_id = $product_id;
             /* insert account no */
            $query = $this->Customers->find('all', ['order' => ['Customers.created' => 'DESC']]);
            $lastuid = $query->first()->id;  
            $accountNo = (1000 + ($lastuid + 1));
            $customer->accountno = $accountNo;
            
            if ($this->Customers->save($customer)) {
                $this->Flash->success(__('The customer has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The customer could not be saved. Please, try again.'));
            }
        }
       // $groups = $this->Customers->Groups->find('list', ['limit' => 200]);
        $companies = $this->Customers->Companies->find('list', ['limit' => 200])->order(['company' => 'ASC']);
        $branches = $this->Customers->Branches->find('list', ['limit' => 200])->order(['branchname' => 'ASC']);
         //$products =TableRegistry::get('Products')->find('list', ['fields' => ['productname', 'id']])->toArray();
        $this->loadModel('Products');
        $products = $this->Products->find('list', ['limit' => 200])->order(['id' => 'ASC']);
        //pr($products);
        //die();
        $gender  = array('male'=>'Male','female'=>'Female');
        $this->set(compact('customer',  'companies', 'branches', 'products', 'gender'));
        $this->set('_serialize', ['customer']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $customer = $this->Customers->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $customer = $this->Customers->patchEntity($customer, $this->request->data);
            $product_id = $this->request->data['product_id'];
			$product_id = implode(',',$product_id);
			$customer->product_id = $product_id;
            if ($this->Customers->save($customer)) {
                $this->Flash->success(__('The customer has been saved.'));

                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The customer could not be saved. Please, try again.'));
            }
        }
        //$groups = $this->Customers->Groups->find('list', ['limit' => 200]);
        //$companies = $this->Customers->Companies->find('list', ['limit' => 200])->order(['company' => 'ASC']);
        $branches = $this->Customers->Branches->find('list', ['limit' => 200])->order(['branchname' => 'ASC']);
        $this->loadModel('Products');
        $products = $this->Products->find('list', ['limit' => 200])->order(['id' => 'ASC']);
        $gender  = array('male'=>'Male','female'=>'Female');
        $selected = $customer->product_id;
		$selectedprod = explode(',',$selected);

        $this->set(compact('customer', 'companies', 'branches','products','selectedprod','gender'));
        $this->set('_serialize', ['customer']);
    }    

    /**
     * Delete method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $customer = $this->Customers->get($id);
		$customer->status=0;
		if ($this->Customers->save($customer)) {
                $this->Flash->success(__('The customer has been delete.'));
		}
        return $this->redirect(['action' => 'index']);
    }
		 
	public function del(){
		$del=$this->Customers->find('all',['conditions'=>['Customers.status'=>0]]);
		$this->set('del',$del);
    }
    public function ud($id= null){
		 $customer = $this->Customers->get($id);
		 $customer->status=1;
		 if($this->Customers->save($customer)){
			 $this->Flash->success(__('your data has been undo '));
			 
		 }
		   return $this->redirect(['action' => 'del']);
	}
	
	public function customermodify(){
        //$all = array('all'=>'All');
        //$this->Search->addFilter('firstname', [
        //'attributes'=>['placeholder'=>'Customer Name','label'=>'Customer Name :','class'=>'searchfrm',],  
        //'options' => $all+$this->Customers->find('list',['keyField'=>'firstname','valueField'=>'firstname'])->order(['Firstname' => 'ASC'])->toArray(),
        //]);
        
        //$this->Search->addFilter('firstname',['attributes'=>['placeholder'=>'Customer Name','label'=>'Customer Name','class'=>'serachfrm','id'=>'autocomplete','value'=>''],]);
        $this->Search->addFilter('name',['attributes'=>['placeholder'=>'Enter Name','label'=>'Enter Name','class'=>'serachfrm','value'=>''],]);
        $this->Search->addFilter('address',['attributes'=>['placeholder'=>'Enter Address','label'=>'Enter Address','class'=>'serachfrm','value'=>''],]);
		//$this->Search->addFilter('address2',['attributes'=>['placeholder'=>'Enter Address2','label'=>'Enter Address2','class'=>'serachfrm','value'=>isset($this->request->query['address2'])?$this->request->query['address2']:''],]);
		$this->Search->addFilter('mobile',['attributes'=> ['placeholder' => 'Customer mobile','label'=>'Mobile No','class'=>'serachfrm','value'=>''],]);
      
        /*
        if ($this->request->is('ajax','get')) {         
            $terms = $this->Customers->find('all', [
                'conditions' => array('Customers.firstname LIKE ' => '%' . $this->request->query["term"] . '%','Customers.status !='=> 0),
                'limit' => 10
            ]);
            $data = array();$data1 = array();
            foreach($terms as $term) {
                $row = $term->firstname;
                array_push($data, $row);
            }
            $this->autoRender = false;      
            $this->set('terms', $terms);
            echo json_encode($data);
            exit;
            //return json_encode($data);
         }
         */
      
      if(!empty($this->request->query['name']) || !empty($this->request->query['mobile']) || !empty($this->request->query['address'])){
		    //$fname = $this->request->query['firstname'];
		    $freename = $this->request->query['name'];
		    $mobile = $this->request->query['mobile'];
			$address = $this->request->query['address'];
			//$address2 = $this->request->query['address2'];
			$conditions = '';
		   
			//if($fname){
			  // $conditions['conditions']['and']['Customers.firstname'] ="$fname";
			//}
			
			if($freename){
			   $conditions['conditions']['and']['Customers.firstname LIKE'] ="%$freename%";
			}
			
			if($mobile){
			   $conditions['conditions']['and']['Customers.mobile'] ="$mobile";
			}
			if($address){
			   $conditions['conditions']['or']['Customers.address2 LIKE'] ="%$address%";
			   $conditions['conditions']['or']['Customers.address1 LIKE'] ="%$address%";
			}
			$conditions['conditions']['and']['Customers.status !='] ="0";
			$customers = $this->Customers->find('all', $conditions);
			$customers = $this->paginate($customers);
			$this->set(compact('customers'));
			$this->set('_serialize','customers');
        }else{
           // $customers = $this->paginate($this->Customers,['order' =>['Customers.name'=>'ASC'],['conditions'=>['Customers.status'=>0]]]);
            $customers = array();
            $this->set(compact('customers'));
            $this->set('_serialize', ['customers']);
	    }
    }
		  
}
        
?>
